/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.lex;

import java.util.ArrayList;
import miworkplace.ast.rpg.ControlParameters;
import miworkplace.ast.rpg.Helper;
import miworkplace.ast.rpg.token.CharacterString;
import miworkplace.ast.rpg.token.Comment;
import miworkplace.ast.rpg.token.Include;
import miworkplace.ast.rpg.token.Number;
import miworkplace.ast.rpg.token.Parenthesis;
import miworkplace.ast.rpg.token.SpecificationType;
import miworkplace.ast.rpg.token.UnknownToken;
import miworkplace.ast.rpg.token.control.Keyword;
import miworkplace.ast.rpg.token.control.Parameter;
import miworkplace.ast.rpg.token.control.ParameterSeparator;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.ast.rpg.tokenizer.Token;

public class Lexer {
    public static Token[] scan(Token[] tokens) {
        ArrayList<SpecificationType> tokenlist = new ArrayList<SpecificationType>();
        SpecificationType lastAddedToken = null;
        Token token = null;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].getLine().getLineType().equals((Object)LineType.Header)) {
                if (tokens[i].getPosition() == 6) {
                    token = new SpecificationType(tokens[i]);
                } else if (tokens[i].getData().equals("(")) {
                    token = new Parenthesis(tokens[i]);
                } else if (tokens[i].getData().equals(")")) {
                    token = new Parenthesis(tokens[i]);
                } else if (tokens[i].getData().equals("'")) {
                    Token start = tokens[i];
                    StringBuilder tmp = new StringBuilder();
                    tmp.append(tokens[i].getData());
                    boolean running = true;
                    while (running && i < tokens.length) {
                        if (tokens[++i].getData().equals("'")) {
                            if (i <= 0 || !tokens[i - 1].getData().endsWith("\\")) {
                                running = false;
                            }
                            tmp.append(tokens[i].getData());
                            continue;
                        }
                        tmp.append(tokens[i].getData());
                    }
                    Token tmpToken = new Token(tmp.toString());
                    tmpToken.setLine(start.getLine());
                    tmpToken.setLineNumber(start.getLineNumber());
                    tmpToken.setParent(start.getParent());
                    tmpToken.setPosition(start.getPosition());
                    token = new CharacterString(tmpToken);
                } else if (Keyword.keywords.containsKey(tokens[i].getData().toUpperCase())) {
                    token = new Keyword(tokens[i]);
                    ((Keyword)token).setType(Keyword.keywords.get(tokens[i].getData().toUpperCase()));
                } else if (ControlParameters.parameters.containsValue((Object)tokens[i].getData().toUpperCase()) || ControlParameters.dateformats.contains(tokens[i].getData().toUpperCase()) || ControlParameters.timeformats.contains(tokens[i].getData().toUpperCase())) {
                    token = new Parameter(tokens[i]);
                } else if (Helper.isNumber(tokens[i].getData())) {
                    token = new Number(tokens[i]);
                } else if (ControlParameters.dateformatSeparators.contains(tokens[i].getData()) && ControlParameters.dateformats.contains(lastAddedToken.getData().toUpperCase())) {
                    Token t = new Token(lastAddedToken.getData() + tokens[i].getData());
                    t.setLine(lastAddedToken.getLine());
                    t.setLineNumber(lastAddedToken.getLineNumber());
                    t.setParent(lastAddedToken.getParent());
                    t.setPosition(lastAddedToken.getPosition());
                    token = new Parameter(t);
                    tokenlist.remove(lastAddedToken);
                } else if (ControlParameters.timeformatSeparators.contains(tokens[i].getData()) && ControlParameters.timeformats.contains(lastAddedToken.getData().toUpperCase())) {
                    Token t = new Token(lastAddedToken.getData() + tokens[i].getData());
                    t.setLine(lastAddedToken.getLine());
                    t.setLineNumber(lastAddedToken.getLineNumber());
                    t.setParent(lastAddedToken.getParent());
                    t.setPosition(lastAddedToken.getPosition());
                    token = new Parameter(t);
                    tokenlist.remove(lastAddedToken);
                } else {
                    token = tokens[i].getData().equals(":") ? new ParameterSeparator(tokens[i]) : new UnknownToken(tokens[i]);
                }
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Procedure)) {
                if (tokens[i].getPosition() == 6) {
                    token = new SpecificationType(tokens[i]);
                } else if (tokens[i].getPosition() < 80) {
                    token = new CharacterString(tokens[i]);
                } else {
                    int commentLineNumber = tokens[i].getLineNumber();
                    StringBuilder commentText = new StringBuilder();
                    Token commentToken = tokens[i];
                    if (Comment.COMMENT_START.contains(tokens[i].getData())) {
                        ++i;
                    }
                    while (i < tokens.length && tokens[i].getLineNumber() == commentLineNumber) {
                        commentText.append(tokens[i].getData() + " ");
                        ++i;
                    }
                    if (i < tokens.length) {
                        --i;
                    }
                    comment = new Token(commentText.toString().trim());
                    comment.setLine(commentToken.getLine());
                    comment.setLineNumber(commentToken.getLineNumber());
                    comment.setPosition(commentToken.getPosition());
                    token = new Comment(comment);
                }
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Comment)) {
                int commentLineNumber = tokens[i].getLineNumber();
                StringBuilder commentText = new StringBuilder();
                Token commentToken = tokens[i];
                if (Comment.COMMENT_START.contains(tokens[i].getData())) {
                    ++i;
                }
                while (i < tokens.length && tokens[i].getLineNumber() == commentLineNumber) {
                    commentText.append(tokens[i].getData() + " ");
                    ++i;
                }
                if (i < tokens.length) {
                    --i;
                }
                comment = new Token(commentText.toString().trim());
                comment.setLine(commentToken.getLine());
                comment.setLineNumber(commentToken.getLineNumber());
                comment.setPosition(commentToken.getPosition());
                token = new Comment(comment);
            } else if (tokens[i].getLine().getLineType().equals((Object)LineType.Copy) || tokens[i].getLine().getLineType().equals((Object)LineType.Include)) {
                StringBuffer includedFile = new StringBuffer();
                int includeLineNumber = tokens[i].getLineNumber();
                Token directiveToken = tokens[i];
                ++i;
                while (i < tokens.length && tokens[i].getLineNumber() == includeLineNumber) {
                    includedFile.append(tokens[i].getData());
                    ++i;
                }
                if (i < tokens.length) {
                    --i;
                }
                token = new Include(new Token(directiveToken.getData() + " " + includedFile.toString()));
                ((Include)token).setIncludedFile(includedFile.toString());
                token.setLineNumber(includeLineNumber);
                token.setLine(directiveToken.getLine());
                token.setPosition(directiveToken.getPosition());
            } else {
                token = tokens[i].getLine().getLineType().equals((Object)LineType.IledocsStart) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.Iledocs) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.IledocsEnd) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.Declaration) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.FreeForm) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.File) ? tokens[i] : (tokens[i].getLine().getLineType().equals((Object)LineType.Calculation) ? tokens[i] : null))))));
            }
            if (token != null) {
                tokenlist.add((SpecificationType)token);
            }
            lastAddedToken = token;
            ++i;
        }
        return tokenlist.toArray(new Token[tokenlist.size()]);
    }
}

