/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.iledocs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import miworkplace.ast.rpg.iledocs.Link;
import miworkplace.ast.rpg.iledocs.Revision;

public class ILEDocs {
    public static final String ILEDOCS_START_TAG = "/**";
    public static final String ILEDOCS_TAG = "*";
    public static final String ILEDOCS_END_TAG = "*/";
    private HashMap<Tag, Object> entries = new HashMap();
    private Object documentedObject;
    private int startLine = -1;
    private int endLine = -1;

    public void setBriefDescription(String brief) {
        this.entries.put(Tag.BRIEF, brief);
    }

    public String getBriefDescription() {
        return this.entries.containsKey((Object)Tag.BRIEF) ? this.entries.get((Object)Tag.BRIEF).toString() : "";
    }

    public void setDescription(String description) {
        this.entries.put(Tag.DESCRIPTION, description);
    }

    public String getDescription() {
        return this.entries.containsKey((Object)Tag.DESCRIPTION) ? this.entries.get((Object)Tag.DESCRIPTION).toString() : "";
    }

    public void setAuthor(String author) {
        this.entries.put(Tag.AUTHOR, author);
    }

    public String getAuthor() {
        return this.entries.containsKey((Object)Tag.AUTHOR) ? this.entries.get((Object)Tag.AUTHOR).toString() : "";
    }

    public void setDate(String date) {
        this.entries.put(Tag.DATE, date);
    }

    public String getDate() {
        return this.entries.containsKey((Object)Tag.DATE) ? this.entries.get((Object)Tag.DATE).toString() : "";
    }

    public void addRevision(Revision revision) {
        List<Revision> revisions = null;
        if (this.entries.containsKey((Object)Tag.REVISION)) {
            revisions = (List)this.entries.get((Object)Tag.REVISION);
        } else {
            revisions = new ArrayList();
            this.entries.put(Tag.REVISION, revisions);
        }
        revisions.add(revision);
    }

    public void addLink(Link link) {
        List<Link> links = null;
        if (this.entries.containsKey((Object)Tag.LINK)) {
            links = (List)this.entries.get((Object)Tag.LINK);
        } else {
            links = new ArrayList();
            this.entries.put(Tag.LINK, links);
        }
        links.add(link);
    }

    public Revision[] getRevisions() {
        if (this.entries.containsKey((Object)Tag.REVISION)) {
            List revisions = (List)this.entries.get((Object)Tag.REVISION);
            return revisions.toArray(new Revision[revisions.size()]);
        }
        return new Revision[0];
    }

    public Link[] getLinks() {
        if (this.entries.containsKey((Object)Tag.LINK)) {
            List links = (List)this.entries.get((Object)Tag.LINK);
            return links.toArray(new Link[links.size()]);
        }
        return new Link[0];
    }

    public void setTask(String task) {
        this.entries.put(Tag.TASK, task);
    }

    public String getTask() {
        return this.entries.containsKey((Object)Tag.TASK) ? this.entries.get((Object)Tag.TASK).toString() : "";
    }

    public void setCritical(boolean critical) {
        if (critical) {
            this.entries.put(Tag.CRITICAL, Boolean.TRUE);
        }
    }

    public boolean isCritical() {
        return this.entries.containsKey((Object)Tag.CRITICAL);
    }

    public void setDeprecated(String description) {
        this.entries.put(Tag.DEPRECATED, description);
    }

    public boolean isDeprecated() {
        return this.entries.containsKey((Object)Tag.DEPRECATED);
    }

    public String getDeprecatedDescription() {
        return this.entries.containsKey((Object)Tag.DEPRECATED) ? this.entries.get((Object)Tag.DEPRECATED).toString() : "";
    }

    public void addInfo(String info) {
        List<String> infos;
        if (this.entries.containsKey((Object)Tag.INFO)) {
            infos = (List)this.entries.get((Object)Tag.INFO);
        } else {
            infos = new ArrayList();
            this.entries.put(Tag.INFO, infos);
        }
        infos.add(info);
    }

    public String[] getInfos() {
        if (this.entries.containsKey((Object)Tag.INFO)) {
            List infos = (List)this.entries.get((Object)Tag.INFO);
            return infos.toArray(new String[infos.size()]);
        }
        return new String[0];
    }

    public void addWarning(String warning) {
        List<String> warnings;
        if (this.entries.containsKey((Object)Tag.WARNING)) {
            warnings = (List)this.entries.get((Object)Tag.WARNING);
        } else {
            warnings = new ArrayList();
            this.entries.put(Tag.WARNING, warnings);
        }
        warnings.add(warning);
    }

    public String[] getWarnings() {
        if (this.entries.containsKey((Object)Tag.WARNING)) {
            List warnings = (List)this.entries.get((Object)Tag.WARNING);
            return warnings.toArray(new String[warnings.size()]);
        }
        return new String[0];
    }

    public void addParameterDescription(String parameterDescription) {
        List<String> parameters;
        if (this.entries.containsKey((Object)Tag.PARAMETER)) {
            parameters = (List)this.entries.get((Object)Tag.PARAMETER);
        } else {
            parameters = new ArrayList();
            this.entries.put(Tag.PARAMETER, parameters);
        }
        parameters.add(parameterDescription);
    }

    public String[] getParameterDescriptions() {
        if (this.entries.containsKey((Object)Tag.PARAMETER)) {
            List parameters = (List)this.entries.get((Object)Tag.PARAMETER);
            return parameters.toArray(new String[parameters.size()]);
        }
        return new String[0];
    }

    public String getParameterDescription(int parameter) {
        if (!this.entries.containsKey((Object)Tag.PARAMETER)) {
            return "";
        }
        List parameters = (List)this.entries.get((Object)Tag.PARAMETER);
        if (parameters.size() - 1 >= parameter) {
            return (String)parameters.get(parameter);
        }
        return "";
    }

    public void setReturnValueDescription(String returnValueDescription) {
        this.entries.put(Tag.RETURN, returnValueDescription);
    }

    public String getReturnValueDescription() {
        if (this.entries.containsKey((Object)Tag.RETURN)) {
            return this.entries.get((Object)Tag.RETURN).toString();
        }
        return "";
    }

    public void setDocumentedObject(Object documentedObject) {
        this.documentedObject = documentedObject;
    }

    public Object getDocumentedObject() {
        return this.documentedObject;
    }

    public void setStartLine(int line) {
        this.startLine = line;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setProject(String project) {
        this.entries.put(Tag.PROJECT, project);
    }

    public String getProject() {
        return this.entries.containsKey((Object)Tag.PROJECT) ? this.entries.get((Object)Tag.PROJECT).toString() : null;
    }

    public static enum KeywordLineStyle {
        MULTI_LINE_STYLE,
        SINGLE_LINE_STYLE;

    }

    public static enum Tag {
        AUTHOR("author", "\\author", KeywordLineStyle.SINGLE_LINE_STYLE),
        DATE("date", "\\date", KeywordLineStyle.SINGLE_LINE_STYLE),
        BRIEF("brief", "\\brief", KeywordLineStyle.SINGLE_LINE_STYLE),
        LINK("link", "\\link", KeywordLineStyle.MULTI_LINE_STYLE),
        DESCRIPTION("description", "\\description", KeywordLineStyle.MULTI_LINE_STYLE),
        REVISION("revision", "\\rev", KeywordLineStyle.MULTI_LINE_STYLE),
        TASK("task", "\\task", KeywordLineStyle.SINGLE_LINE_STYLE),
        CRITICAL("critical", "\\critical", KeywordLineStyle.SINGLE_LINE_STYLE),
        DEPRECATED("deprecated", "\\deprecated", KeywordLineStyle.MULTI_LINE_STYLE),
        RETURN("return", "\\return", KeywordLineStyle.MULTI_LINE_STYLE),
        PARAMETER("parameter", "\\param", KeywordLineStyle.MULTI_LINE_STYLE),
        WARNING("warning", "\\warning", KeywordLineStyle.MULTI_LINE_STYLE),
        INFO("info", "\\info", KeywordLineStyle.MULTI_LINE_STYLE),
        PROJECT("project", "\\project", KeywordLineStyle.SINGLE_LINE_STYLE);

        private final String name;
        private final String keyword;
        private final KeywordLineStyle style;

        private Tag(String name, String keyword, KeywordLineStyle style) {
            this.name = name;
            this.keyword = keyword;
            this.style = style;
        }

        String getName() {
            return this.name;
        }

        KeywordLineStyle getStyle() {
            return this.style;
        }

        String getKeyword() {
            return this.keyword;
        }

        public String toString() {
            return this.name;
        }
    }
}

