/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import miworkplace.ast.rpg.ASTEvent;
import miworkplace.ast.rpg.File;
import miworkplace.ast.rpg.IEventListener;
import miworkplace.ast.rpg.PositionalAbstractProgramFragment;
import miworkplace.ast.rpg.Procedure;
import miworkplace.ast.rpg.Program;
import miworkplace.ast.rpg.Prototype;
import miworkplace.ast.rpg.Subroutine;
import miworkplace.ast.rpg.Task;
import miworkplace.ast.rpg.iledocs.ILEDocs;
import miworkplace.ast.rpg.token.Include;
import miworkplace.ast.rpg.token.control.Keyword;
import miworkplace.ast.rpg.tokenizer.Line;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.ast.rpg.tokenizer.Token;

public class AST {
    private HashMap<String, Object> properties = new HashMap();
    private ArrayList<IEventListener> listeners = new ArrayList();
    private Program program;
    private ArrayList<Token> tokenlist = new ArrayList();
    private ArrayList<Keyword> controlKeywords = new ArrayList();
    private ArrayList<Procedure> procedures = new ArrayList();
    private ArrayList<Task> tasks = new ArrayList();
    private HashMap<Integer, Line> lines = new HashMap();
    private ArrayList<Include> includes = new ArrayList();
    private ArrayList<ILEDocs> iledocsComments = new ArrayList();
    private List<PositionalAbstractProgramFragment> documentableFragments = new ArrayList<PositionalAbstractProgramFragment>();
    private ArrayList<Prototype> prototypes = new ArrayList();
    private List<Subroutine> subroutines = new ArrayList<Subroutine>();
    private List<File> files = new ArrayList<File>();

    public void clear() {
        this.tokenlist.clear();
        this.controlKeywords.clear();
        this.procedures.clear();
        this.lines.clear();
        this.tasks.clear();
        this.includes.clear();
        this.iledocsComments.clear();
        this.prototypes.clear();
        this.program = null;
    }

    public void addToken(Token token) {
        this.tokenlist.add(token);
        if (!this.lines.containsKey(token.getLineNumber())) {
            this.lines.put(token.getLineNumber(), token.getLine());
        }
    }

    public void addTokens(Token[] tokens) {
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            this.addToken(token);
            ++n2;
        }
    }

    public void addTokens(Collection<Token> tokens) {
        for (Token token : tokens) {
            this.addToken(token);
        }
    }

    public void removeToken(Token token) {
        this.tokenlist.remove(token);
        token.getLine().removeToken(token);
        if (token.getLine().count() == 0) {
            this.lines.remove(token.getLineNumber());
        }
    }

    public int getTokenCount() {
        return this.tokenlist.size();
    }

    public Iterator<Token> getTokenListIterator() {
        return this.tokenlist.iterator();
    }

    public void addControlKeyword(Keyword keyword) {
        this.controlKeywords.add(keyword);
    }

    public Keyword[] getControlKeywords() {
        return this.controlKeywords.toArray(new Keyword[this.controlKeywords.size()]);
    }

    public boolean containsControlKeyword(Keyword.Keywords keyword) {
        for (Keyword k : this.controlKeywords) {
            if (!k.getType().equals((Object)keyword)) continue;
            return true;
        }
        return false;
    }

    public Keyword[] getControlKeyword(Keyword.Keywords keyword) {
        ArrayList<Keyword> tmpKeywords = new ArrayList<Keyword>();
        for (Keyword k : this.controlKeywords) {
            if (!k.getType().equals((Object)keyword)) continue;
            tmpKeywords.add(k);
        }
        return tmpKeywords.toArray(new Keyword[tmpKeywords.size()]);
    }

    public boolean isFreeFormLine(int line) {
        LineType lineType = null;
        int i = line;
        while (i >= 0) {
            if (this.lines.containsKey(i)) {
                lineType = this.lines.get(i).getLineType();
                if (lineType.equals((Object)LineType.FreeForm)) {
                    return true;
                }
                if (lineType.equals((Object)LineType.FreeFormEnd)) {
                    return false;
                }
                if (lineType.equals((Object)LineType.FreeFormStart)) {
                    return i != line;
                }
            }
            --i;
        }
        return false;
    }

    public LineType getLineType(int lineNumber) {
        LineType type = LineType.Empty;
        Line line = this.lines.get(lineNumber);
        if (line != null) {
            type = line.getLineType();
        } else if (this.isFreeFormLine(lineNumber)) {
            type = LineType.FreeForm;
        }
        return type;
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public void addProcedure(Procedure procedure) {
        this.procedures.add(procedure);
        this.documentableFragments.add(procedure);
    }

    public void removeProcedure(Procedure procedure) {
        this.procedures.remove(procedure);
        this.documentableFragments.remove(procedure);
    }

    public void removeProcedure(String name) {
        for (Procedure procedure : this.procedures) {
            if (!procedure.getName().equals(name)) continue;
            this.procedures.remove(procedure);
            this.documentableFragments.remove(procedure);
            break;
        }
    }

    public Procedure[] getProcedures() {
        return this.procedures.toArray(new Procedure[this.procedures.size()]);
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public Procedure getProcedure(String name) {
        for (Procedure procedure : this.procedures) {
            if (!procedure.getName().equals(name)) continue;
            return procedure;
        }
        return null;
    }

    public void addDocumentation(ILEDocs comment) {
        this.iledocsComments.add(comment);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
    }

    public Task[] getTasks() {
        return this.tasks.toArray(new Task[this.tasks.size()]);
    }

    public void addInclude(Include include) {
        this.includes.add(include);
    }

    public void removeInclude(Include include) {
        this.includes.remove(include);
    }

    public Include[] getIncludes() {
        return this.includes.toArray(new Include[this.includes.size()]);
    }

    public void addPrototype(Prototype prototype) {
        this.prototypes.add(prototype);
        this.documentableFragments.add(prototype);
    }

    public Prototype[] getPrototypes() {
        return this.prototypes.toArray(new Prototype[this.prototypes.size()]);
    }

    public ILEDocs[] getDocumentation() {
        return this.iledocsComments.toArray(new ILEDocs[this.iledocsComments.size()]);
    }

    public void setProgram(Program program) {
        this.program = program;
        this.documentableFragments.add(program);
    }

    public Program getProgram() {
        return this.program;
    }

    public PositionalAbstractProgramFragment[] getDocumentableFragments() {
        return this.documentableFragments.toArray(new PositionalAbstractProgramFragment[this.documentableFragments.size()]);
    }

    public void buildFinished() {
        this.sendModificationEvent();
    }

    public void addListener(IEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IEventListener listener) {
        this.listeners.remove(listener);
    }

    public void addSubroutine(Subroutine subroutine) {
        this.subroutines.add(subroutine);
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public List<Subroutine> getSubroutines() {
        return this.subroutines;
    }

    private void sendModificationEvent() {
        ASTEvent event = new ASTEvent(ASTEvent.EventType.BUILD_FINISHED);
        for (IEventListener listener : this.listeners) {
            listener.astChanged(event);
        }
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
    }

    public Line getLineAt(int i) {
        return this.lines.get(i);
    }
}

