/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.rpg.ast.PositionalReader;
import miworkplace.ui.editor.rpg.ast.Token;

public class Tokenizer {
    private List<String> compilerDirectives = Arrays.asList("/include", "/title", "/set", "/restore", "/if", "/endif", "/copy", "/define", "/eject", "/space", "/else", "/elseif", "/free", "/end-free", "/eof", "/undefine");

    public List<Token> tokenize(String text) throws IOException {
        text = (String)text + "\n";
        LinkedList<Token> tokens = new LinkedList<Token>();
        if (((String)text).trim().length() == 0) {
            return tokens;
        }
        StringBuilder builder = new StringBuilder();
        PositionalReader reader = new PositionalReader(new BufferedReader(new StringReader((String)text)));
        int rawChar = reader.read();
        do {
            char c = (char)rawChar;
            if (builder.length() > 0) {
                switch (c) {
                    case '-': {
                        if (this.isHyphenOpcode(builder.toString(), reader)) {
                            StringBuilder nextTokenValue = new StringBuilder();
                            rawChar = reader.read();
                            while (rawChar != -1) {
                                c = (char)rawChar;
                                if (c == ' ' || c == '(' || c == ';') {
                                    reader.unread(c);
                                    break;
                                }
                                nextTokenValue.append(c);
                                rawChar = reader.read();
                            }
                            builder.append("-");
                            builder.append((CharSequence)nextTokenValue);
                            break;
                        }
                    }
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': {
                        if (builder.length() > 0) {
                            tokens.add(new Token(reader.offset() - builder.length(), reader.offsetInLine() - builder.length(), reader.line(), builder.toString()));
                            builder.delete(0, builder.length());
                        }
                        tokens.add(new Token(reader.offset() - builder.length(), reader.offsetInLine(), reader.line(), String.valueOf(c)));
                        break;
                    }
                    case ' ': {
                        tokens.add(new Token(reader.offset() - builder.length(), reader.offsetInLine() - builder.length(), reader.line(), builder.toString()));
                        builder.delete(0, builder.length());
                        break;
                    }
                    case '\n': {
                        tokens.add(new Token(reader.offset() - builder.length(), reader.offsetInLine() - builder.length(), reader.line(), builder.toString()));
                        builder.delete(0, builder.length());
                        break;
                    }
                    default: {
                        builder.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '/': {
                    if (this.isCompileDirective(builder, reader)) {
                        builder.insert(0, "/");
                        break;
                    }
                    reader.unread(builder.toString().toCharArray());
                    builder.setLength(0);
                    tokens.add(new Token(reader.offset(), reader.offsetInLine(), reader.line(), String.valueOf(c)));
                    break;
                }
                case '\n': {
                    break;
                }
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '=': {
                    tokens.add(new Token(reader.offset(), reader.offsetInLine(), reader.line(), String.valueOf(c)));
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
        } while ((rawChar = reader.read()) != -1);
        return tokens;
    }

    private boolean isCompileDirective(StringBuilder builder, PositionalReader reader) throws IOException {
        int raw = reader.read();
        char c = (char)raw;
        while (raw != -1) {
            if (c == ' ' || c == '\n') {
                reader.unread(raw);
                break;
            }
            builder.append(c);
            raw = reader.read();
            c = (char)raw;
        }
        return this.compilerDirectives.contains("/" + builder.toString().toLowerCase());
    }

    private boolean isHyphenOpcode(String currentValue, PositionalReader reader) throws IOException {
        boolean hyphenOpcode = false;
        if (!currentValue.isEmpty() && (currentValue.equalsIgnoreCase("eval") || currentValue.equalsIgnoreCase("xml") || currentValue.equalsIgnoreCase("dcl") || currentValue.equalsIgnoreCase("end") || currentValue.equalsIgnoreCase("on") || currentValue.equalsIgnoreCase("ctl"))) {
            StringBuilder nextTokenValue = new StringBuilder();
            int raw = reader.read();
            char c = (char)raw;
            int additional = -1;
            while (raw != -1) {
                if (c == ' ' || c == '(' || c == ';' || c == '\n') {
                    additional = raw;
                    break;
                }
                nextTokenValue.append(c);
                raw = reader.read();
                c = (char)raw;
            }
            String nextTokenString = nextTokenValue.toString();
            if (("eval-" + nextTokenString).equalsIgnoreCase("eval-corr")) {
                hyphenOpcode = true;
            }
            if (("on-" + nextTokenString).equalsIgnoreCase("on-exit")) {
                hyphenOpcode = true;
            } else if (("xml-" + nextTokenString).equalsIgnoreCase("xml-into")) {
                if ("into".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("sax".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                }
            } else if ("dcl".equalsIgnoreCase(currentValue)) {
                if ("f".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("s".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("ds".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("c".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("pi".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("pr".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("parm".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("proc".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("subf".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                }
            } else if ("end".equalsIgnoreCase(currentValue)) {
                if ("pr".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("pi".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("proc".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                } else if ("ds".equalsIgnoreCase(nextTokenString)) {
                    hyphenOpcode = true;
                }
            } else if (("ctl-" + nextTokenString).equalsIgnoreCase("ctl-opt")) {
                hyphenOpcode = true;
            }
            nextTokenValue.append((char)additional);
            nextTokenString = nextTokenValue.toString();
            reader.unread(nextTokenString.toCharArray());
        }
        return hyphenOpcode;
    }
}

