/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.CompositeToken;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.ControlFlow;
import miworkplace.ui.editor.rpg.ast.ControlOption;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.DataStructureParameter;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Preprocessor;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.ProcedureInterface;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.ast.Token;
import miworkplace.ui.editor.rpg.ast.TokenProcessor;
import miworkplace.ui.editor.rpg.ast.Tokenizer;
import miworkplace.ui.editor.rpg.ast.TokensToStringTransformer;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.ast.VariableParameter;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    private Tokenizer tokenizer = new Tokenizer();
    private Preprocessor preprocessor = new Preprocessor();
    private TokenProcessor tokenProcessor = new TokenProcessor();
    private boolean fInSubRoutine;

    public Ast parse(String text) throws Exception {
        Module ast = new Module(new ArrayList<Statement>());
        return this.parse(text, ast);
    }

    public Ast parse(String text, Ast ast) throws Exception {
        this.internal_parse(text, ast);
        return ast;
    }

    private void internal_parse(String text, Ast ast) throws Exception {
        List<Token> rawTokens = this.tokenizer.tokenize(text);
        List<Token> processedTokens = this.preprocessor.process(rawTokens);
        ast.setTokens(processedTokens);
        List<Statement> statements = this.tokenProcessor.process(processedTokens);
        this.process(statements, ast);
    }

    private void process(List<Statement> statements, Ast ast) {
        Ast context = ast;
        ListIterator<Statement> iterator = statements.listIterator();
        while (iterator.hasNext()) {
            Token firstToken;
            Statement statement = iterator.next();
            if (statement.size() > 0) {
                firstToken = statement.list().get(0);
                if (firstToken.value.equalsIgnoreCase("dcl-proc")) {
                    Procedure procedure = new Procedure(new ArrayList<Statement>());
                    context = procedure;
                }
            }
            context.addStatements(statement);
            this.parseStatement(statement, iterator, context);
            if (!(context instanceof Procedure)) continue;
            firstToken = statement.list().get(0);
            if (!firstToken.value.equalsIgnoreCase("end-proc")) continue;
            if (ast instanceof Module) {
                ((Module)ast).addProcedure((Procedure)context);
            }
            context = ast;
        }
    }

    private void parseStatement(Statement st, ListIterator<Statement> iterator, Ast ast) {
        List<Token> tokens = st.list();
        Token start = tokens.get(0);
        if (start.value.equalsIgnoreCase("/include") || start.value.equalsIgnoreCase("/copy")) {
            Include include = this.parseInclude(st);
            if (include != null) {
                ast.addInclude(include);
            }
        } else if (start.value.equalsIgnoreCase("dcl-s")) {
            Variable var = this.parseVariable(st, ast);
            if (var != null) {
                ast.addVariable(var);
            }
        } else if (start.value.equalsIgnoreCase("dcl-c")) {
            Constant constant = this.parseConstant(st);
            if (constant != null) {
                ast.addConstant(constant);
            }
        } else if (start.value.equalsIgnoreCase("begsr")) {
            Subroutine subroutine = this.parseSubroutine(st, iterator, ast);
            if (subroutine != null) {
                ast.addSubroutine(subroutine);
            }
        } else if (start.value.equalsIgnoreCase("exsr")) {
            ControlFlow controlFlow = this.parseControlFlow(st);
            if (controlFlow != null) {
                ast.addControlFlow(controlFlow);
            }
        } else if (start.value.equalsIgnoreCase("dcl-f")) {
            File file = this.parseFile(st);
            if (file != null) {
                ast.addFile(file);
            }
        } else if (start.value.equalsIgnoreCase("dcl-ds")) {
            DataStructure ds = this.parseDataStructure(st, iterator, ast);
            if (ds != null) {
                ast.addVariable(ds);
            }
        } else if (start.value.equalsIgnoreCase("dcl-proc")) {
            this.parseProcedure(st, iterator, (Procedure)ast);
        } else if (start.value.equalsIgnoreCase("dcl-pr")) {
            Prototype prototype = this.parsePrototype(st, iterator, ast);
            if (prototype != null) {
                ast.addPrototype(prototype);
            }
        } else if (start.value.equalsIgnoreCase("ctl-opt")) {
            this.parseControlOptions(st, iterator, ast);
        }
    }

    private void parseControlOptions(Statement statement, ListIterator<Statement> iterator, Ast ast) {
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (";".equals(token.value)) break;
            ControlOption co = new ControlOption(token);
            co.addParameters(this.parseKeywordParameter(tokenIterator));
            ast.addControlOption(co);
        }
    }

    private Prototype parsePrototype(Statement statement, ListIterator<Statement> iterator, Ast ast) {
        List<Token> parameters;
        Prototype p = new Prototype(statement);
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        if (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            p.setName(token.value);
        }
        if (p.getName() == null) {
            return null;
        }
        String likeName = null;
        String arraySize = null;
        boolean isDataStructure = false;
        ArrayList<Token> returnValueTokens = new ArrayList<Token>();
        returnValueTokens.add(token);
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            String tokenValue = token.value.toLowerCase();
            if (tokenValue.equals("likeds")) {
                isDataStructure = true;
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) {
                    p.setReturnValue(new DataStructure(new Statement(token)));
                    continue;
                }
                DataStructure returnValue = new DataStructure(statement);
                returnValue.setLike(parameters.get((int)0).value);
                p.setReturnValue(returnValue);
                continue;
            }
            if (tokenValue.equals("dim")) {
                if (isDataStructure) {
                    token = tokenIterator.next();
                    if (!tokenIterator.hasNext()) continue;
                    token = tokenIterator.next();
                    arraySize = token.value;
                    continue;
                }
                returnValueTokens.add(token);
                continue;
            }
            if (tokenValue.equals("like")) {
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                likeName = token.value;
                continue;
            }
            if (tokenValue.equals("extproc") || tokenValue.equals("extpgm") || tokenValue.equals("rtnparm") || tokenValue.equals("end-pr")) {
                tokenIterator.previous();
                break;
            }
            returnValueTokens.add(token);
        }
        if (!isDataStructure) {
            if (likeName == null) {
                returnValue = this.parseVariable(returnValueTokens.listIterator(), statement, ast);
                if (returnValue != null && returnValue.getType() != null) {
                    p.setReturnValue(returnValue);
                }
            } else {
                returnValue = new Variable(statement);
                returnValue.setLike(likeName);
                p.setReturnValue(returnValue);
            }
        }
        if (arraySize != null) {
            ((AbstractVariable)p.getReturnValue()).arraySize = arraySize;
        }
        boolean terminated = false;
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (token.value.equalsIgnoreCase("extproc")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                if (parameters.size() == 1) {
                    if (parameters.get((int)0).value.equalsIgnoreCase("*dclcase")) {
                        p.setExternalProcedure(p.getName());
                        continue;
                    }
                    p.setExternalProcedure(parameters.get((int)0).value);
                    continue;
                }
                p.setExternalProcedure(new CompositeToken(parameters).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("rtnparm")) {
                p.setReturnParameter(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("extpgm")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) {
                    p.setExternalProgram(p.getName().toUpperCase());
                    continue;
                }
                if (parameters.size() == 1) {
                    p.setExternalProgram(parameters.get((int)0).value);
                    continue;
                }
                p.setExternalProgram(new CompositeToken(parameters).value);
                continue;
            }
            if (!token.value.equalsIgnoreCase("end-pr")) continue;
            terminated = true;
        }
        if (!terminated) {
            while (iterator.hasNext()) {
                statement = iterator.next();
                p.addStatements(statement);
                if (statement.startsWith("end-pr")) break;
                if (statement.startsWith("//")) continue;
                Parameter parameter = this.parseParameter(statement, ast);
                p.addParameter(parameter);
            }
        }
        return p;
    }

    private Parameter parseParameter(Statement statement, Ast ast) {
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        if (!token.value.equalsIgnoreCase("dcl-parm")) {
            tokenIterator.previous();
        }
        if (tokenIterator.hasNext()) {
            tokenIterator.next();
        }
        boolean dataStructure = false;
        if (tokenIterator.hasNext()) {
            String tokenValue = tokenIterator.next().value;
            if (tokenValue.equalsIgnoreCase("likeds")) {
                dataStructure = true;
            }
            tokenIterator.previous();
        }
        if (dataStructure) {
            return this.parseParameterDs(statement);
        }
        return this.parseParameterVariable(statement, ast);
    }

    private void parseParameterKeywords(Statement statement, Parameter parameter) {
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        tokenIterator.next();
        if (tokenIterator.hasNext()) {
            tokenIterator.next();
        }
        while (tokenIterator.hasNext()) {
            Token token = tokenIterator.next();
            if ("CONST".equalsIgnoreCase(token.value)) {
                parameter.setPassedByRef(true);
                continue;
            }
            if ("VALUE".equalsIgnoreCase(token.value)) {
                parameter.setPassedByValue(true);
                continue;
            }
            if (Parameter.Option.nullind.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.nullind);
                continue;
            }
            if (Parameter.Option.nopass.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.nopass);
                continue;
            }
            if (Parameter.Option.omit.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.omit);
                continue;
            }
            if (Parameter.Option.rightadj.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.rightadj);
                continue;
            }
            if (Parameter.Option.string.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.string);
                continue;
            }
            if (Parameter.Option.trim.code().equalsIgnoreCase(token.value)) {
                parameter.addOption(Parameter.Option.trim);
                continue;
            }
            if (!Parameter.Option.varsize.code().equalsIgnoreCase(token.value)) continue;
            parameter.addOption(Parameter.Option.varsize);
        }
    }

    private Parameter parseParameterVariable(Statement statement, Ast ast) {
        VariableParameter parameter = new VariableParameter(statement);
        this.parseVariable(statement.list().listIterator(), parameter, ast);
        this.parseParameterKeywords(statement, parameter);
        return parameter;
    }

    private Parameter parseParameterDs(Statement statement) {
        DataStructureParameter ds = new DataStructureParameter(statement);
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        if (!token.value.equalsIgnoreCase("dcl-parm")) {
            tokenIterator.previous();
        }
        if (tokenIterator.hasNext()) {
            ds.setName(tokenIterator.next().value);
        }
        while (tokenIterator.hasNext()) {
            List<Token> parameters;
            token = tokenIterator.next();
            if (token.value.equalsIgnoreCase("qualified")) {
                ds.setQualified(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("ext")) {
                ds.setExternal(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("extname")) {
                ds.setExternal(true);
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setExternalName(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("likeds")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setLike(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("likerec")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setLike(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("len")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.size() == 1) {
                    ds.setLength(parameters.get((int)0).value);
                    continue;
                }
                if (parameters.size() <= 1) continue;
                ds.setLength(new CompositeToken(parameters).value);
                continue;
            }
            if (!token.value.equalsIgnoreCase("dim")) continue;
            parameters = this.parseKeywordParameter(tokenIterator);
            if (parameters.size() == 1) {
                ds.setArraySize(parameters.get((int)0).value);
                continue;
            }
            if (parameters.size() <= 1) continue;
            ds.setArraySize(new CompositeToken(parameters).value);
        }
        this.parseParameterKeywords(statement, ds);
        return ds;
    }

    private DataStructure parseDataStructure(Statement statement, ListIterator<Statement> iterator, Ast ast) {
        DataStructure ds = new DataStructure(statement);
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        if (!token.value.equalsIgnoreCase("dcl-ds") && !token.value.equalsIgnoreCase("dcl-parm")) {
            tokenIterator.previous();
        }
        if (tokenIterator.hasNext()) {
            ds.setName(tokenIterator.next().value);
        }
        boolean terminated = false;
        while (tokenIterator.hasNext()) {
            List<Token> parameters;
            token = tokenIterator.next();
            if (token.value.equalsIgnoreCase("qualified")) {
                ds.setQualified(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("template")) {
                ds.setTemplate(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("export")) {
                ds.setExported(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("dim")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                if (parameters.size() == 1) {
                    ds.setArraySize(parameters.get((int)0).value);
                    continue;
                }
                if (parameters.size() <= 1) continue;
                ds.setArraySize(new CompositeToken(parameters).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("inz")) {
                ds.setInitialized(true);
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setInitValue(parameters);
                continue;
            }
            if (token.value.equalsIgnoreCase("ext")) {
                ds.setExternal(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("extname")) {
                ds.setExternal(true);
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setExternalName(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("likeds")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setLike(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("likerec")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.isEmpty()) continue;
                ds.setLike(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("len")) {
                parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.size() == 1) {
                    ds.setLength(parameters.get((int)0).value);
                    continue;
                }
                if (parameters.size() <= 1) continue;
                ds.setLength(new CompositeToken(parameters).value);
                continue;
            }
            if (!token.value.equalsIgnoreCase("end-ds")) continue;
            terminated = true;
        }
        if (!terminated && ds.getLike() == null && ds.getLikeRecord() == null) {
            while (iterator.hasNext()) {
                Object subfield;
                statement = iterator.next();
                ds.addStatements(statement);
                if (statement.startsWith("end-ds")) break;
                if (statement.startsWith("//") || (subfield = this.parseSubfield(statement, iterator, ast)) == null) continue;
                ds.addSubfield(subfield);
            }
        }
        return ds;
    }

    private Object parseSubfield(Statement statement, ListIterator<Statement> statementIterator, Ast ast) {
        List<Token> tokens = statement.list();
        ListIterator<Token> iterator = tokens.listIterator();
        if (statement.startsWith("dcl-subf")) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            iterator.next();
        }
        Token type = null;
        if (iterator.hasNext()) {
            type = iterator.next();
        }
        if (type != null) {
            if (type.value.equalsIgnoreCase("likeds")) {
                DataStructure ds = this.parseDataStructure(statement, statementIterator, ast);
                return ds;
            }
            Variable v = this.parseVariable(statement, ast);
            return v;
        }
        return null;
    }

    private void parseProcedure(Statement statement, ListIterator<Statement> iterator, Procedure procedure) {
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        Token token = tokenIterator.next();
        Token token2 = token = tokenIterator.hasNext() ? tokenIterator.next() : null;
        if (token != null) {
            procedure.setName(token.value);
        }
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (!token.value.equalsIgnoreCase("export")) continue;
            procedure.setExported(true);
        }
        Statement statement2 = statement = iterator.hasNext() ? iterator.next() : null;
        if (statement != null && statement.startsWith("dcl-pi")) {
            this.parseProcedureInterface(statement, iterator, procedure);
        } else if (statement != null) {
            iterator.previous();
        }
    }

    private void parseProcedureInterface(Statement statement, ListIterator<Statement> iterator, Procedure procedure) {
        List<Token> tokens = statement.list();
        ListIterator<Token> tokenIterator = tokens.listIterator();
        boolean terminated = false;
        ProcedureInterface pi = procedure.getProcedureInterface();
        pi.addStatement(statement);
        Token token = tokenIterator.next();
        ArrayList<Token> returnValueTokens = new ArrayList<Token>();
        Token token2 = token = tokenIterator.hasNext() ? tokenIterator.next() : null;
        if (token != null) {
            pi.setName(token.value);
            returnValueTokens.add(token);
        }
        String likeName = null;
        String arraySize = null;
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            String tokenValue = token.value.toLowerCase();
            if (tokenValue.equals("likeds")) {
                Token token3 = token = tokenIterator.hasNext() ? tokenIterator.next() : null;
                if (token == null) continue;
                DataStructure returnValue = new DataStructure(new Statement(token));
                returnValue.name = ((Token)returnValueTokens.get((int)0)).value;
                if (tokenIterator.hasNext()) {
                    token = tokenIterator.next();
                    returnValue.like = token.value;
                }
                pi.setReturnValue(returnValue);
                continue;
            }
            if (tokenValue.equals("like")) {
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                likeName = token.value;
                continue;
            }
            if (tokenValue.equals("likefile")) {
                Variable v;
                List<Token> parameters = this.parseKeywordParameter(tokenIterator);
                if (parameters.size() == 1) {
                    v = new Variable(statement);
                    v.setType(Variable.Type.File);
                    v.setLikeFile(parameters.get(0).toString());
                    pi.setReturnValue(v);
                    continue;
                }
                if (parameters.size() <= 1) continue;
                v = new Variable(statement);
                v.setType(Variable.Type.File);
                v.setLikeFile(new CompositeToken(parameters).toString());
                pi.setReturnValue(v);
                continue;
            }
            if (tokenValue.equals("dim")) {
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                if (!tokenIterator.hasNext()) continue;
                token = tokenIterator.next();
                arraySize = token.value;
                continue;
            }
            if (tokenValue.equals("end-pi")) {
                terminated = true;
                break;
            }
            if (token.value.equals(";")) continue;
            returnValueTokens.add(token);
        }
        if (pi.getReturnValue() == null && returnValueTokens.size() > 1) {
            if (likeName == null) {
                Variable variable = this.parseVariable(returnValueTokens.listIterator(), statement, (Ast)procedure);
                variable.name = ((Token)returnValueTokens.get((int)0)).value;
                pi.setReturnValue(variable);
            } else {
                Variable returnValue = new Variable(statement);
                returnValue.setLike(likeName);
                pi.setReturnValue(returnValue);
            }
        }
        if (arraySize != null) {
            ((AbstractVariable)pi.getReturnValue()).arraySize = arraySize;
        }
        if (!terminated) {
            while (iterator.hasNext()) {
                statement = iterator.next();
                pi.addStatement(statement);
                if (statement.startsWith("end-pi")) break;
                if (statement.startsWith("//")) continue;
                Parameter parameter = this.parseParameter(statement, procedure);
                pi.addParameter(parameter);
            }
        }
    }

    private Variable parseVariable(Statement statement, Ast ast) {
        List<Token> tokens = statement.list();
        return this.parseVariable(tokens.listIterator(), statement, ast);
    }

    private Variable parseVariable(ListIterator<Token> iterator, Statement statement, Ast ast) {
        Variable var = new Variable(statement);
        return this.parseVariable(iterator, var, ast);
    }

    private Variable parseVariable(ListIterator<Token> iterator, Variable var, Ast ast) {
        Token token = iterator.next();
        if (!(token.value.equalsIgnoreCase("dcl-s") || token.value.equalsIgnoreCase("dcl-subf") || token.value.equalsIgnoreCase("dcl-parm"))) {
            iterator.previous();
        }
        if (!iterator.hasNext()) {
            return null;
        }
        token = iterator.next();
        var.setName(token.value);
        while (iterator.hasNext()) {
            List<Token> parameters;
            token = iterator.next();
            if (token.value.equalsIgnoreCase("char")) {
                var.setType(Variable.Type.Character);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("varchar")) {
                var.setType(Variable.Type.Varchar);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("int")) {
                var.setType(Variable.Type.Integer);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("ind")) {
                var.setType(Variable.Type.Boolean);
                continue;
            }
            if (token.value.equalsIgnoreCase("date")) {
                var.setType(Variable.Type.Date);
                continue;
            }
            if (token.value.equalsIgnoreCase("packed")) {
                var.setType(Variable.Type.Packed);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                if (parameters.size() <= 1) continue;
                var.setDecimalPositions(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("zoned")) {
                var.setType(Variable.Type.Zoned);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                if (parameters.size() <= 1) continue;
                var.setDecimalPositions(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("time")) {
                var.setType(Variable.Type.Time);
                continue;
            }
            if (token.value.equalsIgnoreCase("timestamp")) {
                var.setType(Variable.Type.Timestamp);
                continue;
            }
            if (token.value.equalsIgnoreCase("float")) {
                var.setType(Variable.Type.Float);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("graph")) {
                var.setType(Variable.Type.Graph);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("pointer")) {
                var.setType(Variable.Type.Pointer);
                continue;
            }
            if (token.value.equalsIgnoreCase("bindec")) {
                var.setType(Variable.Type.BinaryDecimal);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                if (parameters.size() <= 1) continue;
                var.setDecimalPositions(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("object")) {
                var.setType(Variable.Type.Object);
                continue;
            }
            if (token.value.equalsIgnoreCase("uns")) {
                var.setType(Variable.Type.UnsignedInteger);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("ucs2")) {
                var.setType(Variable.Type.UCS2);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLength(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("based")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setBased(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("export")) {
                var.setExported(true);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty() || parameters.size() != 1) continue;
                var.setExternalName(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("import")) {
                var.setImported(true);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty() || parameters.size() != 1) continue;
                var.setExternalName(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("like")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                var.setLike(parameters.get((int)0).value);
                if (parameters.size() == 2) {
                    var.setLengthAdjustment(parameters.get((int)1).value);
                } else if (parameters.size() > 2) {
                    var.setLengthAdjustment(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                }
                Object symbol = ast.getSymbol(var.getLike());
                if (symbol == null || !(symbol instanceof Variable)) continue;
                Variable likeVariable = (Variable)symbol;
                var.setType(likeVariable.getType());
                var.setLength(likeVariable.getLength());
                var.setDecimalPositions(likeVariable.getDecimalPositions());
                var.setArraySize(likeVariable.getArraySize());
                continue;
            }
            if (token.value.equalsIgnoreCase("likefile")) {
                parameters = this.parseKeywordParameter(iterator);
                var.setType(Variable.Type.File);
                if (parameters.isEmpty()) continue;
                var.setLikeFile(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("dim")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                if (parameters.size() == 1) {
                    var.setArraySize(parameters.get((int)0).value);
                    continue;
                }
                var.setArraySize(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("ctdata")) {
                var.setCompileTimeArray(Boolean.TRUE);
                continue;
            }
            if (token.value.equalsIgnoreCase("ccsid")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                if (parameters.size() == 1) {
                    var.setCcsid(parameters.get((int)0).value);
                    continue;
                }
                var.setCcsid(new CompositeToken(parameters.subList((int)1, (int)parameters.size())).value);
                continue;
            }
            if (!token.value.equalsIgnoreCase("inz")) continue;
            parameters = this.parseKeywordParameter(iterator);
            var.setInitValue(parameters);
        }
        if (var.getName() == null) {
            return null;
        }
        return var;
    }

    private File parseFile(Statement statement) {
        List<Token> tokens = statement.list();
        ListIterator<Token> iterator = tokens.listIterator();
        File file = new File(statement);
        iterator.next();
        if (!iterator.hasNext()) {
            return file;
        }
        Token token = iterator.next();
        file.setFilename(token.value);
        while (iterator.hasNext()) {
            List<Token> parameters;
            token = iterator.next();
            if (token.value.equalsIgnoreCase("qualified")) {
                file.setQualified(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("template")) {
                file.setTemplate(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("static")) {
                file.setStaticFile(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("disk")) {
                file.setType(File.Type.Disk);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty() || !parameters.get((int)0).value.equalsIgnoreCase("*EXT")) continue;
                file.setExternallyDescribed(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("printer")) {
                file.setType(File.Type.Printer);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty() || !parameters.get((int)0).value.equalsIgnoreCase("*EXT")) continue;
                file.setExternallyDescribed(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("WORKSTN")) {
                file.setType(File.Type.Workstation);
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty() || !parameters.get((int)0).value.equalsIgnoreCase("*EXT")) continue;
                file.setExternallyDescribed(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("alias")) {
                file.setUseAlias(true);
                continue;
            }
            if (token.value.equalsIgnoreCase("likefile")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                file.setLikefile(parameters.get((int)0).value);
                continue;
            }
            if (token.value.equalsIgnoreCase("prefix")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.size() >= 1) {
                    file.setPrefix(parameters.get((int)0).value);
                }
                if (parameters.size() < 2) continue;
                try {
                    file.setPrefixNumberReplacedCharacters(new Integer(parameters.get((int)1).value));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (token.value.equalsIgnoreCase("include")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                for (Token p : parameters) {
                    file.addIncludedRecordFormat(p.value);
                }
                continue;
            }
            if (token.value.equalsIgnoreCase("ignore")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.isEmpty()) continue;
                for (Token p : parameters) {
                    file.addIgnoredRecordFormat(p.value);
                }
                continue;
            }
            if (token.value.equalsIgnoreCase("rename")) {
                parameters = this.parseKeywordParameter(iterator);
                if (parameters.size() != 2) continue;
                file.setRenamedRecordFormatExternal(parameters.get((int)0).value);
                file.setRenamedRecordFormatInternal(parameters.get((int)1).value);
                continue;
            }
            if (!token.value.equalsIgnoreCase("extdesc") || (parameters = this.parseKeywordParameter(iterator)).isEmpty()) continue;
            file.setExternalDescription(parameters.get((int)0).value);
        }
        return file;
    }

    private List<Token> parseKeywordParameter(ListIterator<Token> iterator) {
        LinkedList<Token> parameters = new LinkedList<Token>();
        boolean started = false;
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (token.value.equals("(")) {
                started = true;
                continue;
            }
            if (token.value.equals(")")) break;
            if (started) {
                if (token.value.equals(":")) continue;
                parameters.add(token);
                continue;
            }
            iterator.previous();
            break;
        }
        return parameters;
    }

    private Subroutine parseSubroutine(Statement st, ListIterator<Statement> iterator, Ast pAst) {
        if (this.fInSubRoutine) {
            return null;
        }
        try {
            this.fInSubRoutine = true;
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(st);
            List<Token> tokens = st.list();
            Token name = tokens.size() > 1 ? tokens.get(1) : null;
            while (iterator.hasNext()) {
                Statement statement = iterator.next();
                statements.add(statement);
                tokens = statement.list();
                if (tokens.isEmpty()) continue;
                Token start = tokens.get(0);
                if (start.value.equalsIgnoreCase("endsr") || start.value.equalsIgnoreCase("end-proc")) break;
                this.parseStatement(statement, iterator, pAst);
            }
            Subroutine subroutine = new Subroutine(statements, name);
            return subroutine;
        }
        finally {
            this.fInSubRoutine = false;
        }
    }

    private Constant parseConstant(Statement statement) {
        Token name = null;
        String value = null;
        List<Token> tokens = statement.list();
        if (tokens.size() > 0) {
            name = tokens.get(1);
            if (tokens.size() > 1) {
                value = this.buildConstantValue(tokens.subList(2, tokens.size()));
            }
        }
        if (name != null && value != null) {
            return new Constant(statement, name, value);
        }
        return null;
    }

    private ControlFlow parseControlFlow(Statement statement) {
        Token name = null;
        List<Token> tokens = statement.list();
        if (tokens.size() > 0) {
            name = tokens.get(1);
        }
        if (name != null) {
            return new ControlFlow(statement, name);
        }
        return null;
    }

    private String buildConstantValue(List<Token> tokens) {
        boolean constKeyword = false;
        String value = TokensToStringTransformer.transform(tokens);
        if (value.length() >= 8 && value.substring(0, 5).equalsIgnoreCase("const")) {
            value = value.substring(6, value.length());
            constKeyword = true;
        }
        value = StringUtils.stripEnd((String)value, (String)" ;");
        if (constKeyword) {
            value = value.substring(0, value.length() - 1).trim();
        }
        return value;
    }

    private Include parseInclude(Statement statement) {
        StringBuilder sb = new StringBuilder(StringUtils.repeat((String)"          ", (int)20));
        ListIterator<Token> iterator = statement.list().listIterator();
        iterator.next();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            sb.insert(token.lineOffset, token.value);
        }
        Include include = new Include(statement, sb.toString().trim());
        return include;
    }
}

