/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Token;

public class Element {
    private List<Statement> statements = new ArrayList<Statement>();
    String name;

    public Element(Statement statement) {
        this.statements.add(statement);
    }

    public Element(List<Statement> statements) {
        this.statements = statements;
    }

    public Statement getStatement() {
        return this.getFirst();
    }

    public Statement getFirst() {
        return this.statements.get(0);
    }

    public Statement getLast() {
        return this.statements.get(this.statements.size() - 1);
    }

    public Token getStart() {
        return this.getFirst().list().get(0);
    }

    public Token getEnd() {
        List<Token> tokens = this.getLast().list();
        return tokens.get(tokens.size() - 1);
    }

    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public Element addStatements(Statement ... statements) {
        this.statements.addAll(Arrays.asList(statements));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.statements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.statements, other.statements);
    }
}

