/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.ui.editor.rpg.ast.Token;

public class ControlOption {
    private final List<Token> parameters = new ArrayList<Token>();
    private final Token nameToken;

    public ControlOption(Token nameToken) {
        this.nameToken = nameToken;
    }

    public String getName() {
        return this.nameToken.toString();
    }

    public void addParameter(String option, Token token) {
        this.parameters.add(token);
    }

    public String getFirst() {
        if (this.parameters.isEmpty()) {
            return null;
        }
        return this.parameters.get(0).toString();
    }

    public String get(int i) {
        if (this.parameters.size() <= i) {
            return null;
        }
        return this.parameters.get(i).toString();
    }

    public List<Token> getAll() {
        return Collections.unmodifiableList(this.parameters);
    }

    public boolean contains(String option) {
        for (Token token : this.parameters) {
            if (!option.equals(token.toString())) continue;
            return true;
        }
        return false;
    }

    public void addParameters(List<Token> parameters) {
        if (parameters == null) {
            return;
        }
        this.parameters.addAll(parameters);
    }

    public String toString() {
        return this.nameToken.toString() + ": " + String.valueOf(this.parameters);
    }
}

