/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.script.ScriptView;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class SaveAsScriptHandler {
    @Inject
    private LogService logger;

    @Execute
    public void execute(MPart part, @Named(value="activeShell") Shell shell) {
        Object partObject = part.getObject();
        if (partObject == null) {
            return;
        }
        ScriptView view = (ScriptView)partObject;
        try {
            FileDialog saveDialog = new FileDialog(shell, 8192);
            saveDialog.setText(Messages.editor_script_save);
            String saveFilePath = saveDialog.open();
            if (saveFilePath != null && !this.isSameFile(saveFilePath, view.getScriptFile())) {
                File saveFile = new File(saveFilePath);
                FileUtils.write((File)saveFile, (CharSequence)view.getEditorContent());
                view.setScriptFile(saveFile);
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Could not write script to file " + view.getScriptFile().getAbsolutePath(), (Throwable)e);
            Notifier.error((String)Messages.editor_script_save, (String)Messages.editor_script_save_error);
        }
    }

    private boolean isSameFile(String saveAsFilePath, File scriptFile) {
        if (scriptFile == null) {
            return false;
        }
        return saveAsFilePath.equals(scriptFile.getAbsolutePath());
    }
}

