/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.script.MessageButton;
import miworkplace.ui.editor.script.ScriptView;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class OpenScriptHandler {
    @Inject
    private LogService logger;

    @Execute
    public void execute(MPart part, @Named(value="activeShell") Shell shell, @Optional MMenuItem menuItem) {
        Object partObject = part.getObject();
        if (partObject == null) {
            return;
        }
        String passedFilePath = null;
        if (menuItem.getTransientData().get("path") != null) {
            passedFilePath = menuItem.getTransientData().get("path").toString();
        }
        ScriptView view = (ScriptView)partObject;
        if (part.isDirty()) {
            String scriptName = view.getScriptFile() == null ? Messages.editor_script_save_unnamedscript : view.getScriptFile().getName();
            int selectedButton = MessageDialog.open((int)3, (Shell)shell, (String)Messages.common_save, (String)String.format(Messages.editor_script_save_change, scriptName), (int)0, (String[])new String[]{Messages.common_saveno, Messages.common_cancel, Messages.common_save});
            if (selectedButton == MessageButton.DONT_SAVE.position) {
                this.openScript(shell, view, passedFilePath);
            } else if (selectedButton == MessageButton.SAVE.position) {
                view.persist(shell);
            } else {
                int cfr_ignored_0 = MessageButton.CANCEL.position;
            }
        } else {
            this.openScript(shell, view, passedFilePath);
        }
    }

    private void openScript(Shell shell, ScriptView view, String filePath) {
        if (filePath == null) {
            FileDialog openDialog = new FileDialog(shell, 4096);
            openDialog.setText("Open Script");
            filePath = openDialog.open();
        }
        if (filePath != null) {
            try {
                String code = FileUtils.readFileToString((File)new File(filePath));
                view.setEditorContent(new File(filePath), code);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not read script from file " + filePath, (Throwable)e);
                Notifier.error((String)Messages.editor_script_open, (String)Messages.editor_script_open_error);
            }
        }
    }
}

