/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script.handler;

import jakarta.inject.Named;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.script.MessageButton;
import miworkplace.ui.editor.script.ScriptView;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewScriptHandler {
    @Execute
    public void execute(MPart part, @Named(value="activeShell") Shell shell) {
        Object partObject = part.getObject();
        if (partObject == null) {
            return;
        }
        ScriptView view = (ScriptView)partObject;
        if (part.isDirty()) {
            String scriptName = view.getScriptFile() == null ? Messages.editor_script_save_unnamedscript : view.getScriptFile().getName();
            int selectedButton = MessageDialog.open((int)3, (Shell)shell, (String)Messages.common_save, (String)String.format(Messages.editor_script_save_change, scriptName), (int)0, (String[])new String[]{Messages.common_saveno, Messages.common_cancel, Messages.common_save});
            if (selectedButton == MessageButton.DONT_SAVE.position) {
                view.newScript();
            } else if (selectedButton == MessageButton.SAVE.position) {
                view.persist(shell);
            } else {
                int cfr_ignored_0 = MessageButton.CANCEL.position;
            }
        } else {
            view.newScript();
        }
    }
}

