/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class RecentScriptsListService {
    private final int MAX_NUMBER_SCRIPTS = 10;
    private final String PLUGIN_ID = "miworkplace.ui.editor.script";
    private final String LIST_FILE_NAME = "recent-scripts.txt";
    private LogService logger;
    private IPath bundleStateLocation;
    private List<String> recentScripts = new ArrayList<String>();

    public void activate() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.ui.editor.script");
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        this.recentScripts.addAll(this.load());
    }

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void add(String filename) {
        this.recentScripts.remove(filename);
        this.recentScripts.add(0, filename);
        if (this.recentScripts.size() > 10) {
            this.recentScripts.remove(this.recentScripts.size() - 1);
        }
        this.persist();
    }

    public List<String> get() {
        return Collections.unmodifiableList(this.recentScripts);
    }

    private List<String> load() {
        ArrayList<String> scripts = new ArrayList<String>();
        File file = this.getListFile();
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty() || !new File(line).exists()) continue;
                        this.recentScripts.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not load recent scripts.", (Throwable)e);
            }
        }
        return scripts;
    }

    private void persist() {
        File file = this.getListFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                this.logger.log(1, "Could not create file " + file.getAbsolutePath(), (Throwable)e);
                return;
            }
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (FileWriter writer = new FileWriter(file);){
                for (String filename : this.recentScripts) {
                    writer.write(filename + System.getProperty("line.separator"));
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.logger.log(1, "Could not write recent scripts list to " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private File getListFile() {
        IPath path = this.bundleStateLocation.append("recent-scripts.txt");
        return path.toFile();
    }
}

