/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ui.util;

import java.lang.reflect.Method;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public class TableViewerColumnSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private final TableViewerColumn m_column;
    private final TableViewer m_viewer;
    private final Table m_table;
    private int m_direction = 0;

    public TableViewerColumnSorter(TableViewerColumn column) {
        this.m_column = column;
        this.m_viewer = (TableViewer)column.getViewer();
        this.m_table = this.m_viewer.getTable();
        this.m_column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableViewerColumnSorter.this.m_viewer.getComparator() != null) {
                    if (TableViewerColumnSorter.this.m_viewer.getComparator() == TableViewerColumnSorter.this) {
                        if (TableViewerColumnSorter.this.m_direction == 1) {
                            TableViewerColumnSorter.this.setSorter(-1);
                        } else if (TableViewerColumnSorter.this.m_direction == -1) {
                            TableViewerColumnSorter.this.setSorter(0);
                        }
                    } else {
                        TableViewerColumnSorter.this.setSorter(1);
                    }
                } else {
                    TableViewerColumnSorter.this.setSorter(1);
                }
            }
        });
    }

    public void setSorter(int direction) {
        if (direction == 0) {
            this.m_table.setSortColumn(null);
            this.m_table.setSortDirection(0);
            this.m_viewer.setComparator(null);
        } else {
            this.m_table.setSortColumn(this.m_column.getColumn());
            this.m_direction = direction;
            if (this.m_direction == 1) {
                this.m_table.setSortDirection(1024);
            } else {
                this.m_table.setSortDirection(128);
            }
            if (this.m_viewer.getComparator() == this) {
                this.m_viewer.refresh();
            } else {
                this.m_viewer.setComparator((ViewerComparator)this);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.m_direction * this.doCompare(viewer, e1, e2);
    }

    protected int doCompare(Viewer viewer, Object e1, Object e2) {
        Object o1 = this.getValue(e1);
        Object o2 = this.getValue(e2);
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return 0;
    }

    protected Object getValue(Object o) {
        try {
            Method getEditingMethod = ViewerColumn.class.getDeclaredMethod("getEditingSupport", new Class[0]);
            getEditingMethod.setAccessible(true);
            EditingSupport editingSupport = (EditingSupport)getEditingMethod.invoke((Object)this.m_column, new Object[0]);
            if (editingSupport != null) {
                Method getValueMethod = EditingSupport.class.getDeclaredMethod("getValue", Object.class);
                getValueMethod.setAccessible(true);
                return getValueMethod.invoke((Object)editingSupport, o);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

