/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ui.util;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.PlatformUI;

public class Animator {
    private Button fButton;
    private List<Image> fIcons;
    private Image fOriginalImage;
    private Timer fTimer;
    private int fPeriod;
    private int fCounter;
    private boolean fIsCancelled;
    private boolean fIsRunning;

    public Animator(Button button, List<Image> icons, int period) {
        if (button == null) {
            throw new IllegalArgumentException("The button widget is null.");
        }
        if (icons == null) {
            throw new IllegalArgumentException("The icons list is null.");
        }
        if (icons.isEmpty()) {
            throw new IllegalArgumentException("The icons list is empty.");
        }
        if (period <= 0) {
            throw new IllegalArgumentException("The period is 0 or less seconds.");
        }
        this.fButton = button;
        this.fIcons = icons;
        this.fPeriod = period;
        this.fOriginalImage = this.fButton.getImage();
    }

    public Animator start() {
        this.fCounter = 0;
        this.fIsRunning = true;
        this.fIsCancelled = false;
        this.fTimer = new Timer();
        this.fTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (Animator.this.fCounter >= Animator.this.fIcons.size()) {
                    Animator.this.fCounter = 0;
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                    Image icon;
                    if (!(Animator.this.fIsCancelled || Animator.this.fButton.isDisposed() || (icon = (Image)Animator.this.fIcons.get(Animator.this.fCounter)).isDisposed())) {
                        Animator.this.fButton.setImage(icon);
                    }
                    Animator animator = Animator.this;
                    animator.fCounter = animator.fCounter + 1;
                });
            }
        }, 0L, (long)this.fPeriod);
        return this;
    }

    public Animator stop() {
        this.fIsCancelled = true;
        if (this.fTimer != null) {
            this.fTimer.cancel();
        }
        this.fIsRunning = false;
        if (!this.fButton.isDisposed() && !this.fOriginalImage.isDisposed()) {
            this.fButton.setImage(this.fOriginalImage);
        }
        return this;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }
}

