/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpoolUtil;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ReleaseSpoolHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IActiveConnectionService connection;

    @Execute
    public void run(@Named(value="activeShell") Shell shell) {
        Object selection = this.selectionService.getSelection("miworkplace.spools.part");
        if (selection == null) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (SpooledFileListItem item : ss) {
            SpooledFile spool = SpoolUtil.toSpoolFile(this.connection.getLastUsedActiveConnection().getSystem(), item);
            try {
                if ("*READY".equals(item.getStatus())) {
                    Notifier.info((String)Messages.spools_handler_release_notify_title, (String)String.format(Messages.spools_handler_release_already_ready, this.getName(spool)));
                    continue;
                }
                spool.release();
            }
            catch (Exception e) {
                this.logger.error("Could not release spooled file " + this.getName(spool), (Throwable)e);
                Notifier.warn((String)Messages.spools_handler_release_notify_title, (String)String.format(Messages.spools_handler_release_error, this.getName(spool)));
            }
        }
        this.eventBroker.send("miworkplace/spools/update", new Object());
    }

    private String getName(SpooledFile spooledFile) {
        return spooledFile.getName() + " (" + spooledFile.getJobName() + "/" + spooledFile.getJobNumber() + "/" + spooledFile.getJobUser() + ")";
    }
}

