/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpoolUtil;
import miworkplace.spools.SpooledFilesPart;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeleteAllSpoolHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IActiveConnectionService connectionService;

    @CanExecute
    public boolean canExecute() {
        return this.connectionService.getLastUsedActiveConnection() != null && this.connectionService.getLastUsedActiveConnection().isConnected();
    }

    @Execute
    public void run(@Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences, EPartService partService, @Named(value="activeShell") Shell shell) {
        MPart part = partService.findPart("miworkplace.spools.part");
        if (part != null) {
            boolean promptOnDelete = applicationPreferences.getBoolean("miworkplace.spools.prompt", true);
            if (promptOnDelete) {
                boolean deleted;
                MessageDialog dialog = new MessageDialog(shell, Messages.common_dialog_confirm, null, Messages.spools_handler_delete_confirm, 3, new String[]{Messages.common_yes, Messages.common_no}, 0);
                if (dialog.open() == 0 && (deleted = this.deleteSpooledFiles(part))) {
                    this.eventBroker.send("miworkplace/spools/refresh", (Object)this.connectionService.getLastUsedActiveConnection().getName());
                }
            } else {
                boolean deleted = this.deleteSpooledFiles(part);
                if (deleted) {
                    this.eventBroker.send("miworkplace/spools/refresh", (Object)this.connectionService.getLastUsedActiveConnection().getName());
                }
            }
        }
    }

    private boolean deleteSpooledFiles(MPart part) {
        boolean deleted = false;
        SpooledFilesPart spooledFilePart = (SpooledFilesPart)part.getObject();
        if (spooledFilePart != null) {
            SpooledFileListItem[] spools;
            SpooledFileListItem[] spooledFileListItemArray = spools = spooledFilePart.getSpooledFiles();
            int n = spools.length;
            int n2 = 0;
            while (n2 < n) {
                SpooledFileListItem item = spooledFileListItemArray[n2];
                AS400 system = this.connectionService.getLastUsedActiveConnection().getSystem();
                SpooledFile file = SpoolUtil.toSpoolFile(system, item);
                try {
                    file.delete();
                    deleted = true;
                }
                catch (Exception e) {
                    String message = MessageFormat.format("Could not delete spooled file {0} with number {1}", item.getName(), item.getNumber());
                    this.logger.error(message, (Throwable)e);
                }
                ++n2;
            }
        }
        return deleted;
    }
}

