/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.editor;

import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.spools.editor.IDocumentReceiver;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class SpooledFileContentLoader
implements Runnable {
    private String dialogTitle;
    private IDocumentReceiver receiver;
    private UISynchronize sync;
    private String inputUri;
    private IConnection connection;
    private String wscstPath;
    private Debug logger = Debug.getInstance();
    private IConnectionUtilities connUtils;

    public SpooledFileContentLoader(IDocumentReceiver receiver, IConnection connection, String inputUri, UISynchronize sync, String wscstPath, IConnectionUtilities connUtils) {
        this.receiver = receiver;
        this.connection = connection;
        this.inputUri = inputUri;
        this.sync = sync;
        this.wscstPath = wscstPath;
        this.connUtils = connUtils;
        this.dialogTitle = Messages.spools_loader_dialog_title;
    }

    @Override
    public void run() {
        String[] pathParts;
        SpooledFile spooledFile = this.getSpooledFileObject();
        String wscst = "/QSYS.LIB/QWPDEFAULT.WSCST";
        if (StringUtils.isNotEmpty((CharSequence)this.wscstPath) && (pathParts = this.wscstPath.split("/")).length == 2) {
            try {
                wscst = QSYSObjectPathName.toPath((String)pathParts[0], (String)pathParts[1], (String)"WSCST");
                if (!this.connUtils.doesObjectExist(this.connection, wscst)) {
                    wscst = "/QSYS.LIB/QWPDEFAULT.WSCST";
                }
            }
            catch (Exception e) {
                this.logger.error("Invalid QSYS.LIB path for WSCST object: " + this.wscstPath, (Throwable)e);
                wscst = "/QSYS.LIB/QWPDEFAULT.WSCST";
            }
        }
        PrintParameterList printParms = new PrintParameterList();
        printParms.setParameter(-8, wscst);
        printParms.setParameter(65, "*WSCST");
        try {
            PrintObjectTransformedInputStream in = spooledFile.getTransformedInputStream(printParms);
            String content = IOUtils.toString((Reader)new InputStreamReader((InputStream)in));
            Document document = new Document(content);
            this.receiver.receiveDocument((IDocument)document);
        }
        catch (Exception exception) {
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)SpooledFileContentLoader.this.dialogTitle, (String)Messages.spools_loader_error);
                }
            });
        }
    }

    private SpooledFile getSpooledFileObject() {
        try {
            URI uri = new URI(this.inputUri);
            String[] pathParts = Arrays.copyOfRange(uri.getPath().split("/"), 1, 6);
            return new SpooledFile(this.connection.getSystem(), pathParts[0], Integer.parseInt(pathParts[1]), pathParts[2], pathParts[4], pathParts[3]);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

