/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IFileDescription;
import miworkplace.services.api.IFileDescriptionService;
import miworkplace.services.util.FileDescriptionLoader;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.editor.cl.FileDeclaration;
import miworkplace.ui.editor.cl.IClEditor;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.File;
import miworkplace.ui.editor.cl.ast.Label;
import miworkplace.ui.editor.cl.ast.Parameter;
import miworkplace.ui.editor.cl.ast.Subroutine;
import miworkplace.ui.editor.cl.ast.Variable;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class ClOutlinePage
implements ISelectionChangedListener {
    @Inject
    private IEclipseContext context;
    @Inject
    private LogService logger;
    @Inject
    private IFileDescriptionService fileDescriptionService;
    @Inject
    private IConnectionManager connectionManager;
    private IResourcePool imagePool;
    private TreeViewer viewer;
    private ArrayList<Categories> categories = new ArrayList();
    private ViewerComparator sorter = new ClOutlineSorter();
    private StackLayout defaultLayout;
    private Composite noOutline;
    private String inputUri;
    private Ast ast;
    private Map<File, FileDeclaration> files = new HashMap<File, FileDeclaration>();
    private Composite defaultComposite;
    private boolean fFirstTime = true;

    @Inject
    public ClOutlinePage(Composite parent, @Named(value="e4ActivePart") MPart part, LogService logger, final ESelectionService selectionService, IResourcePool imagePool, @Optional Ast ast) {
        this.imagePool = imagePool;
        IRemoteEditor editor = (IRemoteEditor)part.getObject();
        final IClEditor highlightEditor = (IClEditor)part.getObject();
        this.inputUri = editor.getInputUri();
        this.defaultComposite = new Composite(parent, 0);
        this.defaultLayout = new StackLayout();
        this.defaultComposite.setLayout((Layout)this.defaultLayout);
        this.noOutline = this.buildNoOutline(this.defaultComposite);
        this.viewer = new TreeViewer(this.defaultComposite, 768);
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setComparator(this.sorter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element == null) {
                    return;
                }
                if (element instanceof Variable) {
                    highlightEditor.highlight(element);
                } else if (element instanceof Subroutine) {
                    highlightEditor.highlight(element);
                } else if (element instanceof File) {
                    highlightEditor.highlight(element);
                } else if (element instanceof Label) {
                    highlightEditor.highlight(element);
                }
            }
        });
        if (ast != null) {
            this.ast = ast;
            this.viewer.setInput((Object)ast);
            if (this.fFirstTime) {
                this.viewer.expandAll();
                this.fFirstTime = false;
            }
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
    }

    private Composite buildNoOutline(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.common_outline_none);
        return form;
    }

    @PreDestroy
    public void dispose() {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (event.containsProperty("inputUri")) {
            String astInputUri = event.getProperty("inputUri").toString();
            String astMemberPath = event.getProperty("memberPath").toString();
            this.logger.log(4, "Receiving event for rebuilt AST for " + astMemberPath);
            Object eventData = event.getProperty("org.eclipse.e4.data");
            if (this.inputUri.equals(astInputUri)) {
                this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
                TreePath[] expandedPaths = this.viewer.getExpandedTreePaths();
                this.viewer.setInput((Object)this.ast);
                if (this.ast != null) {
                    if (this.fFirstTime) {
                        this.viewer.expandAll();
                        this.fFirstTime = false;
                    } else {
                        this.viewer.setExpandedTreePaths(expandedPaths);
                    }
                }
            }
        }
    }

    @Inject
    @Optional
    public void notifiedFileDescriptionLoaded(@UIEventTopic(value="miworkplace/filedesc/loaded") Event event) {
        String eventInputUri = event.getProperty("inputUri").toString();
        String eventIfsPath = event.getProperty("path").toString();
        IFileDescription fd = (IFileDescription)event.getProperty("org.eclipse.e4.data");
        if (this.inputUri.equals(eventInputUri)) {
            File loadedFile = null;
            List files = this.ast.listFiles();
            for (File file : files) {
                String ifsPath = QSYSObjectPathName.toPath((String)file.getLibrary(), (String)file.getFile(), (String)"FILE");
                if (!ifsPath.equals(eventIfsPath)) continue;
                loadedFile = file;
                FileDeclaration fileDeclaration = new FileDeclaration(file);
                if (file.getRecordFormat().equalsIgnoreCase("*ALL")) {
                    recordFormats = fd.getRecordFormats();
                    for (RecordFormat recordFormat : recordFormats) {
                        fileDeclaration.addRecordFormat(recordFormat);
                    }
                } else {
                    fileDeclaration.addRecordFormatName(file.getRecordFormat());
                    recordFormats = fd.getRecordFormats();
                    for (RecordFormat recordFormat : recordFormats) {
                        if (!recordFormat.getName().equalsIgnoreCase(file.getRecordFormat())) continue;
                        fileDeclaration.addRecordFormat(recordFormat);
                    }
                }
                this.files.put(file, fileDeclaration);
            }
            this.viewer.refresh((Object)Categories.Files, true);
            this.viewer.expandToLevel(loadedFile, -1);
        }
    }

    @Inject
    @Optional
    public void notifiedRefresh(@UIEventTopic(value="miworkplace/ui/outline/refresh") Event event) {
        String connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        if (this.ast != null) {
            for (File file : this.ast.listFiles()) {
                String ifsPath = QSYSObjectPathName.toPath((String)file.getLibrary(), (String)file.getFile(), (String)"FILE");
                this.fileDescriptionService.clearFileDescription(connection, ifsPath);
            }
            this.files.clear();
            this.buildFileDeclarations(this.ast, this.files);
            this.viewer.refresh();
        }
    }

    private void buildFileDeclarations(Ast ast, Map<File, FileDeclaration> files) {
        String connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        for (File file : ast.listFiles()) {
            String ifsPath = QSYSObjectPathName.toPath((String)file.getLibrary(), (String)file.getFile(), (String)"FILE");
            IFileDescription fd = this.fileDescriptionService.getFileDescription(connection, ifsPath);
            if (fd == null) {
                IEclipseContext childContext = this.context.createChild();
                childContext.set(IConnection.class, (Object)connection);
                childContext.set("path", (Object)ifsPath);
                childContext.set("inputUri", (Object)this.inputUri);
                FileDescriptionLoader loader = (FileDescriptionLoader)ContextInjectionFactory.make(FileDescriptionLoader.class, (IEclipseContext)childContext);
                loader.schedule();
                continue;
            }
            FileDeclaration fileDeclaration = new FileDeclaration(file);
            if (file.getRecordFormat().equalsIgnoreCase("*ALL")) {
                recordFormats = fd.getRecordFormats();
                for (RecordFormat recordFormat : recordFormats) {
                    fileDeclaration.addRecordFormat(recordFormat);
                }
            } else {
                fileDeclaration.addRecordFormatName(file.getRecordFormat());
                recordFormats = fd.getRecordFormats();
                for (RecordFormat recordFormat : recordFormats) {
                    if (!recordFormat.getName().equalsIgnoreCase(file.getRecordFormat())) continue;
                    fileDeclaration.addRecordFormat(recordFormat);
                }
            }
            files.put(file, fileDeclaration);
        }
    }

    private void buildCategories(Ast ast) {
        this.categories.clear();
        if (!ast.listParameters().isEmpty()) {
            this.categories.add(Categories.Parameters);
        }
        if (!ast.listVariables().isEmpty()) {
            this.categories.add(Categories.Variables);
        }
        if (!ast.listSubroutines().isEmpty()) {
            this.categories.add(Categories.Subroutines);
        }
        if (!ast.listFiles().isEmpty()) {
            this.categories.add(Categories.Files);
        }
        if (!ast.listLabels().isEmpty()) {
            this.categories.add(Categories.Labels);
        }
    }

    public Control getControl() {
        return this.defaultComposite;
    }

    private static enum Categories {
        Parameters,
        Variables,
        Files,
        Subroutines,
        Labels;

    }

    class ClOutlineSorter
    extends ViewerComparator {
        ClOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof FieldDescription) {
                FieldDescription fd1 = (FieldDescription)e1;
                FieldDescription fd2 = (FieldDescription)e2;
                return fd1.getFieldName().compareTo(fd2.getFieldName());
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            if (ClOutlinePage.this.categories.contains(element)) {
                return ((Categories)((Object)element)).ordinal();
            }
            return 0;
        }
    }

    class OutlineContentProvider
    implements ITreeContentProvider {
        private final Object[] nullElements = new Object[0];

        OutlineContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Ast) {
                return ClOutlinePage.this.categories.toArray(new Categories[ClOutlinePage.this.categories.size()]);
            }
            if (parentElement == Categories.Parameters) {
                List parameters = ClOutlinePage.this.ast.listParameters();
                return parameters.toArray(new Parameter[parameters.size()]);
            }
            if (parentElement == Categories.Variables) {
                List variables = ClOutlinePage.this.ast.listVariables();
                return variables.toArray(new Variable[variables.size()]);
            }
            if (parentElement == Categories.Files) {
                List files = ClOutlinePage.this.ast.listFiles();
                return files.toArray(new File[files.size()]);
            }
            if (parentElement == Categories.Subroutines) {
                List subroutines = ClOutlinePage.this.ast.listSubroutines();
                return subroutines.toArray(new Subroutine[subroutines.size()]);
            }
            if (parentElement == Categories.Labels) {
                List labels = ClOutlinePage.this.ast.listLabels();
                return labels.toArray(new Label[labels.size()]);
            }
            if (parentElement instanceof File) {
                FileDeclaration fd = ClOutlinePage.this.files.get(parentElement);
                if (fd == null) {
                    return this.nullElements;
                }
                List<RecordFormat> listRecordFormats = fd.listRecordFormats();
                return listRecordFormats.toArray(new RecordFormat[listRecordFormats.size()]);
            }
            if (parentElement instanceof RecordFormat) {
                RecordFormat recordFormat = (RecordFormat)parentElement;
                return recordFormat.getFieldDescriptions();
            }
            return this.nullElements;
        }

        public Object getParent(Object element) {
            if (element instanceof Categories) {
                return ClOutlinePage.this.ast;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ClOutlinePage.this.files.clear();
            if (newInput == null) {
                ClOutlinePage.this.defaultLayout.topControl = ClOutlinePage.this.noOutline;
            } else if (newInput instanceof Ast) {
                ClOutlinePage.this.buildCategories((Ast)newInput);
                if (ClOutlinePage.this.categories.isEmpty()) {
                    ClOutlinePage.this.defaultLayout.topControl = ClOutlinePage.this.noOutline;
                } else {
                    ClOutlinePage.this.defaultLayout.topControl = viewer.getControl();
                    ClOutlinePage.this.buildFileDeclarations(ClOutlinePage.this.ast, ClOutlinePage.this.files);
                }
                ClOutlinePage.this.defaultComposite.layout(true);
            }
        }
    }

    class OutlineLabelProvider
    extends StyledCellLabelProvider {
        OutlineLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            if (obj instanceof Variable) {
                Variable v = (Variable)obj;
                String text = this.buildVariableLabel(v);
                cell.setText(text);
                if (text.length() > v.getName().value.length()) {
                    StyleRange range = new StyleRange();
                    range.start = v.getName().value.length();
                    range.length = text.length() - range.start;
                    range.foreground = ClOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                    LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                    styleRanges.add(range);
                    cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
                }
            } else if (obj instanceof Parameter) {
                cell.setText(((Parameter)obj).token.value);
            } else if (obj instanceof Subroutine) {
                cell.setText(((Subroutine)obj).getName());
            } else if (obj instanceof File) {
                cell.setText(((File)obj).toString());
            } else if (obj instanceof RecordFormat) {
                cell.setText(((RecordFormat)obj).getName());
            } else if (obj instanceof FieldDescription) {
                FieldDescription fd = (FieldDescription)obj;
                StringBuilder sb = new StringBuilder();
                sb.append(fd.getFieldName());
                String type = this.buildFieldTypeLabel(fd);
                if (type == null) {
                    cell.setText(sb.toString());
                } else {
                    sb.append(" : ");
                    sb.append(type);
                    cell.setText(sb.toString());
                    StyleRange range = new StyleRange();
                    range.start = fd.getFieldName().length();
                    range.length = sb.length() - range.start;
                    range.foreground = ClOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                    LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                    styleRanges.add(range);
                    cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
                }
            } else {
                cell.setText(obj.toString());
            }
            cell.setImage(this.getImage(obj));
            super.update(cell);
        }

        private String buildFieldTypeLabel(FieldDescription fd) {
            AS400DataType dataType = fd.getDataType();
            switch (dataType.getInstanceType()) {
                case 0: {
                    return "array";
                }
                case 14: {
                    return "integer (1)";
                }
                case 1: {
                    return "integer (2)";
                }
                case 2: {
                    return "integer (4)";
                }
                case 3: {
                    return "integer (8)";
                }
                case 4: {
                    return "array";
                }
                case 17: {
                    return "date";
                }
                case 5: {
                    return "float (4)";
                }
                case 6: {
                    return "float (8)";
                }
                case 7: {
                    AS400PackedDecimal packedDataType = (AS400PackedDecimal)dataType;
                    return "packed (" + packedDataType.getNumberOfDigits() + ", " + packedDataType.getNumberOfDecimalPositions() + ")";
                }
                case 9: {
                    return null;
                }
                case 18: {
                    return "time";
                }
                case 19: {
                    return "timestamp";
                }
                case 15: {
                    return "unsigned integer (1)";
                }
                case 10: {
                    return "unsigned integer (2)";
                }
                case 11: {
                    return "unsigned integer (4)";
                }
                case 16: {
                    return "unsigned integer (8)";
                }
                case 12: {
                    AS400ZonedDecimal zonedDataType = (AS400ZonedDecimal)dataType;
                    return "zoned (" + zonedDataType.getNumberOfDigits() + ", " + zonedDataType.getNumberOfDecimalPositions() + ")";
                }
            }
            return null;
        }

        private String buildVariableLabel(Variable v) {
            StringBuilder sb = new StringBuilder();
            sb.append(v.getName().value);
            if (v.getType() != null) {
                switch (v.getType()) {
                    case Boolean: {
                        sb.append(" : boolean");
                        break;
                    }
                    case Integer: {
                        sb.append(" : integer (" + String.valueOf(v.getLength()) + ")");
                        break;
                    }
                    case Character: {
                        sb.append(" : character (" + String.valueOf(v.getLength()) + ")");
                        break;
                    }
                    case Pointer: {
                        sb.append(" : pointer");
                        break;
                    }
                    case Decimal: {
                        sb.append(" : decimal (" + String.valueOf(v.getLength()) + ")");
                        break;
                    }
                    case UnsignedInteger: {
                        sb.append(" : unsigned int. (" + String.valueOf(v.getLength()) + ")");
                    }
                }
            }
            return sb.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof Variable) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
            }
            if (obj instanceof Parameter) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PARAMETER");
            }
            if (obj instanceof Subroutine) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_SUBROUTINE");
            }
            if (obj instanceof File) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_FILE");
            }
            if (obj instanceof RecordFormat) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_RECORDFORMAT");
            }
            if (obj instanceof FieldDescription) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
            }
            if (obj instanceof Label) {
                return ClOutlinePage.this.imagePool.getImageUnchecked("IMAGE_LOOPTARGET");
            }
            return null;
        }
    }
}

