/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.themes;

import com.remainsoftware.common.util.ServiceUtils;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors {
    private static Colors colors;
    private ColorRegistry registry = new ColorRegistry();

    public Colors() {
        try {
            IThemeManager themeManager = (IThemeManager)ServiceUtils.getOSGiService(this.getClass(), IThemeManager.class);
            IThemeEngine themeEngine = themeManager.getEngineForDisplay(Display.getCurrent());
            this.setColorTheme(themeEngine.getActiveTheme().getId());
        }
        catch (Exception exception) {
            this.setColorTheme("Classic");
        }
    }

    public static Colors instance() {
        if (colors == null) {
            colors = new Colors();
        }
        return colors;
    }

    public void setColorTheme(String pId) {
        if (pId.contains("dark")) {
            this.registry.put(ColorDefinition.DefaultFont.name(), Solarized.base0.rgb);
            this.registry.put(ColorDefinition.DefaultBackground.name(), Solarized.base03.rgb);
            this.registry.put(ColorDefinition.PrintMargin.name(), Solarized.base01.rgb);
            this.registry.put(ColorDefinition.String.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Code.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.Comment.name(), Solarized.base01.rgb);
            this.registry.put(ColorDefinition.Link.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Html.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Iledocs.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.IledocsBlock.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Keyword.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.Function.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.Variable.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Constant.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.CompilerDirective.name(), Solarized.magenta.rgb);
            this.registry.put(ColorDefinition.ContentAssistReturnValue.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.SecondaryContent.name(), Solarized.base02.rgb);
            this.registry.put(ColorDefinition.Title.name(), Solarized.cyan.rgb);
            this.registry.put(ColorDefinition.BackgroundHighlights.name(), Solarized.base02.rgb);
        } else if (pId.contains("light")) {
            this.registry.put(ColorDefinition.DefaultFont.name(), Solarized.base00.rgb);
            this.registry.put(ColorDefinition.DefaultBackground.name(), Solarized.base3.rgb);
            this.registry.put(ColorDefinition.PrintMargin.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.String.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Code.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.Comment.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.Link.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Html.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Iledocs.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.IledocsBlock.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Keyword.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.Function.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.Variable.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Constant.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.CompilerDirective.name(), Solarized.magenta.rgb);
            this.registry.put(ColorDefinition.ContentAssistReturnValue.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.SecondaryContent.name(), Solarized.base2.rgb);
            this.registry.put(ColorDefinition.Title.name(), Solarized.cyan.rgb);
            this.registry.put(ColorDefinition.BackgroundHighlights.name(), Solarized.base2.rgb);
        } else {
            this.registry.put(ColorDefinition.DefaultFont.name(), Classic.Foreground.rgb);
            this.registry.put(ColorDefinition.DefaultBackground.name(), Classic.Background.rgb);
            this.registry.put(ColorDefinition.PrintMargin.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.String.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Code.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.Comment.name(), Solarized.base1.rgb);
            this.registry.put(ColorDefinition.Link.name(), Solarized.blue.rgb);
            this.registry.put(ColorDefinition.Html.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Iledocs.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.IledocsBlock.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Keyword.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.Function.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.Variable.name(), Solarized.violet.rgb);
            this.registry.put(ColorDefinition.Constant.name(), Solarized.yellow.rgb);
            this.registry.put(ColorDefinition.CompilerDirective.name(), Solarized.magenta.rgb);
            this.registry.put(ColorDefinition.ContentAssistReturnValue.name(), Solarized.orange.rgb);
            this.registry.put(ColorDefinition.SecondaryContent.name(), Classic.Background.rgb);
            this.registry.put(ColorDefinition.Title.name(), Solarized.cyan.rgb);
            this.registry.put(ColorDefinition.BackgroundHighlights.name(), Solarized.base2.rgb);
        }
        this.registry.put(ColorDefinition.Alert.name(), Solarized.red.rgb);
    }

    public Color get(ColorDefinition color) {
        return this.registry.get(color.name());
    }

    public static enum Classic {
        Foreground(0, 0, 0),
        Background(255, 255, 255);

        final RGB rgb;

        private Classic(int r, int g, int b) {
            this.rgb = new RGB(r, g, b);
        }

        public RGB rgb() {
            return this.rgb;
        }
    }

    public static enum ColorDefinition {
        DefaultFont,
        DefaultBackground,
        PrintMargin,
        String,
        Code,
        Comment,
        Link,
        Html,
        Iledocs,
        IledocsBlock,
        Keyword,
        Function,
        Variable,
        Constant,
        CompilerDirective,
        ContentAssistReturnValue,
        SecondaryContent,
        Title,
        Alert,
        BackgroundHighlights;

    }

    public static enum Solarized {
        base03(0, 43, 54),
        base02(7, 54, 66),
        base01(88, 110, 117),
        base00(101, 123, 131),
        base0(131, 148, 150),
        base1(147, 161, 161),
        base2(238, 232, 213),
        base3(253, 246, 227),
        yellow(181, 137, 0),
        orange(203, 75, 22),
        red(220, 50, 47),
        magenta(211, 54, 130),
        violet(108, 113, 196),
        blue(38, 139, 210),
        cyan(42, 161, 152),
        green(65, 133, 153);

        final RGB rgb;

        private Solarized(int r, int g, int b) {
            this.rgb = new RGB(r, g, b);
        }

        public RGB rgb() {
            return this.rgb;
        }
    }
}

