/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util.models;

import com.remainsoftware.common.util.Validate;
import java.util.LinkedHashMap;
import java.util.Map;

public class CdxferRC {
    public static final String CDXFER_FILE_SUBST_OMXFER_QUEBASE = ">>OMXFER_QUEBASE";
    private static Map<String, CdxferRC> rcMap = new LinkedHashMap<String, CdxferRC>();
    private static final String PRE_UNKNOWN_RC = "UNKNOWN_RC_";
    public static final CdxferRC GOOD = new CdxferRC(0, "GOOD");
    public static final CdxferRC WARNING = new CdxferRC(1, "WARNING");
    public static final CdxferRC FAILURE = new CdxferRC(-1, "FAILURE");
    public static final CdxferRC FAILURE_EXIST = new CdxferRC(-2, "FAILURE_EXIST");
    public static final CdxferRC FAILURE_LOCK = new CdxferRC(-3, "FAILURE_LOCK");
    public static final CdxferRC FAILURE_FIND = new CdxferRC(-4, "FAILURE_FIND");
    public static final CdxferRC FAILURE_SESS = new CdxferRC(-5, "FAILURE_SESS");
    public static final CdxferRC FAILURE_RTRY = new CdxferRC(-6, "FAILURE_RTRY");
    public static final CdxferRC FAILURE_EXPR = new CdxferRC(-7, "FAILURE_EXPR");
    public static final CdxferRC FAILURE_IGNR = new CdxferRC(-8, "FAILURE_IGNR");
    public static final CdxferRC FAILURE_PARM = new CdxferRC(-9, "FAILURE_PARM");
    public static final CdxferRC FAILURE_AUTH = new CdxferRC(-10, "FAILURE_AUTH");
    public static final CdxferRC FAILURE_TYPE = new CdxferRC(-11, "FAILURE_TYPE");
    public static final CdxferRC FAILURE_ACCESS = new CdxferRC(-12, "FAILURE_ACCESS");
    public static final CdxferRC FAILURE_BUSY = new CdxferRC(-13, "FAILURE_BUSY");
    public static final CdxferRC FAILURE_FATAL = new CdxferRC(-15, "FAILURE_FATAL");
    public static final CdxferRC FAILURE_CRITICAL = new CdxferRC(-16, "FAILURE_CRITICAL");
    public static final CdxferRC FAILURE_READ = new CdxferRC(-20, "FAILURE_READ");
    public static final CdxferRC FAILURE_WRITE = new CdxferRC(-21, "FAILURE_WRITE");
    public static final CdxferRC FAILURE_CREATE = new CdxferRC(-22, "FAILURE_CREATE");
    public static final CdxferRC FAILURE_UPDATE = new CdxferRC(-23, "FAILURE_UPDATE");
    public static final CdxferRC FAILURE_DELETE = new CdxferRC(-24, "FAILURE_DELETE");
    public static final CdxferRC FAILURE_ADD = new CdxferRC(-25, "FAILURE_ADD");
    public static final CdxferRC FAILURE_OPEN = new CdxferRC(-26, "FAILURE_OPEN");
    public static final CdxferRC FAILURE_CLOSE = new CdxferRC(-27, "FAILURE_CLOSE");
    public static final CdxferRC FAILURE_PREV = new CdxferRC(-30, "FAILURE_PREV");
    public static final CdxferRC FAILURE_NEXT = new CdxferRC(-31, "FAILURE_NEXT");
    public static final CdxferRC FAILURE_FIRST = new CdxferRC(-32, "FAILURE_FIRST");
    public static final CdxferRC FAILURE_LAST = new CdxferRC(-33, "FAILURE_LAST");
    public static final CdxferRC FAILURE_FULL = new CdxferRC(-34, "FAILURE_FULL");
    public static final CdxferRC FAILURE_CMD_UNKNOWN = new CdxferRC(-50, "FAILURE_CMD_UNKNOWN");
    public static final CdxferRC FAILURE_CMD_BUSY = new CdxferRC(-51, "FAILURE_CMD_BUSY");
    public static final CdxferRC FAILURE_RESERVED = new CdxferRC(-99, "FAILURE_RESERVED");
    private final int rc;
    private final String rcStr;
    private final String desc;

    protected CdxferRC(int rcVal, String rcDesc) {
        this.rc = rcVal;
        this.rcStr = Integer.toString(this.rc).trim();
        this.desc = rcDesc;
        rcMap.put(this.rcStr, this);
    }

    public int getIntValue() {
        return this.rc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getFullDescription() {
        return String.valueOf(this.rcStr) + "-" + this.desc;
    }

    public String toString() {
        return this.rcStr;
    }

    public static CdxferRC getCdxferRC(int rc) {
        String rcStr = String.valueOf(rc).trim();
        return CdxferRC.getCdxferRC(rcStr);
    }

    public static CdxferRC getCdxferRC(String rc) {
        Validate.isNumeric(rc);
        String rcStr = rc.trim();
        int rcVal = Integer.parseInt(rcStr);
        for (String key : rcMap.keySet()) {
            if (!key.equals(rcStr)) continue;
            return rcMap.get(key);
        }
        CdxferRC cdxferRc = new CdxferRC(rcVal, PRE_UNKNOWN_RC + rcStr);
        return cdxferRc;
    }

    public static String getDescription(int rc) {
        String rcStr = String.valueOf(rc).trim();
        for (String key : rcMap.keySet()) {
            if (!key.equals(rcStr)) continue;
            CdxferRC cdxferRc = rcMap.get(key);
            return cdxferRc.getDescription();
        }
        return PRE_UNKNOWN_RC + rcStr;
    }

    public static String getDescription(String rc) {
        Validate.isNumeric(rc);
        String rcStr = rc.trim();
        for (String key : rcMap.keySet()) {
            if (!key.equals(rcStr)) continue;
            CdxferRC cdxferRc = rcMap.get(key);
            return cdxferRc.getDescription();
        }
        return PRE_UNKNOWN_RC + rcStr;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof String)) {
            return false;
        }
        return this.rcStr.equals(o);
    }

    public int compareTo(Object o) {
        return this.rcStr.compareTo((String)o);
    }

    public int hashCode() {
        return this.rcStr.hashCode();
    }
}

