/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceUtils {
    public static <T> T getOSGiService(Class<?> requester, Class<T> serviceClass) {
        return ServiceUtils.getOSGiService(requester, serviceClass, null);
    }

    public static <T> T getOSGiService(Class<?> requester, Class<T> serviceClass, String filter) {
        Collection serviceReferences;
        BundleContext context = FrameworkUtil.getBundle(requester).getBundleContext();
        try {
            serviceReferences = context.getServiceReferences(serviceClass, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (serviceReferences == null || serviceReferences.size() == 0) {
            return null;
        }
        Iterator iterator = serviceReferences.iterator();
        if (iterator.hasNext()) {
            ServiceReference reference = (ServiceReference)iterator.next();
            return (T)context.getService(reference);
        }
        return null;
    }

    public static <T> T[] getOSGiServices(Class<?> requester, Class<T> serviceClass, String filter) {
        Collection serviceReferences;
        BundleContext context = FrameworkUtil.getBundle(requester).getBundleContext();
        try {
            serviceReferences = context.getServiceReferences(serviceClass, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return (Object[])Array.newInstance(serviceClass, 0);
        }
        if (serviceReferences == null || serviceReferences.size() == 0) {
            return (Object[])Array.newInstance(serviceClass, 0);
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (ServiceReference reference : serviceReferences) {
            services.add(context.getService(reference));
        }
        return services.toArray((Object[])Array.newInstance(serviceClass, 0));
    }

    public static <T> T[] getOSGiServices(Class<?> requester, Class<T> serviceClass) {
        return ServiceUtils.getOSGiServices(requester, serviceClass, null);
    }

    public static <T> ServiceRegistration<T> registerService(Class<?> pCaller, Class<T> pServiceClass, T pService, Hashtable<String, Object> pProps) {
        BundleContext context = FrameworkUtil.getBundle(pCaller).getBundleContext();
        return context.registerService(pServiceClass, pService, pProps);
    }
}

