/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;

public class ProxyInfo {
    private final String host;
    private int port = -1;
    private final String type;
    private String domain = null;
    private String userName = null;
    private String password = null;
    private boolean complete = false;

    ProxyInfo(String proxyHost, String proxyType) {
        Validate.isNotEmpty(proxyHost);
        Validate.isNotEmpty(proxyType);
        this.host = proxyHost;
        this.type = proxyType;
    }

    ProxyInfo(String proxyHost, int proxyPort, String proxyType) {
        Validate.isNotEmpty(proxyHost);
        Validate.isPositive(proxyPort);
        Validate.isNotEmpty(proxyType);
        this.host = proxyHost;
        this.port = proxyPort;
        this.type = proxyType;
    }

    public String getProxyHost() {
        return this.host;
    }

    public int getProxyPort() {
        return this.port;
    }

    public String getProxyType() {
        return this.type;
    }

    public String getProxyUser() {
        if (StringUtils.isEmpty(this.userName)) {
            return "";
        }
        return this.userName;
    }

    public String getProxyPassword() {
        if (StringUtils.isEmpty(this.password)) {
            return "";
        }
        return this.password;
    }

    public String getProxyDomain() {
        if (StringUtils.isEmpty(this.domain)) {
            return "";
        }
        return this.domain;
    }

    public void setProxyPort(int proxyPort) {
        Validate.isPositive(proxyPort);
        this.port = proxyPort;
    }

    public void setProxyDomain(String proxyDomain) {
        this.domain = proxyDomain;
    }

    public void setUserName(String proxyUserName) {
        this.userName = proxyUserName;
    }

    public void setPassword(String proxyPassword) {
        this.password = proxyPassword;
    }

    public boolean isProxyPortSet() {
        return this.port != -1;
    }

    public boolean isProxyDomainSet() {
        return !StringUtils.isEmpty(this.domain);
    }

    public boolean isProxyUserSet() {
        return !StringUtils.isEmpty(this.userName);
    }

    public boolean isProxyPasswordSet() {
        return !StringUtils.isEmpty(this.password);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setIsComplete() {
        this.complete = true;
    }
}

