/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);

    public static void cleanup(String processId, Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        try {
            InputStream stdout = process.getInputStream();
            if (stdout != null) {
                stdout.close();
            }
        }
        catch (IOException e) {
            logger.debug(String.valueOf(processId) + "; error closing process stdout, msg = " + StringUtils.extractMessage(e));
        }
        try {
            InputStream stderr = process.getErrorStream();
            if (stderr != null) {
                stderr.close();
            }
        }
        catch (IOException e) {
            logger.debug(String.valueOf(processId) + "; error closing process stderr, msg = " + StringUtils.extractMessage(e));
        }
        try {
            OutputStream stdin = process.getOutputStream();
            if (stdin != null) {
                stdin.flush();
                stdin.close();
            }
        }
        catch (IOException e) {
            logger.debug(String.valueOf(processId) + "; error closing process stdin, msg = " + StringUtils.extractMessage(e));
        }
        process.destroy();
        if (process.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }
}

