/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class PasswordPBKDFType {
    private static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    private static final Map<String, String> algorithms = new HashMap<String, String>();
    public static final PasswordPBKDFType DEFAULT_PBKDF2 = new PasswordPBKDFType("PBKDF2WithHmacSHA1", "1", 3, 20, 20, 1000);
    private final String fName;
    private final String fId;
    private final int fIterations;
    private final int fHashByteSize;
    private final int fSaltByteSize;
    private final int fIterationsFactor;

    protected PasswordPBKDFType(String name, String id, int iterations, int hashByteSize, int saltByteSize, int iterationsFactor) {
        this.fName = name;
        this.fId = id;
        this.fIterations = iterations;
        this.fHashByteSize = hashByteSize;
        this.fSaltByteSize = saltByteSize;
        this.fIterationsFactor = iterationsFactor;
        algorithms.put(id, name);
    }

    public String getName() {
        return this.fName;
    }

    public String getId() {
        return this.fId;
    }

    public int getIterations() {
        return this.fIterations;
    }

    public int getIterationsFactor() {
        return this.fIterationsFactor;
    }

    public int getSaltByteSize() {
        return this.fSaltByteSize;
    }

    public int getHashByteSize() {
        return this.fHashByteSize;
    }

    public String toString() {
        return this.fName;
    }

    public static String getMatchForId(String id) {
        if (!StringUtils.isEmpty(id)) {
            return algorithms.get(id);
        }
        return null;
    }
}

