/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.googlecode.ipv6.IPv6Address;
import com.remainsoftware.common.util.ProxyInfo;
import com.remainsoftware.common.util.StringMatcher;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    private static final String LOCAL = "<local>";
    private static final String SOCKS_PROXY_PORT = "socksProxyPort";
    private static final String SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String SOCKS_PROXY_PASSWORD = "java.net.socks.password";
    private static final String SOCKS_PROXY_USER = "java.net.socks.username";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String HTTPS_PROXY_USER = "https.proxyUser";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    private static final String FTP_PROXY_HOST = "ftp.proxyHost";
    private static final String FTP_PROXY_PORT = "ftp.proxyPort";
    private static final String FTP_NON_PROXY_HOSTS = "ftp.nonProxyHosts";
    public static final String BIND_TO_ALL_INTERFACES_ADDRESS = "0.0.0.0";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String IPV4_LOCALHOST_ADDRESS = "127.0.0.1";
    public static final String IPV6_LOCALHOST_ADDRESS = "::ffff:127.0.0.1";
    private static final String IP_V6_ZONE_INDEX_SEPARATOR = "%";
    private static final String IP_V6_PREFIX_SEPARATOR = "/";
    private static final char IP_V6_HEX_GROUP_SEPARATOR_CHAR = ':';
    private static Pattern PATTERN_FOR_IP_V4 = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static final Pattern PERMISSIVE_DOMAIN_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\\\-\\\\.]{1,255}$");
    private static final Pattern DOMAIN_NAME_PATTERN = Pattern.compile("^(?=.{1,255}$)([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$");
    private static List<String> siteLocalIPV4Addresses = null;
    private static List<String> siteLocalIPV6Addresses = null;
    private static List<String> nonSiteLocalIPV4Addresses = null;
    private static List<String> nonSiteLocalIPV6Addresses = null;
    private static List<InetAddress> siteLocalInets = new ArrayList<InetAddress>();
    private static List<InetAddress> nonSiteLocalInets = new ArrayList<InetAddress>();
    private static final boolean PREFERIPv4STACK = Boolean.getBoolean("java.net.preferIPv4Stack");
    private static Object proxySync = new Object();
    private static boolean PREFERIPv6ADDRESSES = PREFERIPv4STACK ? false : Boolean.getBoolean("java.net.preferIPv6Addresses");
    private static volatile boolean isInitProxy = false;
    private static String omxNonProxiedHosts = System.getProperty("omx.nonProxyHosts");
    private static boolean isOmxFallbackSystemProxy = Boolean.getBoolean("omx.fallbackSystemProxy");
    static boolean isEclipseProxiesSet = false;
    private static String[] nonProxiedHostsOverride = new String[0];
    private static Map<String, String> maccAddressesVMs = new HashMap<String, String>();
    private static String[] vmMacAddresses = null;
    private static char[] INT_TO_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        maccAddressesVMs.put("VMware ESX", "00:50:56");
        maccAddressesVMs.put("VMware Server", "00:0C:29");
        maccAddressesVMs.put("VMware Workstation+", "00:05:69");
        maccAddressesVMs.put("Microsoft Hyper-V+", "00:03:FF");
        maccAddressesVMs.put("Parallells Server+", "00:1C:42");
        maccAddressesVMs.put("Virtual Iron4", "00:0F:4B");
        maccAddressesVMs.put("Novell/Red Hat Xen, XenSource, Oracle VM", "00:16:3E");
        maccAddressesVMs.put("Sun VirtualBox", "08:00:27");
        maccAddressesVMs.put("Oracle VirtualBox5+", "0A:00:27");
        vmMacAddresses = maccAddressesVMs.values().toArray(new String[maccAddressesVMs.size()]);
    }

    private NetUtils() {
    }

    public static boolean isIp4TypeAddress(String ipAddress) {
        if (StringUtils.isEmpty(ipAddress)) {
            return false;
        }
        Matcher m1 = PATTERN_FOR_IP_V4.matcher(ipAddress.trim());
        return m1.matches();
    }

    public static boolean isIp6TypeAddress(String ipAddress) {
        return !StringUtils.isEmpty(ipAddress) && (ipAddress = NetUtils.getExpandedIPv6Address(ipAddress.trim())).length() > 0;
    }

    public static boolean isIp6TypeAddressLenient(String ipAddress) {
        if (StringUtils.isEmpty(ipAddress)) {
            return false;
        }
        ipAddress = StringUtils.removeSurroundingSquareBrackets(ipAddress.trim());
        String[] groups = (ipAddress = NetUtils.stripZoneOrPrefixIndicator(ipAddress.trim())).split(":");
        if (groups.length < 3 || groups.length > 8) {
            return false;
        }
        int i = 0;
        while (i < groups.length) {
            String group = groups[i];
            if (group.length() != 0) {
                if (i == groups.length - 1 && NetUtils.isIp4TypeAddress(group)) {
                    return true;
                }
                if (group.length() > 4) {
                    return false;
                }
                if (!StringUtils.isHexString(group)) {
                    return false;
                }
            }
            ++i;
        }
        int occurs = StringUtils.countOccurrences(ipAddress, ':');
        return occurs >= 2 && occurs <= 7;
    }

    public static String getExpandedIPv6Address(String ipAddress) {
        block3: {
            if (!StringUtils.isEmpty(ipAddress)) {
                ipAddress = StringUtils.removeSurroundingSquareBrackets(ipAddress.trim());
                ipAddress = NetUtils.stripZoneOrPrefixIndicator(ipAddress.trim());
                try {
                    IPv6Address ipv6 = IPv6Address.fromString((String)ipAddress);
                    return ipv6.toLongString();
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(String.format("normalizeIPv6Address detected an invalid IPv6 address: '%s'", ipAddress.trim()));
                }
            }
        }
        return "";
    }

    private static String stripZoneOrPrefixIndicator(String ipAddress) {
        int loc = ipAddress.lastIndexOf(IP_V6_ZONE_INDEX_SEPARATOR);
        if (loc == -1) {
            loc = ipAddress.lastIndexOf(IP_V6_PREFIX_SEPARATOR);
        }
        if (loc > 0) {
            ipAddress = ipAddress.substring(0, loc);
        }
        return ipAddress;
    }

    public static boolean isIPAddress(String ipAddress) {
        return !StringUtils.isEmpty(ipAddress) && (NetUtils.isIp4TypeAddress(ipAddress) || NetUtils.isIp6TypeAddressLenient(ipAddress));
    }

    /*
     * Loose catch block
     */
    public static boolean isAvailableLocalPort(int port) {
        Socket s;
        block11: {
            s = null;
            s = new Socket(NetUtils.getPreferredLocalHostAddress(), port);
            if (s == null) break block11;
            try {
                s.close();
            }
            catch (IOException e) {
                logger.error(String.format("an exception occurred while testing for availability of port: %d on localhost, msg = %s", port, StringUtils.extractMessage(e)), (Throwable)e);
            }
        }
        return false;
        catch (IOException iOException) {
            block12: {
                try {
                    if (s == null) break block12;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException e) {
                            logger.error(String.format("an exception occurred while testing for availability of port: %d on localhost, msg = %s", port, StringUtils.extractMessage(e)), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                try {
                    s.close();
                }
                catch (IOException e) {
                    logger.error(String.format("an exception occurred while testing for availability of port: %d on localhost, msg = %s", port, StringUtils.extractMessage(e)), (Throwable)e);
                }
            }
            return true;
        }
    }

    public static String setupForUrl(String hostAddress) {
        if (hostAddress != null && NetUtils.isIp6TypeAddressLenient(hostAddress) && !hostAddress.startsWith("[")) {
            return "[" + hostAddress + "]";
        }
        return hostAddress;
    }

    public static boolean isValidHttpProtocol(String str) {
        return str != null && (str.equalsIgnoreCase("http") || str.equalsIgnoreCase("https"));
    }

    public static boolean isValidIpPort(int port) {
        return port >= 1 && port <= 65535;
    }

    public static boolean isHttpsProtocol(String urlStr) {
        if (!StringUtils.isEmpty(urlStr)) {
            try {
                URL url = new URL(urlStr);
                return url.getProtocol().equalsIgnoreCase("https");
            }
            catch (MalformedURLException malformedURLException) {
                logger.error(String.format("Failed test on isHttpsProtocol for url: '%s', reason = url is malformed", urlStr));
            }
        }
        return false;
    }

    public static boolean isLocalHostType(String hostName) {
        if (StringUtils.isEmpty(hostName)) {
            return false;
        }
        int index = hostName.indexOf(IP_V6_PREFIX_SEPARATOR);
        if (index >= 0) {
            hostName = hostName.substring(index + 1);
        }
        hostName = NetUtils.stripZoneOrPrefixIndicator(hostName);
        hostName = StringUtils.removeSurroundingSquareBrackets(hostName);
        return (hostName = hostName.split(":")[0]).equalsIgnoreCase(LOCALHOST_NAME) || hostName.equals(IPV4_LOCALHOST_ADDRESS) || hostName.equals("::1") || hostName.equals("0:0:0:0:0:0:0:1") || hostName.equals(IPV6_LOCALHOST_ADDRESS);
    }

    public static String getLocalHostIpAddress(String hostName) {
        try {
            InetAddress inetAddr = InetAddress.getByName(hostName);
            return inetAddr.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            logger.warn("failed to resolve host name: '" + hostName + "'");
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String resolveHostAddress(String ipAddress) {
        block33: {
            block31: {
                block32: {
                    block30: {
                        block28: {
                            block29: {
                                resolved = new ArrayList<String>();
                                if (StringUtils.isEmpty(ipAddress)) {
                                    NetUtils.logger.error(String.format("provided ip address is not an IPv4 or IPv6 address: '%s'", new Object[]{ipAddress}));
                                    return "";
                                }
                                reverseDnsDomain = null;
                                ctx = null;
                                if (NetUtils.isIp4TypeAddress(ipAddress)) {
                                    reverseDnsDomain = NetUtils.iPv4AddressToReverseDnsEntry(ipAddress);
                                    break block28;
                                }
                                if (NetUtils.isIp6TypeAddress(ipAddress)) {
                                    reverseDnsDomain = NetUtils.iPv6AddressToReverseDnsEntry(ipAddress);
                                    break block28;
                                }
                                NetUtils.logger.error("provided ip address is not an IPv4 or IPv6 address: '" + ipAddress + "'");
                                if (ctx == null) break block29;
                                try {
                                    ctx.close();
                                }
                                catch (Exception v0) {}
                            }
                            return "";
                        }
                        env = new Hashtable<String, String>();
                        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                        ctx = new InitialDirContext(env);
                        try {
                            attrs = ctx.getAttributes(reverseDnsDomain, new String[]{"PTR"});
                            ptrValue = null;
                            ae = attrs.getAll();
                            while (ae.hasMoreElements()) {
                                attr = ae.next();
                                attrId = attr.getID();
                                vals = attr.getAll();
                                while (vals.hasMoreElements()) {
                                    ptrValue = vals.nextElement().toString();
                                    if (!"PTR".equals(attrId) || ptrValue.charAt((len = ptrValue.length()) - 1) != '.') continue;
                                    ptrValue = ptrValue.substring(0, len - 1);
                                    resolved.add(ptrValue);
                                }
                            }
                        }
                        catch (NameNotFoundException v1) {
                            if (!NetUtils.logger.isDebugEnabled()) break block30;
                            NetUtils.logger.debug(String.format("Reverse DNS lookup did not resolve the IP address: '%s'", new Object[]{ipAddress}));
                        }
                    }
                    if (resolved.size() <= 1) break block31;
                    var13_13 = (String)resolved.get(0);
                    if (ctx == null) break block32;
                    try {
                        ctx.close();
                    }
                    catch (Exception v2) {}
                }
                return var13_13;
                catch (Exception e) {
                    try {
                        NetUtils.logger.error(String.format("Exception occurred on reverse DNS lookup for IP address: '%s', message = %s", new Object[]{ipAddress, StringUtils.extractMessage(e)}));
                        ** if (ctx == null) goto lbl-1000
                    }
                    catch (Throwable var12_14) {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (Exception v4) {}
                        }
                        throw var12_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ctx.close();
                        }
                        catch (Exception v3) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block33;
                    }
                }
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception v5) {}
            }
        }
        try {
            inetAddr = InetAddress.getByName(ipAddress);
            hostName = inetAddr.getCanonicalHostName();
            if (!StringUtils.isEmpty(hostName)) {
                return NetUtils.nsLookup(hostName);
            }
        }
        catch (UnknownHostException v6) {
            NetUtils.logger.debug(String.format("Reverse DNS lookup (getCanonicalHostName) did not resolve IP address: '%s'", new Object[]{ipAddress}));
        }
        return "";
    }

    private static String iPv4AddressToReverseDnsEntry(String ipAddress) {
        String[] bytes = ipAddress.split("\\.");
        return String.valueOf(bytes[3]) + "." + bytes[2] + "." + bytes[1] + "." + bytes[0] + ".in-addr.arpa";
    }

    private static String iPv6AddressToReverseDnsEntry(String ipAddress) {
        if ((ipAddress = NetUtils.getExpandedIPv6Address(ipAddress)).length() == 0) {
            return "";
        }
        String[] groups = ipAddress.split("\\:");
        StringBuilder sb = new StringBuilder();
        int i = groups.length - 1;
        while (i >= 0) {
            char[] groupChars = groups[i].toCharArray();
            int j = groupChars.length - 1;
            while (j >= 0) {
                sb.append(groupChars[j]);
                sb.append(".");
                --j;
            }
            --i;
        }
        sb.append("ip6.arpa");
        return sb.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String nsLookup(String domain) {
        Attribute records;
        InitialDirContext context;
        block22: {
            Validate.isNotEmpty(domain, "domain to lookup  must be set");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            context = null;
            context = new InitialDirContext(env);
            Attributes dnsLookup = null;
            try {
                dnsLookup = context.getAttributes(domain, new String[]{"A"});
            }
            catch (NamingException namingException) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("nsLookup; no DNS entry found for domain: '%s'", domain));
                }
                if (context == null) return "";
                try {
                    context.close();
                    return "";
                }
                catch (Exception exception) {}
                return "";
            }
            records = dnsLookup.get("A");
            if (records != null && records.size() != 0) break block22;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("nsLookup; no DNS records found for domain: '%s'", domain));
            }
            if (context == null) return "";
            try {
                context.close();
                return "";
            }
            catch (Exception exception) {}
            return "";
        }
        int i = 0;
        while (i < records.size()) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("nsLookup; %s: %s", domain, records.get(i)));
            }
            ++i;
        }
        String string = records.get(0).toString();
        if (context == null) return string;
        try {
            context.close();
            return string;
        }
        catch (Exception exception) {}
        return string;
        catch (NamingException e) {
            try {
                logger.error(String.format("nsLookup failed with an exception for domain: '%s', reason = %s", domain, StringUtils.extractMessage(e)));
                if (context == null) return "";
            }
            catch (Throwable throwable) {
                if (context == null) throw throwable;
                try {
                    context.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                context.close();
                return "";
            }
            catch (Exception exception) {}
            return "";
        }
    }

    public static synchronized InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            NetUtils.setupLocalInetAddresses();
            InetAddress siteLocalIPv4 = null;
            InetAddress siteLocalIPv6 = null;
            if (!siteLocalInets.isEmpty()) {
                for (InetAddress inetAddr : siteLocalInets) {
                    if (inetAddr instanceof Inet4Address) {
                        if (siteLocalIPv4 != null) continue;
                        siteLocalIPv4 = inetAddr;
                        if (NetUtils.isPreferIpv6Addresses()) continue;
                        return siteLocalIPv4;
                    }
                    if (inetAddr.isLinkLocalAddress() || siteLocalIPv6 != null) continue;
                    siteLocalIPv6 = inetAddr;
                    if (!NetUtils.isPreferIpv6Addresses()) continue;
                    return siteLocalIPv6;
                }
            }
            if (siteLocalIPv4 != null) {
                return siteLocalIPv4;
            }
            if (siteLocalIPv6 != null) {
                return siteLocalIPv6;
            }
            InetAddress nonSiteLocalIPv4 = null;
            InetAddress nonSiteLocalIPv6 = null;
            if (!nonSiteLocalInets.isEmpty()) {
                for (InetAddress inetAddr : nonSiteLocalInets) {
                    if (inetAddr instanceof Inet4Address) {
                        if (nonSiteLocalIPv4 == null) {
                            nonSiteLocalIPv4 = inetAddr;
                            if (!NetUtils.isPreferIpv6Addresses()) {
                                return nonSiteLocalIPv4;
                            }
                        }
                    } else if (!inetAddr.isLinkLocalAddress() && nonSiteLocalIPv6 == null) {
                        nonSiteLocalIPv6 = inetAddr;
                        if (NetUtils.isPreferIpv6Addresses()) {
                            return nonSiteLocalIPv6;
                        }
                    }
                    if (nonSiteLocalIPv4 != null && nonSiteLocalIPv6 != null) break;
                }
            }
            if (nonSiteLocalIPv4 != null) {
                return nonSiteLocalIPv4;
            }
            if (nonSiteLocalIPv6 != null) {
                return nonSiteLocalIPv6;
            }
        }
        catch (Exception e) {
            logger.error(String.format("failed to determine local host LAN address through getNetworkInterfaces(), reason = %s", StringUtils.extractMessage(e)), (Throwable)e);
        }
        InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
        if (jdkSuppliedAddress == null) {
            throw new UnknownHostException("InetAddress.getLocalHost() unexpectedly returned null.");
        }
        return jdkSuppliedAddress;
    }

    private static synchronized void setupLocalInetAddresses() throws Exception {
        NetUtils.setupAddressVars();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            if (NetUtils.isVmAdapter(iface) || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint()) continue;
            Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
            while (inetAddrs.hasMoreElements()) {
                InetAddress inetAddr = inetAddrs.nextElement();
                if (inetAddr.isLoopbackAddress()) continue;
                if (inetAddr instanceof Inet4Address) {
                    if (inetAddr.isSiteLocalAddress()) {
                        siteLocalIPV4Addresses.add(inetAddr.getHostAddress());
                        siteLocalInets.add(inetAddr);
                        continue;
                    }
                    nonSiteLocalIPV4Addresses.add(inetAddr.getHostAddress());
                    nonSiteLocalInets.add(inetAddr);
                    continue;
                }
                if (inetAddr.isSiteLocalAddress()) {
                    siteLocalIPV6Addresses.add(NetUtils.getExpandedIPv6Address(inetAddr.getHostAddress()));
                    siteLocalInets.add(inetAddr);
                    continue;
                }
                nonSiteLocalIPV6Addresses.add(NetUtils.getExpandedIPv6Address(inetAddr.getHostAddress()));
                nonSiteLocalInets.add(inetAddr);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVmAdapter(NetworkInterface iface) {
        if (iface == null) return false;
        try {
            byte[] macAddress = iface.getHardwareAddress();
            if (macAddress == null) return false;
            String ifaceMacAddr = NetUtils.buildMACAddressString(macAddress);
            String[] stringArray = vmMacAddresses;
            int n = vmMacAddresses.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String vmMac = stringArray[n2];
                if (ifaceMacAddr.startsWith(vmMac)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (SocketException socketException) {
            logger.debug(String.format("failed to get mac address for interface: %s", iface.getDisplayName()));
        }
        return false;
    }

    public static String buildMACAddressString(byte[] macaddress) {
        char[] buffer = new char[macaddress.length * 3];
        int destIndex = 0;
        int i = 0;
        while (i < macaddress.length) {
            byte byteValue = (byte)(macaddress[i] & 0xFF);
            buffer[destIndex++] = INT_TO_HEX_CHARS[(byteValue & 0xF0) >> 4];
            buffer[destIndex++] = INT_TO_HEX_CHARS[byteValue & 0xF];
            if (i < macaddress.length - 1) {
                buffer[destIndex++] = 58;
            }
            ++i;
        }
        return String.valueOf(buffer, 0, destIndex);
    }

    private static void setupAddressVars() {
        if (siteLocalIPV4Addresses == null) {
            siteLocalIPV4Addresses = new ArrayList<String>();
        } else {
            siteLocalIPV4Addresses.clear();
        }
        if (nonSiteLocalIPV4Addresses == null) {
            nonSiteLocalIPV4Addresses = new ArrayList<String>();
        } else {
            nonSiteLocalIPV4Addresses.clear();
        }
        if (siteLocalIPV6Addresses == null) {
            siteLocalIPV6Addresses = new ArrayList<String>();
        } else {
            siteLocalIPV6Addresses.clear();
        }
        if (nonSiteLocalIPV6Addresses == null) {
            nonSiteLocalIPV6Addresses = new ArrayList<String>();
        } else {
            nonSiteLocalIPV6Addresses.clear();
        }
        siteLocalInets.clear();
        nonSiteLocalInets.clear();
    }

    public static boolean isLocalAddress(String hostAddress) {
        if (!StringUtils.isEmpty(hostAddress) && !hostAddress.contains("*")) {
            if (hostAddress.startsWith(IP_V6_PREFIX_SEPARATOR)) {
                hostAddress = hostAddress.substring(1);
            }
            if (!NetUtils.isIPAddress(hostAddress = hostAddress.split(":")[0])) {
                try {
                    hostAddress = InetAddress.getByName(hostAddress).getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.warn(String.format("Failed to resolve host name: '%s', reason = %s", hostAddress, StringUtils.extractMessage(e)));
                    return false;
                }
            }
            if (NetUtils.isIp4TypeAddress(hostAddress) ? NetUtils.getSiteLocalIPV4AddressList().contains(hostAddress) || NetUtils.getNonSiteLocalIPV4AddressList().contains(hostAddress) : NetUtils.isIp6TypeAddressLenient(hostAddress) && (NetUtils.getSiteLocalIPV6AddressList().contains(hostAddress) || NetUtils.getNonSiteLocalIPV6AddressList().contains(hostAddress))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLocallyBoundIpAddress(String sourceLocation) {
        if (sourceLocation == null) {
            return false;
        }
        String[] parts = sourceLocation.split(IP_V6_PREFIX_SEPARATOR);
        String ipAddress = parts[0];
        if (parts.length > 1) {
            ipAddress = parts[1];
        }
        if (NetUtils.isLocalHostType(ipAddress)) {
            return true;
        }
        if (NetUtils.isIp4TypeAddress(ipAddress)) {
            List<String> siteLocalList = NetUtils.getSiteLocalIPV4AddressList();
            for (String localIpAddress : siteLocalList) {
                if (!localIpAddress.equals(ipAddress)) continue;
                return true;
            }
            siteLocalList = NetUtils.getNonSiteLocalIPV4AddressList();
            for (String localIpAddress : siteLocalList) {
                if (!localIpAddress.equals(ipAddress)) continue;
                return true;
            }
        } else {
            List<String> siteLocalList = NetUtils.getSiteLocalIPV6AddressList();
            for (String localIpAddress : siteLocalList) {
                if (!localIpAddress.equals(ipAddress)) continue;
                return true;
            }
            siteLocalList = NetUtils.getNonSiteLocalIPV6AddressList();
            for (String localIpAddress : siteLocalList) {
                if (!localIpAddress.equals(ipAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized List<String> getSiteLocalIPV4AddressList() {
        if (siteLocalIPV4Addresses == null) {
            try {
                NetUtils.getLocalHostLANAddress();
            }
            catch (Exception e) {
                logger.error(String.format("error while resolving site local ipv4 addresses, reason = %s, action = returning empty list", e.getMessage()));
                siteLocalIPV4Addresses = null;
                return new ArrayList<String>();
            }
        }
        return siteLocalIPV4Addresses;
    }

    public static synchronized List<String> getSiteLocalIPV6AddressList() {
        if (siteLocalIPV6Addresses == null) {
            try {
                NetUtils.getLocalHostLANAddress();
            }
            catch (Exception e) {
                logger.error(String.format("error while resolving site local ipv6 addresses, reason = %s, action = returning empty list", e.getMessage()));
                siteLocalIPV6Addresses = null;
                return new ArrayList<String>();
            }
        }
        return siteLocalIPV6Addresses;
    }

    public static synchronized List<String> getNonSiteLocalIPV4AddressList() {
        block3: {
            if (nonSiteLocalIPV4Addresses == null) {
                try {
                    NetUtils.getLocalHostLANAddress();
                }
                catch (Exception e) {
                    logger.error(String.format("error while resolving non-site local ip-addresses, reason = %s, action = returning empty list", e.getMessage()));
                    if (nonSiteLocalIPV4Addresses != null) break block3;
                    return new ArrayList<String>();
                }
            }
        }
        return nonSiteLocalIPV4Addresses;
    }

    public static synchronized List<String> getNonSiteLocalIPV6AddressList() {
        block3: {
            if (nonSiteLocalIPV6Addresses == null) {
                try {
                    NetUtils.getLocalHostLANAddress();
                }
                catch (Exception e) {
                    logger.error(String.format("error while resolving non-site local ip-addresses, reason = %s, action = returning empty list", e.getMessage()));
                    if (nonSiteLocalIPV6Addresses != null) break block3;
                    return new ArrayList<String>();
                }
            }
        }
        return nonSiteLocalIPV6Addresses;
    }

    public static boolean isPreferIpv4stack() {
        return PREFERIPv4STACK;
    }

    public static boolean isPreferIpv6Addresses() {
        return PREFERIPv6ADDRESSES;
    }

    public static String getPreferredLocalHostAddress() {
        if (!NetUtils.isPreferIpv6Addresses()) {
            return IPV4_LOCALHOST_ADDRESS;
        }
        return IPV6_LOCALHOST_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyInfo getProxyInfo(URI uri) {
        if (uri == null) {
            return null;
        }
        Object object = proxySync;
        synchronized (object) {
            if (!isInitProxy) {
                isInitProxy = true;
                nonProxiedHostsOverride = NetUtils.getNonProxiedHostsOverride();
                NetUtils.logProxySettingsFromEclipse();
                NetUtils.logSystemProxySettings();
            }
            ProxyInfo proxyInfo = null;
            if (!NetUtils.isOverriddenNonProxyHost(uri) && (proxyInfo = NetUtils.getHttpTypeProxyFromEclipse(uri)) == null && isOmxFallbackSystemProxy) {
                proxyInfo = NetUtils.getProxyFromSystem(uri);
            }
            return proxyInfo;
        }
    }

    public static int getProxyPort(String proxyType) {
        int proxyPort = -1;
        String proxyPortStr = null;
        proxyPortStr = proxyType.equalsIgnoreCase("https") ? System.getProperty(HTTPS_PROXY_PORT) : (proxyType.equalsIgnoreCase("http") ? System.getProperty(HTTP_PROXY_PORT) : (proxyType.equalsIgnoreCase("ftp") ? System.getProperty(FTP_PROXY_PORT) : System.getProperty(SOCKS_PROXY_PORT)));
        if (!StringUtils.isEmpty(proxyPortStr)) {
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error(String.format("Invalid value set for http(s).proxyPort: %s", proxyPortStr));
            }
        }
        return proxyPort;
    }

    public static int getDefaultProxyPort(String proxyType) {
        if (StringUtils.isEmpty(proxyType)) {
            if (proxyType.equalsIgnoreCase("https")) {
                return 443;
            }
            if (proxyType.equalsIgnoreCase("http")) {
                return 80;
            }
            if (proxyType.equalsIgnoreCase("ftp")) {
                return 21;
            }
            if (proxyType.equalsIgnoreCase("ssh")) {
                return 22;
            }
            if (proxyType.equalsIgnoreCase("socks")) {
                return 1080;
            }
        }
        return -1;
    }

    public static ProxyInfo getHttpTypeProxyFromEclipse(URI uri) {
        Validate.isNotNull(uri);
        ProxyInfo httpProxyInfo = null;
        IProxyData[] proxyDatas = NetUtils.getEclipseProxyData(uri);
        if (proxyDatas.length != 0) {
            IProxyData[] iProxyDataArray = proxyDatas;
            int n = proxyDatas.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxyData = iProxyDataArray[n2];
                if (proxyData.getType().equalsIgnoreCase(uri.getScheme())) {
                    httpProxyInfo = new ProxyInfo(proxyData.getHost(), proxyData.getPort(), proxyData.getType());
                    if (!StringUtils.isEmpty(proxyData.getUserId())) {
                        httpProxyInfo.setUserName(proxyData.getUserId());
                        httpProxyInfo.setPassword(proxyData.getPassword());
                    }
                    httpProxyInfo.setIsComplete();
                    NetUtils.logProxyIfo(uri, httpProxyInfo, "eclipse");
                    break;
                }
                ++n2;
            }
            logger.info(String.format("uri: %s resolved to eclipse proxy host", uri.toString()));
            return httpProxyInfo;
        }
        return null;
    }

    public static ProxyInfo getProxyFromSystem(URI uri) {
        if (uri == null || NetUtils.isNonProxyHost(uri)) {
            return null;
        }
        ProxyInfo proxyInfo = null;
        String httpsProxyHost = System.getProperty(HTTPS_PROXY_HOST);
        String httpProxyHost = System.getProperty(HTTP_PROXY_HOST);
        String ftpProxyHost = System.getProperty(FTP_PROXY_HOST);
        String socksProxyHost = System.getProperty(SOCKS_PROXY_HOST);
        String scheme = uri.getScheme().toLowerCase();
        if (scheme.equals("http")) {
            if (!StringUtils.isEmpty(httpProxyHost)) {
                proxyInfo = new ProxyInfo(httpProxyHost, "HTTP");
            }
        } else if (scheme.equals("https")) {
            if (!StringUtils.isEmpty(httpsProxyHost)) {
                proxyInfo = new ProxyInfo(httpsProxyHost, "HTTPS");
            }
        } else if (scheme.equals("sftp")) {
            if (!StringUtils.isEmpty(socksProxyHost)) {
                proxyInfo = new ProxyInfo(httpsProxyHost, "SOCKS");
            } else if (!StringUtils.isEmpty(httpProxyHost)) {
                proxyInfo = new ProxyInfo(httpProxyHost, "HTTP");
            }
        } else if (scheme.equals("ftp")) {
            if (!StringUtils.isEmpty(ftpProxyHost)) {
                proxyInfo = new ProxyInfo(ftpProxyHost, "FTP");
            } else if (!StringUtils.isEmpty(socksProxyHost)) {
                proxyInfo = new ProxyInfo(socksProxyHost, "SOCKS");
            }
        }
        if (proxyInfo != null) {
            int proxyPort = NetUtils.getProxyPort(proxyInfo.getProxyType());
            if (proxyPort == -1) {
                proxyPort = NetUtils.getDefaultProxyPort(proxyInfo.getProxyType());
            }
            if (proxyPort > 0) {
                proxyInfo.setProxyPort(proxyPort);
            }
            String proxyUser = null;
            String proxyType = proxyInfo.getProxyType().toLowerCase();
            proxyUser = proxyType.equals("socks") ? System.getProperty(SOCKS_PROXY_USER) : System.getProperty(String.valueOf(proxyType) + ".proxyUser");
            if (!StringUtils.isEmpty(proxyUser)) {
                String proxyPassword = null;
                if (proxyType.equals("socks")) {
                    proxyUser = System.getProperty(SOCKS_PROXY_PASSWORD, "");
                } else {
                    proxyPassword = System.getProperty(String.valueOf(proxyType) + ".proxyPassword", "");
                }
                proxyInfo.setUserName(proxyUser);
                proxyInfo.setPassword(proxyPassword);
            }
            NetUtils.logProxyIfo(uri, proxyInfo, "system");
            proxyInfo.setIsComplete();
        } else {
            logger.info(String.format("uri: %s did not resolve to system set proxy host", uri.toString()));
        }
        return proxyInfo;
    }

    private static void logProxyIfo(URI uri, ProxyInfo proxyInfo, String source) {
        logger.info(String.format("Retrieved %s proxy info: %s%s (port: %s) for URL: %s", source, proxyInfo.isProxyUserSet() ? String.valueOf(proxyInfo.getProxyUser()) + "@" : "", proxyInfo.getProxyHost(), proxyInfo.getProxyPort() != -1 ? ":" + proxyInfo.getProxyPort() : "*NOTSET", uri.toString()));
    }

    private static void logSystemProxySettings() {
        String nonProxyHosts;
        String socksProxyHost;
        String ftpProxyHost;
        String httpsProxyHost;
        String httpProxyHost = System.getProperty(HTTP_PROXY_HOST);
        if (!StringUtils.isEmpty(httpProxyHost)) {
            String httpProxyPort = System.getProperty(HTTP_PROXY_PORT);
            String httpProxyUser = System.getProperty(HTTP_PROXY_USER);
            logger.info(String.format("http proxy info: [ %s%s:%s ]", httpProxyUser != null ? String.valueOf(httpProxyUser) + "@" : "", httpProxyHost, httpProxyPort));
        }
        if (!StringUtils.isEmpty(httpsProxyHost = System.getProperty(HTTPS_PROXY_HOST))) {
            String httpsProxyPort = System.getProperty(HTTPS_PROXY_PORT);
            String httpsProxyUser = System.getProperty(HTTPS_PROXY_USER);
            logger.info(String.format("https proxy info: [ %s%s:%s ]", httpsProxyUser != null ? String.valueOf(httpsProxyUser) + "@" : "", httpsProxyHost, httpsProxyPort));
        }
        if (!StringUtils.isEmpty(ftpProxyHost = System.getProperty(FTP_PROXY_HOST))) {
            String ftpProxyPort = System.getProperty(FTP_PROXY_PORT);
            String ftpProxyUser = System.getProperty("ftp.proxyUser");
            logger.info(String.format("https proxy info: [ %s%s:%s ]", ftpProxyUser != null ? String.valueOf(ftpProxyUser) + "@" : "", ftpProxyHost, ftpProxyPort));
        }
        if (!StringUtils.isEmpty(socksProxyHost = System.getProperty(SOCKS_PROXY_HOST))) {
            String socksProxyPort = System.getProperty(SOCKS_PROXY_PORT);
            String socksProxyUser = System.getProperty(SOCKS_PROXY_USER);
            logger.info(String.format("socks proxy info: [ %s%s:%s ]", socksProxyUser != null ? String.valueOf(socksProxyUser) + "@" : "", socksProxyHost, socksProxyPort));
        }
        if (!StringUtils.isEmpty(nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS))) {
            logger.info(String.format("non proxy hosts http: [ %s ]", nonProxyHosts));
        }
        if (!StringUtils.isEmpty(nonProxyHosts = System.getProperty(HTTPS_NON_PROXY_HOSTS))) {
            logger.info(String.format("non proxy hosts https: [ %s ]", nonProxyHosts));
        }
        if (!StringUtils.isEmpty(nonProxyHosts = System.getProperty(FTP_NON_PROXY_HOSTS))) {
            logger.info(String.format("non proxy hosts ftp: [ %s ]", nonProxyHosts));
        }
    }

    public static IProxyData[] getEclipseProxyData(URI uri) {
        if (uri == null) {
            return new IProxyData[0];
        }
        Bundle bundle = FrameworkUtil.getBundle(NetUtils.class);
        if (bundle != null) {
            BundleContext context = bundle.getBundleContext();
            ServiceTracker proxyTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
            proxyTracker.open();
            IProxyService proxyService = (IProxyService)proxyTracker.getService();
            try {
                IProxyData[] proxies;
                if (proxyService != null && proxyService.isProxiesEnabled() && (proxies = proxyService.select(uri)).length > 0) {
                    IProxyData[] iProxyDataArray = proxies;
                    return iProxyDataArray;
                }
            }
            finally {
                proxyService = null;
                proxyTracker.close();
            }
        }
        return new IProxyData[0];
    }

    protected static void setNonProxyHostFromEclipse(String[] nonProxiedHosts) {
        if (nonProxiedHosts != null && nonProxiedHosts.length > 0) {
            StringBuilder sb = new StringBuilder();
            int ix = 0;
            while (ix < nonProxiedHosts.length) {
                if (nonProxiedHosts[ix].equals(LOCAL)) {
                    sb.append("127.0.0.1|localhost");
                } else {
                    sb.append(nonProxiedHosts[ix]);
                }
                if (ix < nonProxiedHosts.length - 1) {
                    sb.append("|");
                }
                ++ix;
            }
            System.setProperty(HTTP_NON_PROXY_HOSTS, sb.toString());
        }
    }

    private static void logProxySettingsFromEclipse() {
        Bundle bundle = FrameworkUtil.getBundle(NetUtils.class);
        if (bundle != null) {
            BundleContext context = bundle.getBundleContext();
            ServiceTracker proxyTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
            proxyTracker.open();
            IProxyService proxyService = (IProxyService)proxyTracker.getService();
            try {
                if (proxyService != null) {
                    isEclipseProxiesSet = proxyService.isProxiesEnabled();
                    logger.info(String.format("eclipse proxy info: [ proxy-enabled=%s, system-proxy-set=%s ]", isEclipseProxiesSet, proxyService.isSystemProxiesEnabled()));
                }
                logger.error("failed to determine eclipse proxy state, reason = proxy service is not available");
            }
            finally {
                proxyService = null;
                proxyTracker.close();
            }
        } else {
            logger.error("failed to determine eclipse proxy state, reason = failed to get bundle context for NetUtils.class");
        }
    }

    protected static void setSystemProxyPropertiesFromEclipse(IProxyData proxyData) {
        String proxyHost;
        if (proxyData != null && (proxyHost = proxyData.getHost()) != null && !proxyHost.isEmpty()) {
            if (proxyData.getType() == "HTTPS") {
                System.setProperty(HTTPS_PROXY_HOST, proxyData.getHost());
                System.setProperty(HTTPS_PROXY_PORT, String.valueOf(proxyData.getPort()));
                String proxyUser = proxyData.getUserId();
                if (proxyUser != null && !proxyUser.isEmpty()) {
                    System.setProperty(HTTPS_PROXY_USER, proxyUser);
                    System.setProperty(HTTPS_PROXY_PASSWORD, proxyData.getPassword());
                }
            } else if (proxyData.getType() == "HTTP") {
                System.setProperty(HTTP_PROXY_HOST, proxyData.getHost());
                System.setProperty(HTTP_PROXY_PORT, String.valueOf(proxyData.getPort()));
                String proxyUser = proxyData.getUserId();
                if (proxyUser != null && !proxyUser.isEmpty()) {
                    System.setProperty(HTTP_PROXY_USER, proxyUser);
                    System.setProperty(HTTP_PROXY_PASSWORD, proxyData.getPassword());
                }
            } else if (proxyData.getType() == "SOCKS") {
                System.setProperty(SOCKS_PROXY_HOST, proxyData.getHost());
                System.setProperty(SOCKS_PROXY_PORT, String.valueOf(proxyData.getPort()));
                String proxyUser = proxyData.getUserId();
                if (proxyUser != null && !proxyUser.isEmpty()) {
                    System.setProperty(SOCKS_PROXY_USER, proxyUser);
                    System.setProperty(SOCKS_PROXY_PASSWORD, proxyData.getPassword());
                }
            }
        }
    }

    public static boolean isNonProxyHost(URI uri) {
        if (uri != null) {
            String[] filters;
            String[] stringArray = filters = NetUtils.getNonProxiedHosts(uri);
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (NetUtils.matchesFilter(uri.getHost(), filter)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isOverriddenNonProxyHost(URI uri) {
        if (uri != null) {
            String[] stringArray = nonProxiedHostsOverride;
            int n = nonProxiedHostsOverride.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (NetUtils.matchesFilter(uri.getHost(), filter)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String[] getNonProxiedHosts(URI uri) {
        String[] excludes;
        String nonProxiedHosts = null;
        if (uri.getScheme().equalsIgnoreCase("http")) {
            nonProxiedHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        } else if (uri.getScheme().equalsIgnoreCase("https")) {
            nonProxiedHosts = System.getProperty(HTTPS_NON_PROXY_HOSTS);
        } else if (uri.getScheme().equalsIgnoreCase("ftp")) {
            nonProxiedHosts = System.getProperty(FTP_NON_PROXY_HOSTS);
        }
        if (nonProxiedHosts == null || nonProxiedHosts.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> excludedHosts = new ArrayList<String>();
        String[] stringArray = excludes = nonProxiedHosts.split("\\|");
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (exclude.equals(LOCAL)) {
                excludedHosts.add(IPV4_LOCALHOST_ADDRESS);
                excludedHosts.add(LOCALHOST_NAME);
            } else {
                excludedHosts.add(exclude);
            }
            ++n2;
        }
        return excludedHosts.toArray(new String[excludedHosts.size()]);
    }

    public static ProxyInfo getProxyInfo(URL url) {
        URI fUri = null;
        if (url != null) {
            try {
                fUri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), url.getPath(), null, null);
            }
            catch (URISyntaxException e) {
                logger.error("failed to create URI from: " + url, (Throwable)e);
            }
        }
        return NetUtils.getProxyInfo(fUri);
    }

    public static ProxyInfo getProxyInfo(String uri) {
        URI fUri = null;
        if (!StringUtils.isEmpty(uri)) {
            try {
                fUri = URI.create(uri);
            }
            catch (Exception e) {
                logger.error("failed to create URI from: " + uri, (Throwable)e);
            }
        }
        return NetUtils.getProxyInfo(fUri);
    }

    public static String[] getNonProxiedHostsOverride() {
        String[] excludes;
        if (omxNonProxiedHosts == null || omxNonProxiedHosts.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> excludedHosts = new ArrayList<String>();
        String[] stringArray = excludes = omxNonProxiedHosts.split("\\|");
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (exclude.equals(LOCAL)) {
                excludedHosts.add(IPV4_LOCALHOST_ADDRESS);
                excludedHosts.add(LOCALHOST_NAME);
            } else {
                excludedHosts.add(exclude);
            }
            ++n2;
        }
        return excludedHosts.toArray(new String[excludedHosts.size()]);
    }

    public static Proxy createProxy(URL url) {
        Proxy proxy = null;
        ProxyInfo proxyInfo = NetUtils.getProxyInfo(url);
        if (proxyInfo != null) {
            String proxyHost = proxyInfo.getProxyHost();
            int proxyPort = proxyInfo.getProxyPort();
            String proxyUser = proxyInfo.getProxyUser();
            if (proxyUser != null && !proxyUser.isEmpty()) {
                String proxyPassword = proxyInfo.getProxyPassword();
                proxy = NetUtils.createProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
            } else {
                proxy = NetUtils.createProxy(proxyHost, proxyPort);
            }
        }
        return proxy;
    }

    public static Proxy createProxy(URI uri) {
        Proxy proxy = null;
        ProxyInfo proxyInfo = NetUtils.getProxyInfo(uri);
        if (proxyInfo != null) {
            String proxyHost = proxyInfo.getProxyHost();
            int proxyPort = proxyInfo.getProxyPort();
            String proxyUser = proxyInfo.getProxyUser();
            if (proxyUser != null && !proxyUser.isEmpty()) {
                String proxyPassword = proxyInfo.getProxyPassword();
                proxy = NetUtils.createProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
            } else {
                proxy = NetUtils.createProxy(proxyHost, proxyPort);
            }
        }
        return proxy;
    }

    protected static void showNetworkProxySettings(URI uri) {
        if (uri == null) {
            return;
        }
        List<Proxy> proxySelectors = ProxySelector.getDefault().select(uri);
        if (proxySelectors != null) {
            for (Proxy proxy : proxySelectors) {
                logger.info(String.format("proxy hostname : %s", new Object[]{proxy.type()}));
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    logger.info("No Proxy");
                    continue;
                }
                logger.info(String.format("proxy hostname : %s", addr.getHostName()));
                logger.info(String.format("proxy port : %d", addr.getPort()));
            }
        }
    }

    public static Proxy createProxy(String proxyHost, int proxyPort) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public static Proxy createProxy(String proxyHost, int proxyPort, final String username, final String password) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return proxy;
    }

    public static HttpURLConnection openHttpConnection(URL url) throws IOException {
        Validate.isNotNull(url);
        if (!url.getProtocol().startsWith("http")) {
            throw new IllegalArgumentException(String.format("URL protocol must be http or https, check failed for Url: %s", url.toExternalForm()));
        }
        Proxy proxy = NetUtils.createProxy(url);
        return (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
    }

    private static boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, true, false);
        return matcher.match(host);
    }

    public static boolean isPermissiveDnsName(String hostname) {
        if (StringUtils.isEmpty(hostname) || hostname.length() > 255) {
            return false;
        }
        Matcher matcher = PERMISSIVE_DOMAIN_NAME_PATTERN.matcher(hostname);
        return matcher.matches();
    }
}

