/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.RegistryOperationException;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegistryOperation {
    private static final Logger log = LoggerFactory.getLogger(LocalRegistryOperation.class);
    public static String HKEY_CLASSES_ROOT = "HKEY_CLASSES_ROOT";
    public static String HKEY_CURRENT_USER = "HKEY_CURRENT_USER";
    public static String HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    public static String HKEY_USERS = "HKEY_USERS";
    public static String HKEY_CURRENT_CONFIG = "HKEY_CURRENT_CONFIG";

    public boolean isKeyPresent(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        try {
            LocalRegistryOperation.checkKeyExists(rootKey, keyPath, keyName);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public String getStringValue(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        LocalRegistryOperation.checkKeyExists(rootKey, keyPath, keyName);
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Registry key is not of type String. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public int getIntValue(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        LocalRegistryOperation.checkKeyExists(rootKey, keyPath, keyName);
        try {
            return Advapi32Util.registryGetIntValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Registry key is not of type Integer. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public long getLongValue(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        LocalRegistryOperation.checkKeyExists(rootKey, keyPath, keyName);
        try {
            return Advapi32Util.registryGetLongValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Registry key is not of type Long. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public byte[] getBinaryValue(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        LocalRegistryOperation.checkKeyExists(rootKey, keyPath, keyName);
        try {
            return Advapi32Util.registryGetBinaryValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Registry key is not of type Binary. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void createPath(String rootKey, String keyPath) throws RegistryOperationException {
        log.info("Create regestry key path: " + LocalRegistryOperation.getDescription(rootKey, keyPath, null));
        int index = keyPath.lastIndexOf("\\");
        if (index < 1) {
            throw new RegistryOperationException("Invalid path '" + keyPath + "'");
        }
        String keyParentPath = keyPath.substring(0, index);
        String keyName = keyPath.substring(index + 1);
        LocalRegistryOperation.checkPathDoesNotExist(rootKey, keyPath);
        try {
            Advapi32Util.registryCreateKey((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyParentPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't create registry key. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void setStringValue(String rootKey, String keyPath, String keyName, String keyValue) throws RegistryOperationException {
        log.info("Set String value '" + keyValue + "' on: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
        try {
            Advapi32Util.registrySetStringValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName, (String)keyValue);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't set registry String value '" + keyValue + "' to: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void setIntValue(String rootKey, String keyPath, String keyName, int keyValue) throws RegistryOperationException {
        log.info("Set Integer value '" + keyValue + "' on: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
        try {
            Advapi32Util.registrySetIntValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName, (int)keyValue);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't set registry Integer value '" + keyValue + "' to: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void setLongValue(String rootKey, String keyPath, String keyName, long keyValue) throws RegistryOperationException {
        log.info("Set Long value '" + keyValue + "' on: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
        try {
            Advapi32Util.registrySetLongValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName, (long)keyValue);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't set registry Long value '" + keyValue + "' to: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void setBinaryValue(String rootKey, String keyPath, String keyName, byte[] keyValue) throws RegistryOperationException {
        log.info("Set Binary value '" + Arrays.toString(keyValue) + "' on: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
        try {
            Advapi32Util.registrySetBinaryValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName, (byte[])keyValue);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't set registry binary value to: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    public void deleteKey(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        log.info("Delete key: " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
        try {
            Advapi32Util.registryDeleteValue((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath, (String)keyName);
        }
        catch (RuntimeException re) {
            throw new RegistryOperationException("Couldn't delete registry key. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), re);
        }
    }

    private static void checkKeyExists(String rootKey, String keyPath, String keyName) throws RegistryOperationException {
        try {
            WinReg.HKEY rootHKey = LocalRegistryOperation.getHKey(rootKey);
            if (!Advapi32Util.registryValueExists((WinReg.HKEY)rootHKey, (String)keyPath, (String)keyName)) {
                throw new RegistryOperationException("Registry key does not exist. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName));
            }
        }
        catch (Win32Exception e) {
            throw new RegistryOperationException("Registry key path does not exist. " + LocalRegistryOperation.getDescription(rootKey, keyPath, keyName), e);
        }
    }

    private static void checkPathDoesNotExist(String rootKey, String keyPath) throws RegistryOperationException {
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)LocalRegistryOperation.getHKey(rootKey), (String)keyPath)) {
            throw new RegistryOperationException("Registry path already exists. " + LocalRegistryOperation.getDescription(rootKey, keyPath, null));
        }
    }

    private static WinReg.HKEY getHKey(String key) throws RegistryOperationException {
        if (key.equalsIgnoreCase(HKEY_CLASSES_ROOT)) {
            return WinReg.HKEY_CLASSES_ROOT;
        }
        if (key.equalsIgnoreCase(HKEY_CURRENT_USER)) {
            return WinReg.HKEY_CURRENT_USER;
        }
        if (key.equalsIgnoreCase(HKEY_LOCAL_MACHINE)) {
            return WinReg.HKEY_LOCAL_MACHINE;
        }
        if (key.equalsIgnoreCase(HKEY_USERS)) {
            return WinReg.HKEY_USERS;
        }
        if (key.equalsIgnoreCase(HKEY_CURRENT_CONFIG)) {
            return WinReg.HKEY_CURRENT_CONFIG;
        }
        throw new RegistryOperationException("Unsupported root key '" + key + "'");
    }

    private static String getDescription(String rootKey, String keyPath, String keyName) {
        return "Root '" + rootKey + "', path '" + keyPath + "'" + (keyName != null ? ", name '" + keyName + "'" : "");
    }
}

