/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesCopier
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(FilesCopier.class);
    private final Path source;
    private final Path target;
    private final CopyOption[] option;

    public FilesCopier(Path source, Path target, CopyOption[] copyOption) {
        this.source = source;
        this.target = target;
        this.option = copyOption;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path arg0, IOException arg1) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes arg1) throws IOException {
        Path targetPath = this.target.resolve(this.source.relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path srcFile, BasicFileAttributes arg1) throws IOException {
        Files.copy(srcFile, this.target.resolve(this.source.relativize(srcFile)), this.option);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path srcFile, IOException e) throws IOException {
        logger.error("Visit file failed: " + srcFile.toString(), (Throwable)e);
        return FileVisitResult.CONTINUE;
    }
}

