/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import java.io.File;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConstants {
    private static final Logger logger = LoggerFactory.getLogger(CommonConstants.class);
    public static final String BOOL_TRUE = Boolean.toString(true);
    public static final String BOOL_FALSE = Boolean.toString(false);
    public static final String TRUE = BOOL_TRUE;
    public static final String FALSE = BOOL_FALSE;
    public static final String PROTOCOL = "platform";
    public static final String FILE_PROTOCOL = "file";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final String PROTOCOL_SEPARATOR = ":";
    public static final Pattern LINE_SEP_PATTERN = Pattern.compile("\\R");
    public static final String UNDEFINED = "_UNDEFINED_";
    public static final String UTCBASE_DATE = "19700101000000";
    public static final long TTL_24_HOURS = 86400000L;
    public static final String EMPTY_STRING = "";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static String FILE_SEPARATOR = "/";
    public static char FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
    public static String ROOT_FOLDER = "/";
    public static final String BLANK_SEPARATOR = " ";
    public static final String STAR = "*";
    public static final String CURRENT_FOLDER_DOT = ".";
    public static final String PARENT_FOLDER_DOT = "..";
    public static final String THREE_DOTS = "...";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SLASH = "/";
    public static final String FORWARD_SLASH = "/";
    public static final String BACK_SLASH = "\\";
    public static final char FORWARD_SLASH_CHAR = '/';
    public static final char BACK_SLASH_CHAR = '\\';
    public static final String DOT_SEPARATOR = ".";
    public static final String COMMA_SEPARATOR = ",";
    public static final String QUESTION_MARK = "?";
    public static final String EQUAL_SIGN = "=";
    public static final String COLON_SEPARATOR = ":";
    public static final String ATSIGN_SEPARATOR = "@";
    public static final String TAB = "\t";
    public static final String AMPERSAND_SEPARATOR = "&";
    public static final String URL_FILE_SCHEME = "file";
    public static final String URL_FILE_MAKEUP = "file://";
    public static final String URL_HTTP_SCHEME = "http";
    public static final String URL_HTTP_PROTOCOL = "http://";
    public static final String URL_HTTPS_SCHEME = "https";
    public static final String URL_HTTPS_PROTOCOL = "https://";
    public static final String PATH_SEPARATOR = File.pathSeparator;
    public static final char PATH_SEPARATOR_CHAR = PATH_SEPARATOR.charAt(0);
    public static final String NOTSET = "*NOTSET";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String LOCALHOST = "localhost";
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String JAVA_NET_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    public static final String JAVA_NET_PREFER_IPV6_ADDRESSES = "java.net.preferIPv6Addresses";
    public static final String JAVA_OS_NAME = "java.os.name";
    private static String os_name = System.getProperty("os.name");
    public static final String OS_NAME = os_name != null ? os_name : "UNKNOWN";
    public static final String JAVA_OS_VERSION = "java.os.version";
    private static String osversion = System.getProperty("os.version");
    public static final String OS_VERSION = osversion != null ? osversion : "UNKNOWN";
    private static String os_username = System.getProperty("user.name");
    public static final String USER_NAME = os_username != null ? os_username : "";
    private static String os_userdir = System.getProperty("user.dir");
    public static final String USER_WORKDIR = os_userdir != null ? os_userdir : ".";
    public static String JAVA_HOME = System.getProperty("java.home");
    private static String env_tempdir = System.getenv("tmp");
    private static String java_tempdir = System.getProperty("java.io.tmpdir");
    public static final String JAVA_TEMPDIR = java_tempdir != null ? java_tempdir : (env_tempdir != null ? env_tempdir : USER_WORKDIR);
    public static String USER_HOME = "/home";
    public static String JAVA_EXTDIRS = System.getProperty("java.ext.dirs");
    public static String JAVA_CLASSPATH = System.getProperty("java.class.path");
    public static final String PREFIX_OS_OS400 = "OS/400";
    public static final String PREFIX_OS_AIX = "AIX";
    public static final String PREFIX_OS_HPUX = "HP_UX";
    public static final String PREFIX_OS_LINUX = "Linux";
    public static final String PREFIX_OS_SOLARIS = "Solaris";
    public static final String PREFIX_OS_WINDOWS = "Windows";
    public static final String PREFIX_OS_MAC = "Mac";
    public static final boolean IS_OS_OS400 = OS_NAME.startsWith("OS/400");
    public static final boolean IS_OS_AIX = OS_NAME.startsWith("AIX");
    public static final boolean IS_OS_HPUX = OS_NAME.startsWith("HP_UX");
    public static final boolean IS_OS_LINUX = OS_NAME.startsWith("Linux");
    public static final boolean IS_OS_SOLARIS = OS_NAME.startsWith("Solaris");
    public static final boolean IS_OS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_OS_MAC = OS_NAME.startsWith("Mac");
    public static final String OS_OS400_SHORTNAME = "os400";
    public static final String OS_AIX_SHORTNAME = "aix";
    public static final String OS_HPUX_SHORTNAME = "hpux";
    public static final String OS_LINUX_SHORTNAME = "linux";
    public static final String OS_SOLARIS_SHORTNAME = "solaris";
    public static final String OS_WINDOWS_SHORTNAME = "windows";
    public static final String OS_MAC_SHORTNAME = "mac";
    public static final String OMX_CONFIG_DIR = "omx.config.dir";
    public static final int DEFAULT_SSHD_PORT = 45022;
    public static final int MIN_USER_PORT_NUMBER = 1025;
    public static final int MAX_PORT_NUMBER = 65535;
    public static String OS_SHORTNAME;

    static {
        String osUserHome = System.getProperty("user.home");
        if (osUserHome != null) {
            USER_HOME = osUserHome.replace(BACK_SLASH, "/");
        }
        OS_SHORTNAME = OS_NAME.split(BLANK_SEPARATOR)[0].replace("/", EMPTY_STRING).replace("_", EMPTY_STRING).toLowerCase();
        if (IS_OS_WINDOWS) {
            FILE_SEPARATOR = BACK_SLASH;
            FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
            ROOT_FOLDER = "c:\\";
        }
    }

    private CommonConstants() {
    }

    public static String getUserHome() {
        return USER_HOME;
    }

    public static void showEnvironment(String message) {
        if (message != null && message.trim().length() != 0) {
            logger.info(message);
        }
        logger.info("os.name = '" + OS_NAME + "'");
        logger.info("os.version = '" + OS_VERSION + "'");
        logger.info("java.home = '" + JAVA_HOME + "'");
        logger.info("java.classpath = '" + JAVA_CLASSPATH + "'");
        logger.info("java.extdirs = '" + JAVA_EXTDIRS + "'");
        logger.info("java.enc.charset = '" + Charset.defaultCharset().name() + "'");
        logger.info("user.name = '" + USER_NAME + "'");
        logger.info("user.workdir = '" + USER_WORKDIR + "'");
        logger.info("user.homedir = '" + USER_HOME + "'");
    }
}

