/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.request;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.unix.request.UnixRequest;
import java.io.IOException;

public class UnixStartServerRequest
extends UnixRequest {
    private String m_pgmPath;
    private String m_pgmParms;
    private String m_envVars;
    private String m_srcPath;
    private String m_pid;
    private int m_multiProc;
    private String m_command;
    private int m_options;
    private String m_user;

    public UnixStartServerRequest(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, int n2, String string8) {
        super(527);
        this.m_pgmPath = string;
        this.m_pgmParms = string2.trim();
        this.m_envVars = string4;
        this.m_srcPath = string5;
        this.m_pid = string6;
        this.m_multiProc = n;
        this.m_command = this.quoteIt(string7);
        this.m_options = n2;
        this.m_user = string8;
        if (string3.length() > 0) {
            this.m_envVars = "LIBPATH=" + string3 + " " + this.m_envVars;
        }
        if (this.m_pgmParms.length() > 0 && this.m_pgmParms.indexOf(39) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(this.m_pgmParms.length() * 2);
            int n3 = this.m_pgmParms.length();
            for (int i = 0; i < n3; ++i) {
                char c = this.m_pgmParms.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            }
            this.m_pgmParms = stringBuffer.toString();
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_pgmPath);
        n += commLink.writeSize(this.m_pgmParms);
        n += commLink.writeSize(this.m_envVars);
        n += commLink.writeSize(this.m_srcPath);
        n += commLink.writeSize(this.m_pid);
        n += 4;
        n += commLink.writeSize(this.m_command);
        n += 4;
        return n += commLink.writeSize(this.m_user);
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_pgmPath);
        commLink.writeString(this.m_pgmParms);
        commLink.writeString(this.m_envVars);
        commLink.writeString(this.m_srcPath);
        commLink.writeString(this.m_pid);
        commLink.writeInt(this.m_multiProc);
        commLink.writeString(this.m_command);
        commLink.writeInt(this.m_options);
        commLink.writeString(Util.upper(this.m_user));
    }

    public void cleanUp() {
        this.m_pgmPath = null;
        this.m_pgmParms = null;
        this.m_envVars = null;
        this.m_srcPath = null;
        this.m_pid = null;
        this.m_command = null;
        this.m_user = null;
    }

    private String quoteIt(String string) {
        if (string.length() > 0 && string.indexOf(39) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

