/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class UnixLoadmapPanel
extends TabPanel
implements PgmListener,
LAFListener,
DebugConstants,
MouseListener,
TreeSelectionListener,
ClipboardOwner {
    public static final String KEY = "loadmap";
    private static final String GIF = "/com/ibm/iseries/debug/dbg016.gif";
    private static final String PGM_GIF = "/com/ibm/iseries/debug/dbg032.gif";
    private static final String PRIVATE_PGM_GIF = "/com/ibm/iseries/debug/dbg077.gif";
    private static final String SHARED_PGM_GIF = "/com/ibm/iseries/debug/dbg076.gif";
    private static final String MODULE_GIF = "/com/ibm/iseries/debug/dbg034.gif";
    private static final int PGM_COUNT = 3;
    private static final int MODULE_COUNT = 4;
    private JTree m_tree;
    private DefaultMutableTreeNode m_root = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode m_mainNode = new DefaultMutableTreeNode(MRI.get("DBG_MAIN"));
    private DefaultMutableTreeNode m_privateNode = new DefaultMutableTreeNode(MRI.get("DBG_PRIVATE"));
    private DefaultMutableTreeNode m_sharedNode = new DefaultMutableTreeNode(MRI.get("DBG_SHARED"));
    private DefaultTreeModel m_treeModel;
    private TreeSelectionModel m_treeSelect;
    private JScrollPane m_scrollPane;
    private ContextMenu m_contextMenu;
    private FileRenderer m_renderer;
    private ArrayList m_descriptors;

    public UnixLoadmapPanel() {
        super(MRI.get("DBG_LOADMAP"), MRI.getIcon(0, GIF));
        this.m_root.add(this.m_mainNode);
        this.m_root.add(this.m_privateNode);
        this.m_root.add(this.m_sharedNode);
        this.m_tree = new JTree();
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        this.m_treeSelect = this.m_tree.getSelectionModel();
        this.m_tree.setRootVisible(false);
        this.m_tree.setModel(this.m_treeModel);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        if (this.m_tree.getRowHeight() < 18) {
            this.m_tree.setRowHeight(18);
        }
        this.m_scrollPane = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        Util.setAccessible((Accessible)this.m_tree, this.m_name);
        Util.setOrientation(this.m_tree);
        Util.setOrientation(this.m_scrollPane);
        this.m_descriptors = new ArrayList();
    }

    private void lookAndFeelModifications() {
        String string = LAFManager.instance().getLookAndFeel();
        if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
            this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("loadMapContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
        this.m_renderer = new FileRenderer();
        this.m_tree.setCellRenderer(this.m_renderer);
    }

    private void clearActionContext() {
        this.m_ctxt.enableAction("gosrc", false);
        this.m_ctxt.enableAction("godsm", false);
        this.m_ctxt.enableAction("rslvsrc", false);
        this.m_ctxt.enableAction("copy", false);
        this.m_ctxt.getActionGroup().clearResolveLoadmapContext();
        this.m_ctxt.getActionGroup().clearAddressContext();
    }

    private void prepareActionContext(TreePath[] treePathArray) {
        if (!this.m_tree.hasFocus()) {
            return;
        }
        if (treePathArray == null || treePathArray.length == 0) {
            this.clearActionContext();
            return;
        }
        this.m_descriptors.clear();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < treePathArray.length; ++i) {
            Comparable comparable;
            TreePath treePath = treePathArray[i];
            if (this.isModulePath(treePath)) {
                if (treePathArray.length != 1) continue;
                comparable = (ModuleDescriptor)this.getUserObject(treePath);
                bl = true;
                this.m_ctxt.getActionGroup().setGotoSrcContext(((ModuleDescriptor)comparable).getViewId(), -1);
                this.m_ctxt.getActionGroup().setAddressContext(((ModuleDescriptor)comparable).getStartAddress().toString());
                continue;
            }
            if (!this.isPgmPath(treePath)) continue;
            comparable = (PgmDescriptor)this.getUserObject(treePath);
            bl2 = true;
            this.m_descriptors.add(comparable);
        }
        if (this.m_descriptors.size() > 0) {
            this.m_ctxt.getActionGroup().setResolveLoadmapContext(this.m_descriptors);
        }
        this.m_ctxt.enableAction("gosrc", bl);
        this.m_ctxt.enableAction("godsm", bl);
        this.m_ctxt.enableAction("rslvsrc", bl2);
        this.m_ctxt.enableAction("copy", true);
    }

    private Object getUserObject(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    private boolean isPgmPath(TreePath treePath) {
        return treePath.getPathCount() == 3;
    }

    private boolean isModulePath(TreePath treePath) {
        return treePath.getPathCount() == 4;
    }

    private DefaultMutableTreeNode searchDescendants(DefaultMutableTreeNode defaultMutableTreeNode, String string, boolean bl) {
        if (bl && defaultMutableTreeNode.toString().toUpperCase().indexOf(string) >= 0) {
            return defaultMutableTreeNode;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.searchDescendants(defaultMutableTreeNode2, string, true);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    private DefaultMutableTreeNode searchChildren(DefaultMutableTreeNode defaultMutableTreeNode, int n, String string) {
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = n; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.toString().toUpperCase().indexOf(string) < 0) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private void ensureVisible(TreePath treePath) {
        Rectangle rectangle = this.m_tree.getVisibleRect();
        Rectangle rectangle2 = this.m_tree.getPathBounds(treePath);
        if (rectangle2.y < rectangle.y || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            rectangle.y = rectangle2.y;
            this.m_tree.scrollRectToVisible(rectangle);
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("pgmmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("pgmmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
        this.m_tree.removeMouseListener(this);
        this.m_tree.removeTreeSelectionListener(this);
        this.m_tree.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane = null;
        this.m_tree = null;
        this.m_root = null;
        this.m_treeSelect = null;
        this.m_contextMenu = null;
        this.m_renderer = null;
        this.m_descriptors = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgloadmap_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext(this.m_tree.getSelectionPaths());
        } else {
            this.clearActionContext();
        }
    }

    public boolean canDoCopy() {
        return this.m_tree.getSelectionPath() != null;
    }

    public void copy() {
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(defaultMutableTreeNode.toString());
            clipboard.setContents(stringSelection, this);
        }
    }

    public boolean canDoFind() {
        return true;
    }

    public boolean find(String string) {
        Serializable serializable;
        TreePath treePath = this.m_tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode = treePath == null ? this.m_root : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        string = string.toUpperCase();
        if (defaultMutableTreeNode.getChildCount() == 0) {
            serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            defaultMutableTreeNode2 = this.searchChildren((DefaultMutableTreeNode)serializable, serializable.getIndex(defaultMutableTreeNode) + 1, string);
        } else {
            defaultMutableTreeNode2 = this.searchDescendants(defaultMutableTreeNode, string, false);
        }
        if (defaultMutableTreeNode2 != null) {
            serializable = new TreePath(defaultMutableTreeNode2.getPath());
            this.m_tree.setSelectionPath((TreePath)serializable);
            this.m_tree.expandPath((TreePath)serializable);
            this.ensureVisible((TreePath)serializable);
            this.m_ctxt.clearMessage();
            return true;
        }
        this.m_tree.clearSelection();
        return false;
    }

    private DefaultMutableTreeNode pgmTypeToNode(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        switch (n) {
            case 10: {
                defaultMutableTreeNode = this.m_mainNode;
                break;
            }
            case 11: {
                defaultMutableTreeNode = this.m_privateNode;
                break;
            }
            case 12: {
                defaultMutableTreeNode = this.m_sharedNode;
            }
        }
        return defaultMutableTreeNode;
    }

    public void programAdded(PgmEvent pgmEvent) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n = pgmEvent.getCount();
        TreePath treePath = null;
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(pgmDescriptor.getPgmType());
            if (defaultMutableTreeNode == null) continue;
            int n2 = pgmManager.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType());
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(pgmDescriptor);
            boolean bl = false;
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n2);
            if (defaultMutableTreeNode.getChildCount() == 1) {
                TreePath treePath2 = new TreePath(defaultMutableTreeNode.getPath());
                this.m_tree.expandPath(treePath2);
            }
            int n3 = pgmDescriptor.getModuleCount();
            for (int j = 0; j < n3; ++j) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(j);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(moduleDescriptor);
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                if (treePath != null || !moduleDescriptor.hasMain() || moduleDescriptor != pgmManager.getMainModule()) continue;
                TreePath treePath3 = new TreePath(defaultMutableTreeNode2.getPath());
                this.m_tree.expandPath(treePath3);
                treePath = new TreePath(defaultMutableTreeNode3.getPath());
            }
        }
        if (treePath != null) {
            this.m_tree.setSelectionPath(treePath);
            this.ensureVisible(treePath);
        }
    }

    public void programUpdated(PgmEvent pgmEvent) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n = pgmEvent.getCount();
        this.m_tree.clearSelection();
        for (int i = 0; i < n; ++i) {
            int n2;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(pgmDescriptor.getPgmType());
            if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() == 0 || (n2 = pgmManager.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType())) < 0) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
            boolean bl = this.m_tree.isExpanded(treePath);
            defaultMutableTreeNode2.removeAllChildren();
            int n3 = pgmDescriptor.getModuleCount();
            for (int j = 0; j < n3; ++j) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(j);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(moduleDescriptor);
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            }
            this.m_treeModel.reload(defaultMutableTreeNode2);
            this.m_tree.addSelectionPath(treePath);
            if (bl) continue;
            this.m_tree.expandPath(treePath);
        }
    }

    public void programRemoved(PgmEvent pgmEvent) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n = pgmEvent.getCount();
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(pgmDescriptor.getPgmType());
            if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() == 0) continue;
            int n2 = pgmManager.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType());
            if ((n2 = n2 * -1 - 1) >= defaultMutableTreeNode.getChildCount()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    public void programsCleared(PgmEvent pgmEvent) {
        this.m_mainNode.removeAllChildren();
        this.m_privateNode.removeAllChildren();
        this.m_sharedNode.removeAllChildren();
        this.m_treeModel.reload();
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (this.m_tree.isPathSelected(treePath)) {
                    this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
                } else {
                    this.m_tree.setSelectionPath(treePath);
                }
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent)) {
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
            }
            if (mouseEvent.getClickCount() == 2 && treePath != null) {
                Runnable runnable = null;
                if (this.isModulePath(treePath)) {
                    runnable = this.m_ctxt.getAction("gosrc");
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private class FileRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_pgmIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg032.gif");
        private ImageIcon m_privatePgmIcon = null;
        private ImageIcon m_sharedPgmIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg076.gif");
        private ImageIcon m_moduleIcon = null;

        public FileRenderer() {
            this.m_privatePgmIcon = MRI.getIcon(0, UnixLoadmapPanel.PRIVATE_PGM_GIF);
            this.m_moduleIcon = MRI.getIcon(0, UnixLoadmapPanel.MODULE_GIF);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setToolTipText(null);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof PgmDescriptor) {
                PgmDescriptor pgmDescriptor = (PgmDescriptor)object2;
                switch (pgmDescriptor.getPgmType()) {
                    case 10: {
                        this.setIcon(this.m_pgmIcon);
                        break;
                    }
                    case 11: {
                        this.setIcon(this.m_privatePgmIcon);
                        break;
                    }
                    case 12: {
                        this.setIcon(this.m_sharedPgmIcon);
                    }
                }
                this.setToolTipText(pgmDescriptor.toAddressBoundsString());
            } else if (object2 instanceof ModuleDescriptor) {
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object2;
                this.setIcon(this.m_moduleIcon);
                this.setToolTipText(moduleDescriptor.toAddressBoundsString());
            } else if (bl3 && object2 instanceof String) {
                String string = (String)object2;
                if (string.equals(MRI.get("DBG_MAIN"))) {
                    this.setIcon(this.m_pgmIcon);
                } else if (string.equals(MRI.get("DBG_PRIVATE"))) {
                    this.setIcon(this.m_privatePgmIcon);
                } else {
                    this.setIcon(this.m_sharedPgmIcon);
                }
            }
            return this;
        }
    }
}

