/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.PickFromTableDialog;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.request.LnBrkRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class UnixResolveMethodPacket
extends UnixPacket
implements DebugConstants {
    private static final int GOTO = 1;
    private static final int BRKPT = 2;
    private static final int GOTO_FROM_VIEWID = 3;
    private int m_action;
    private String m_origMethod;
    private String[] m_methods;
    private BreakpointDescriptor[] m_descriptors;
    private ISeriesMessage m_msgObj;

    public UnixResolveMethodPacket() {
        super(3011);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_origMethod = null;
        this.m_methods = null;
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        int n3 = breakpointGroupManager.getCurrentGroupId();
        this.m_action = commLink.readInt();
        this.m_origMethod = commLink.readString();
        int n4 = commLink.readInt();
        this.m_methods = new String[n4];
        this.m_descriptors = new BreakpointDescriptor[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.m_methods[n2] = commLink.readString();
            this.m_descriptors[n2] = new BreakpointDescriptor();
            this.m_descriptors[n2].read(commLink);
            this.m_descriptors[n2].setGroupId(n3);
        }
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        if (this.m_msgObj == null) {
            switch (this.m_action) {
                case 1: 
                case 3: {
                    this.gotoMethod();
                    break;
                }
                case 2: {
                    this.addMethodBrk();
                }
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }

    private void gotoMethod() {
        if (this.m_descriptors.length > 1) {
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            String string = MRI.get("DBG_GOTO_METHOD");
            String string2 = MRI.get("DBG_SELECT_METHOD_LABEL");
            String[][] stringArray = new String[this.m_descriptors.length + 1][4];
            stringArray[0][0] = MRI.get("DBG_METHOD");
            stringArray[0][1] = MRI.get("DBG_MODULE");
            stringArray[0][2] = MRI.get("DBG_LINE");
            stringArray[0][3] = MRI.get("DBG_PROGRAM");
            for (int i = 0; i < this.m_descriptors.length; ++i) {
                PgmDescriptor pgmDescriptor = pgmManager.getProgram(this.m_descriptors[i].getViewId());
                ModuleDescriptor moduleDescriptor = pgmManager.getModule(this.m_descriptors[i].getViewId());
                stringArray[i + 1][0] = this.m_methods[i];
                stringArray[i + 1][1] = moduleDescriptor.getModuleName();
                stringArray[i + 1][2] = String.valueOf(this.m_descriptors[i].getLineNum());
                stringArray[i + 1][3] = pgmDescriptor.getPgmPath();
            }
            PickFromTableDialog pickFromTableDialog = new PickFromTableDialog(this.m_ctxt.getJFrame(), string, string2, MRI.get("DBG_OK"), null, stringArray, 0);
            pickFromTableDialog.setSingleSelect();
            pickFromTableDialog.display(this.m_ctxt);
            if (!pickFromTableDialog.wasCanceled()) {
                int n = pickFromTableDialog.getSelectedIndex();
                this.gotoSrc(this.m_descriptors[n].getViewId(), this.m_descriptors[n].getLineNum());
            }
        } else if (this.m_descriptors.length > 0) {
            this.gotoSrc(this.m_descriptors[0].getViewId(), this.m_descriptors[0].getLineNum());
        }
    }

    private void gotoSrc(String string, int n) {
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
        DebugSource debugSource = debugDesktop.getSource(string);
        if (debugSource == null) {
            sourceViewManager.requestSourceViewLineNum(string, n);
        } else if (n > 0 && !debugSource.containsLineNum(n)) {
            sourceViewManager.requestSourceViewLineNum(string, n);
        } else {
            debugDesktop.activateSource(debugSource, n);
            debugSource.viewRequestFocus();
        }
    }

    private void addMethodBrk() {
        TabPanel tabPanel = this.m_ctxt.getPanel("breakpoints");
        if (this.m_descriptors.length > 1) {
            Object object;
            Object object2;
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            Object[] objectArray = new Object[]{this.m_origMethod};
            String string = MRI.get("DBG_ADD_METHOD_BRK_DIALOG_TITLE");
            String string2 = MessageFormat.format(MRI.get("DBG_SELECT_METHOD_BRK_FMT"), objectArray);
            String[][] stringArray = new String[this.m_descriptors.length + 1][4];
            stringArray[0][0] = MRI.get("DBG_METHOD");
            stringArray[0][1] = MRI.get("DBG_MODULE");
            stringArray[0][2] = MRI.get("DBG_LINE");
            stringArray[0][3] = MRI.get("DBG_PROGRAM");
            for (int i = 0; i < this.m_descriptors.length; ++i) {
                object2 = pgmManager.getProgram(this.m_descriptors[i].getViewId());
                object = pgmManager.getModule(this.m_descriptors[i].getViewId());
                stringArray[i + 1][0] = this.m_methods[i];
                stringArray[i + 1][1] = ((ModuleDescriptor)object).getModuleName();
                stringArray[i + 1][2] = String.valueOf(this.m_descriptors[i].getLineNum());
                stringArray[i + 1][3] = ((PgmDescriptor)object2).getPgmPath();
            }
            PickFromTableDialog pickFromTableDialog = new PickFromTableDialog(this.m_ctxt.getJFrame(), string, string2, MRI.get("DBG_OK"), null, stringArray, 0);
            pickFromTableDialog.display(this.m_ctxt);
            if (!pickFromTableDialog.wasCanceled()) {
                object2 = pickFromTableDialog.getSelectedIndices();
                object = new ArrayList(((Object)object2).length);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    Object object3 = object2[i];
                    ((ArrayList)object).add(this.m_descriptors[object3]);
                    if (i != 0) continue;
                    this.gotoSrc(this.m_descriptors[object3].getViewId(), this.m_descriptors[object3].getLineNum());
                }
                tabPanel.expose();
                LnBrkRequest lnBrkRequest = new LnBrkRequest(1, (ArrayList)object);
                this.m_ctxt.sendRequest(lnBrkRequest);
                this.m_ctxt.getPgmEnv().setSaved(false);
            }
        } else if (this.m_descriptors.length > 0) {
            tabPanel.expose();
            this.gotoSrc(this.m_descriptors[0].getViewId(), this.m_descriptors[0].getLineNum());
            LnBrkRequest lnBrkRequest = new LnBrkRequest(1, this.m_descriptors[0]);
            this.m_ctxt.sendRequest(lnBrkRequest);
            this.m_ctxt.getPgmEnv().setSaved(false);
        }
    }
}

