/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.Toolbox;
import java.io.IOException;

public abstract class UnixPacket
implements Packet {
    public static final int LIST_PROCESS = 1524;
    public static final int START_DEBUG = 3000;
    public static final int STRING_MODE = 3001;
    public static final int CONTEXT = 3002;
    public static final int REMOTE_ATTACH = 3003;
    public static final int RESET = 3004;
    public static final int DEBUG_OPT = 3005;
    public static final int SOURCE_FILES = 3006;
    public static final int RESOLVE_SOURCE = 3007;
    public static final int UPDATE_PGM = 3008;
    public static final int SYNC_SOURCE = 3009;
    public static final int EXTEND_BRK = 3010;
    public static final int RESOLVE_METHOD = 3011;
    public static final int METHODS = 3012;
    public static final int RESOLVE_LOADMAP = 3013;
    protected DebugContext m_ctxt;
    protected int m_type;

    public UnixPacket(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void cleanUp() {
        this.m_ctxt = null;
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public void setContext(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public ActionGroup getActionGroup() {
        return this.m_ctxt.getActionGroup();
    }

    public void displayMessage(ISeriesMessage iSeriesMessage) {
        String string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
        this.m_ctxt.setMessage(string);
        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, iSeriesMessage);
        iSeriesMessageDialog.display(this.m_ctxt);
    }

    public void displayMessage(ISeriesMessage iSeriesMessage, int n) {
        String string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
        this.m_ctxt.setMessage(string);
        this.m_ctxt.setDebugIcon(n, string);
        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, iSeriesMessage);
        iSeriesMessageDialog.display(this.m_ctxt);
    }

    public abstract void read(CommLink var1, int var2) throws IOException;
}

