/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.manager;

import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.unix.request.UnixResolveMethodRequest;
import com.ibm.iseries.unix.request.UnixResolveSourceRequest;
import java.util.HashMap;

public class UnixSourceViewManager
extends SourceViewManager {
    private HashMap m_filenameToViewId = new HashMap();
    private HashMap m_viewIdToFilename = new HashMap();

    public UnixSourceViewManager(DebugContext debugContext) {
        super(debugContext);
    }

    public void addToFilenameCache(String string, String string2) {
        this.m_filenameToViewId.put(string, string2);
        this.m_viewIdToFilename.put(string2, string);
    }

    public void rmvFromFilenameCache(String string) {
        String string2;
        if (!this.m_filenameToViewId.isEmpty() && (string2 = (String)this.m_filenameToViewId.get(string)) != null) {
            this.m_filenameToViewId.remove(string);
            this.m_viewIdToFilename.remove(string2);
            this.rmvFromLocalFilesCache(string2);
        }
    }

    public void requestSourceViews(String[] stringArray) {
        Object object;
        if (stringArray.length == 1 && (object = (String)this.m_filenameToViewId.get(stringArray[0])) != null) {
            DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
            DebugSource debugSource = debugDesktop.getSource((String)object);
            if (debugSource == null) {
                this.requestSourceView((String)object);
            } else {
                debugDesktop.activateSource(debugSource, -1);
                debugSource.viewRequestFocus();
            }
            return;
        }
        this.m_ctxt.postClock();
        object = new UnixResolveSourceRequest(stringArray);
        this.m_ctxt.sendRequest((Request)object);
    }

    public void requestSourceViewFromMethod(String string) {
        this.m_ctxt.postClock();
        int n = 3;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            n = 1;
            break;
        }
        UnixResolveMethodRequest unixResolveMethodRequest = new UnixResolveMethodRequest(n, string);
        this.m_ctxt.sendRequest(unixResolveMethodRequest);
    }

    public void cleanUp() {
        super.cleanUp();
        this.clear();
        this.m_filenameToViewId = null;
        this.m_viewIdToFilename = null;
    }

    public void clear() {
        super.clear();
        if (this.m_filenameToViewId != null) {
            this.m_filenameToViewId.clear();
        }
        if (this.m_viewIdToFilename != null) {
            this.m_viewIdToFilename.clear();
        }
    }
}

