/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.manager;

import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugFile;
import java.io.IOException;
import java.util.ArrayList;

public class UnixPgmManager
extends PgmManager {
    protected ArrayList m_unixMain;
    protected ArrayList m_unixPrivate;
    protected ArrayList m_unixShared;

    public UnixPgmManager(DebugContext debugContext) {
        super(debugContext);
    }

    public void init() {
        if (this.m_unixMain == null) {
            this.m_unixMain = new ArrayList();
        }
        if (this.m_unixPrivate == null) {
            this.m_unixPrivate = new ArrayList();
        }
        if (this.m_unixShared == null) {
            this.m_unixShared = new ArrayList();
        }
    }

    public void clear() {
        super.clear();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_unixMain = null;
        this.m_unixPrivate = null;
        this.m_unixShared = null;
    }

    protected void clearMaps() {
        super.clearMaps();
        this.m_unixMain.clear();
        this.m_unixPrivate.clear();
        this.m_unixShared.clear();
    }

    public String getCompletePath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (pgmDescriptor != null && moduleDescriptor != null) {
            ViewDescriptor viewDescriptor = (ViewDescriptor)this.m_viewIdToView.get(string);
            string2 = viewDescriptor.isAssembler() ? PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), null) : PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), moduleDescriptor.getModuleName());
        }
        return string2;
    }

    protected boolean ignorePgmType(int n) {
        switch (n) {
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    protected ArrayList pgmTypeToList(int n) {
        switch (n) {
            case 10: {
                return this.m_unixMain;
            }
            case 11: {
                return this.m_unixPrivate;
            }
            case 12: {
                return this.m_unixShared;
            }
        }
        return null;
    }

    public void fireProgramAddedEvent(PgmEvent pgmEvent) {
        int n;
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        boolean bl = this.m_viewIdToPgm.isEmpty();
        boolean bl2 = false;
        String string = null;
        for (n = 0; n < n2; ++n) {
            int n3;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            int n4 = pgmDescriptor.getPgmType();
            if (this.ignorePgmType(n4) || (n3 = this.programSortOrder(pgmDescriptor.getPgmPath(), n4)) >= 0) continue;
            ArrayList arrayList = this.pgmTypeToList(n4);
            arrayList.add(n3 * -1 - 1, pgmDescriptor);
            int n5 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n5; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n6 = moduleDescriptor.getViewCount();
                sourceViewManager.rmvFromFilenameCache(moduleDescriptor.getModuleName());
                for (int j = 0; j < n6; ++j) {
                    ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(j);
                    String string2 = viewDescriptor.getViewId();
                    if (j == 0 && bl && !bl2 && viewDescriptor.hasMain()) {
                        this.m_mainModule = moduleDescriptor;
                        string = string2;
                        bl2 = viewDescriptor.isAssembler() ? i == n5 - 1 : true;
                    }
                    this.m_viewIdToPgm.put(string2, pgmDescriptor);
                    this.m_viewIdToModule.put(string2, moduleDescriptor);
                    this.m_viewIdToView.put(string2, viewDescriptor);
                }
            }
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programAdded(pgmEvent);
        }
        if (bl && bl2) {
            sourceViewManager.autoRequestSourceView(string);
        }
    }

    public void fireProgramUpdatedEvent(PgmEvent pgmEvent) {
        int n;
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        for (n = 0; n < n2; ++n) {
            int n3;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            int n4 = pgmDescriptor.getPgmType();
            if (this.ignorePgmType(n4) || (n3 = this.programSortOrder(pgmDescriptor.getPgmPath(), n4)) < 0) continue;
            ArrayList arrayList = this.pgmTypeToList(n4);
            PgmDescriptor pgmDescriptor2 = (PgmDescriptor)arrayList.get(n3);
            pgmEvent.setDescriptorAt(pgmDescriptor2.merge(pgmDescriptor), n);
            int n5 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n5; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n6 = moduleDescriptor.getViewCount();
                sourceViewManager.rmvFromFilenameCache(moduleDescriptor.getModuleName());
                for (int j = 0; j < n6; ++j) {
                    ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(j);
                    String string = viewDescriptor.getViewId();
                    this.m_viewIdToPgm.put(string, pgmDescriptor2);
                    this.m_viewIdToModule.put(string, moduleDescriptor);
                    this.m_viewIdToView.put(string, viewDescriptor);
                }
            }
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programUpdated(pgmEvent);
        }
    }

    public void fireProgramRemovedEvent(PgmEvent pgmEvent) {
        int n;
        int n2 = pgmEvent.getCount();
        for (n = 0; n < n2; ++n) {
            int n3;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            if (this.ignorePgmType(pgmDescriptor.getPgmType()) || (n3 = this.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType())) < 0) continue;
            DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
            BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
            int n4 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n4; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n5 = moduleDescriptor.getViewCount();
                sourceViewManager.rmvFromFilenameCache(moduleDescriptor.getModuleName());
                for (int j = 0; j < n5; ++j) {
                    String string = moduleDescriptor.getViewId(j);
                    breakpointManager.clearBreakpoints(string);
                    debugDesktop.closeSource(string);
                    this.m_viewIdToPgm.remove(string);
                    this.m_viewIdToModule.remove(string);
                    this.m_viewIdToView.remove(string);
                }
            }
            ArrayList arrayList = this.pgmTypeToList(pgmDescriptor.getPgmType());
            arrayList.remove(n3);
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programRemoved(pgmEvent);
        }
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        return 0;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
    }
}

