/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.action;

import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.unix.dialog.UnixAddressDialog;
import java.text.MessageFormat;

public class UnixGotoAddrAction
extends Action {
    public UnixGotoAddrAction() {
        super("goaddr", MRI.get("DBG_GOTO_ADDRESS_MENU"), 65, 1, false);
    }

    public void run() {
        DebugSource debugSource = this.m_ctxt.getActiveSource();
        if (debugSource != null) {
            String string = debugSource.getViewId();
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            ModuleDescriptor moduleDescriptor = pgmManager.getModule(string);
            Object[] objectArray = new Object[]{moduleDescriptor.getStartAddress(), moduleDescriptor.getEndAddress()};
            String string2 = MessageFormat.format(MRI.get("DBG_ENTER_ADDRESS_LABEL_FMT"), objectArray);
            UnixAddressDialog unixAddressDialog = new UnixAddressDialog(this.m_ctxt, MRI.get("DBG_GOTO_ADDRESS"), string2, moduleDescriptor.getStartAddress(), moduleDescriptor.getEndAddress());
            unixAddressDialog.display(this.m_ctxt);
            if (!unixAddressDialog.wasCanceled()) {
                int n = unixAddressDialog.getAddress().difference(moduleDescriptor.getStartAddress());
                int n2 = n / 4 + 1;
                if (debugSource.isFullSource() || debugSource.containsLineNum(n2)) {
                    debugSource.gotoLine(n2);
                } else {
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewLineNum(string, n2);
                }
            }
        }
    }
}

