/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabbedPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public abstract class TabPanel
implements FocusListener {
    protected DebugContext m_ctxt = null;
    protected TabbedPane m_parent = null;
    protected DebugPanelFrame m_parentFrame = null;
    protected ActionGroup m_actionGroup = null;
    protected Settings m_userCfg = null;
    protected String m_name = "";
    protected ImageIcon m_icon = null;
    protected ImageIcon m_suspendedIcon = null;
    protected boolean m_exposed = false;
    protected boolean m_suspended = false;
    protected boolean m_isLtoR = MRI.isLtoR();

    public TabPanel(String string, ImageIcon imageIcon) {
        this.m_name = string;
        this.m_icon = imageIcon;
        this.m_suspendedIcon = new ImageIcon(GrayFilter.createDisabledImage(this.m_icon.getImage()));
        this.m_icon.setDescription(string);
        this.m_suspendedIcon.setDescription(string);
    }

    public abstract String getHelpId();

    public abstract String getKey();

    public abstract JComponent getComponent();

    public void init(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_actionGroup = this.m_ctxt.getActionGroup();
        this.m_userCfg = this.m_ctxt.getUserConfig();
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        this.m_ctxt = debugContext;
        this.m_parent = tabbedPane;
        this.m_actionGroup = this.m_ctxt.getActionGroup();
        this.m_userCfg = this.m_ctxt.getUserConfig();
        if (this.m_parent != null) {
            this.m_suspended = this.m_userCfg.getBool(this.getKey() + "Suspended", false);
            if (this.m_suspended) {
                this.setSuspended(true);
            }
        }
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public ActionGroup getActionGroup() {
        return this.m_ctxt.getActionGroup();
    }

    public TabbedPane getParent() {
        return this.m_parent;
    }

    public void setParent(TabbedPane tabbedPane) {
        this.m_parent = tabbedPane;
        this.m_parentFrame = null;
    }

    public boolean isInFrame() {
        return this.m_parentFrame != null;
    }

    public DebugPanelFrame getParentFrame() {
        return this.m_parentFrame;
    }

    public void setParentFrame(DebugPanelFrame debugPanelFrame) {
        this.m_parentFrame = debugPanelFrame;
        this.m_parent = null;
        this.m_exposed = true;
    }

    public void requestFocus() {
    }

    public void clear(boolean bl) {
    }

    public void cleanUp() {
        this.m_ctxt = null;
        this.m_parent = null;
        this.m_parentFrame = null;
        this.m_actionGroup = null;
        this.m_userCfg = null;
        this.m_name = null;
        this.m_icon = null;
        this.m_suspendedIcon = null;
    }

    public void saveSettings() {
    }

    public String getTabText() {
        return this.m_name;
    }

    public void setTabText(String string) {
        this.m_name = string;
        if (this.m_parent != null) {
            this.m_parent.setTabText(this, this.m_name);
        }
    }

    public Icon getTabIcon() {
        return this.m_icon;
    }

    public boolean isActivePanel() {
        return this.m_ctxt.getActivePanel() == this;
    }

    public void setActivePanel(boolean bl) {
    }

    public boolean isExposed() {
        return this.m_exposed;
    }

    public void expose() {
        if (this.m_parent != null) {
            this.m_parent.exposePanel(this);
        }
    }

    public void setExposed(boolean bl) {
        this.m_exposed = bl;
        if (!bl) {
            this.setActivePanel(false);
        }
    }

    public boolean isSupported() {
        if (this.m_parent != null) {
            return this.m_parent.isSupported(this);
        }
        return false;
    }

    public void setSupported(boolean bl) {
        if (this.m_parent != null) {
            this.m_parent.setSupported(this, bl);
        }
    }

    public boolean canDoSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.m_suspended;
    }

    public void setSuspended(boolean bl) {
        this.m_suspended = bl;
        this.setSuspendedIcon(this.m_suspended);
        this.m_userCfg.setBool(this.getKey() + "Suspended", this.m_suspended);
    }

    public void setSuspendedIcon(boolean bl) {
        if (this.m_parent != null) {
            if (bl && this.m_suspendedIcon != null) {
                this.m_parent.setTabIcon(this, this.m_suspendedIcon);
            } else {
                this.m_parent.setTabIcon(this, this.m_icon);
            }
        }
    }

    public boolean canDoFind() {
        return false;
    }

    public boolean find(String string) {
        return false;
    }

    public boolean canDoCopy() {
        return false;
    }

    public void copy() {
    }

    public boolean canDoCopyPanel() {
        return false;
    }

    public void copyPanel() {
    }

    public boolean canDoColumns() {
        return false;
    }

    public ArrayList getAvailableColumns() {
        return null;
    }

    public ArrayList getCurrentColumns() {
        return null;
    }

    public void setCurrentColumns(ArrayList arrayList) {
    }

    public boolean canClone() {
        return false;
    }

    public DebugPanelFrame cloneFrame(int n, int n2) {
        return null;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.m_ctxt != null) {
            this.m_ctxt.setActivePanel(this);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected class TabScrollPane
    extends JScrollPane {
        private String m_text;
        private int m_textWidth;

        public TabScrollPane(Component component) {
            super(component);
            this.m_text = null;
            this.m_textWidth = 0;
        }

        public void setText(String string) {
            this.m_text = string;
            if (this.m_text != null) {
                this.m_textWidth = this.getFontMetrics(this.getFont()).stringWidth(this.m_text);
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.m_text != null) {
                int n = (this.getWidth() - this.m_textWidth) / 2;
                int n2 = this.getHeight() / 2;
                graphics.drawString(this.m_text, n, n2);
            }
        }
    }
}

