/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.event.BreakpointGroupEvent;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.listener.BreakpointGroupListener;
import com.ibm.iseries.debug.listener.BreakpointListener;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.source.SourceRowHeader;
import com.ibm.iseries.debug.source.SourceView;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class SourcePane
implements ContextListener,
BreakpointListener,
BreakpointGroupListener {
    private DebugContext m_ctxt;
    private SourceRowHeader m_header;
    private SourceView m_view;
    private ContextMenu m_contextMenu;
    private String m_viewId;
    private JScrollPane m_scrollPane;
    private boolean m_isAssembler;
    private boolean m_followContext;

    public SourcePane(DebugContext debugContext, String string, boolean bl) {
        this.m_ctxt = debugContext;
        this.m_viewId = string;
        this.m_isAssembler = bl;
        this.createComponents();
    }

    public SourcePane(DebugContext debugContext, SourceViewEvent sourceViewEvent) {
        this.m_ctxt = debugContext;
        this.m_viewId = "";
        this.m_isAssembler = sourceViewEvent.isAssemblerSource();
        this.createComponents();
    }

    protected void createComponents() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_header = this.m_isAssembler ? (SourceRowHeader)Util.loadObject(settings.getString("asmRowHeader", "SourceAddrHeader")) : (SourceRowHeader)Util.loadObject(settings.getString("srcRowHeader", "SourceLnNumHeader"));
        this.m_view = (SourceView)Util.loadObject(settings.getString("srcView", "SourceTextArea"));
        this.m_header.init(this.m_ctxt, this.m_view);
        this.m_view.init(this.m_ctxt, this.m_header);
        this.m_scrollPane = new JScrollPane(this.m_view.getComponent());
        this.m_scrollPane.setRowHeaderView(this.m_header.getComponent());
        this.lookAndFeelModifications();
        ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
        this.m_view.setAutoEval(contextManager.isValidContext());
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("brkmgr").addListener(this);
        this.m_ctxt.getManager("brkgrpmgr").addListener(this);
    }

    public void lookAndFeelModifications() {
        Object var1_1 = null;
        this.m_contextMenu = this.m_isAssembler ? (ContextMenu)Util.loadObject(this.m_ctxt.getConfig().getString("asmContextMenu", null)) : (ContextMenu)Util.loadObject(this.m_ctxt.getConfig().getString("srcContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
        this.m_header.lookAndFeelModifications(this.m_contextMenu);
        this.m_view.lookAndFeelModifications(this.m_contextMenu);
        this.m_scrollPane.setBackground(this.m_view.getComponent().getBackground());
    }

    public void settingsChanged(int n) {
        this.m_header.settingsChanged(n);
        this.m_view.settingsChanged(n);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("brkmgr").removeListener(this);
        this.m_ctxt.getManager("brkgrpmgr").removeListener(this);
        this.m_header.cleanUp();
        this.m_view.cleanUp();
        this.m_ctxt = null;
        this.m_header = null;
        this.m_view = null;
        this.m_contextMenu = null;
        this.m_viewId = null;
        this.m_scrollPane = null;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public JComponent getHeaderComponent() {
        return this.m_header.getComponent();
    }

    public JComponent getViewComponent() {
        return this.m_view.getComponent();
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public ContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public void setViewId(String string) {
        this.m_viewId = string;
    }

    public boolean isAssembler() {
        return this.m_isAssembler;
    }

    public void setFollowContext(boolean bl) {
        this.m_followContext = bl;
    }

    public void setAccessibleDescription(String string) {
        this.m_view.setAccessibleDescription(string);
        this.m_header.setAccessibleDescription(string);
    }

    public void setSourceCode(SourceViewEvent sourceViewEvent) {
        this.m_viewId = sourceViewEvent.getViewId();
        this.m_view.setSourceInfo(sourceViewEvent);
        this.m_header.setSourceInfo(sourceViewEvent);
    }

    public void clearSourceCode() {
        this.m_viewId = "";
        this.m_header.clearSourceInfo();
        this.m_view.clearSourceInfo();
    }

    public int getStartLineNum() {
        return this.m_view.getStartLineNum();
    }

    public int getEndLineNum() {
        return this.m_view.getEndLineNum();
    }

    public int getTotalLineCount() {
        return this.m_view.getTotalLineCount();
    }

    public int getCursorLineNum() {
        return this.m_view.getCursorLineNum();
    }

    public void setActiveLineNum(int n) {
        this.m_view.setActiveLineNum(n);
    }

    public void resetActiveLineNum() {
        this.m_view.resetActiveLineNum();
    }

    public boolean isLineNumVisible(int n) {
        return this.m_view.isLineNumVisible(n);
    }

    public void scrollToLineNum(int n) {
        this.m_view.scrollToLineNum(n);
    }

    public void scrollToLineNum(int n, boolean bl) {
        this.m_view.scrollToLineNum(n, bl);
    }

    public String getSelectedText() {
        return this.m_view.getSelectedText();
    }

    public int findText(String string, int n, boolean bl, boolean bl2) {
        return this.m_view.findText(string, n, bl, bl2);
    }

    public int findTextInLine(String string, int n, boolean bl, boolean bl2) {
        return this.m_view.findTextInLine(string, n, bl, bl2);
    }

    public void gotoLine(int n) {
        this.m_view.gotoLine(n);
    }

    public void copy() {
        this.m_view.copy();
    }

    public void displayAutoEvalTooltip(String string) {
        this.m_view.displayAutoEvalTooltip(string);
    }

    public boolean viewHasFocus() {
        return this.m_view.hasFocus();
    }

    public void viewRequestFocus() {
        this.m_view.requestFocus();
    }

    public void viewIgnoreFocus(boolean bl) {
        this.m_view.ignoreFocus(bl);
    }

    public void breakpointGroupChanged(BreakpointGroupEvent breakpointGroupEvent) {
        if (breakpointGroupEvent.getType() == 5) {
            this.m_header.repaint();
        }
    }

    public void breakpointChanged(BreakpointEvent breakpointEvent) {
        int n = breakpointEvent.getCount();
        for (int i = 0; i < n; ++i) {
            if (!this.m_viewId.equals(breakpointEvent.getViewId(i))) continue;
            this.m_header.repaint();
            break;
        }
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 2: {
                int n;
                String string = this.m_isAssembler ? contextEvent.getAsmViewId() : contextEvent.getViewId();
                int n2 = n = this.m_isAssembler ? contextEvent.getAsmLineNum() : contextEvent.getLineNum();
                if (!this.m_isAssembler && !this.m_view.getAutoEval()) {
                    this.m_view.setAutoEval(true);
                }
                if (this.m_viewId.equals(string)) {
                    if (this.m_header.containsLineNum(n)) {
                        this.m_view.scrollToLineNum(n, true);
                        break;
                    }
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewContext(this.m_viewId, n);
                    break;
                }
                if (this.m_followContext) {
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    this.m_viewId = string;
                    sourceViewManager.requestSourceViewContext(this.m_viewId, n);
                    break;
                }
                if (this.m_view.getActiveLineNum() < 0) break;
                this.m_view.resetActiveLineNum();
                break;
            }
            case 3: {
                if (this.m_isAssembler) break;
                this.m_view.setAutoEval(false);
                break;
            }
            case 4: {
                if (this.m_isAssembler) break;
                this.m_view.setAutoEval(false);
                break;
            }
        }
    }
}

