/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.request;

import com.ibm.iseries.debug.request.DebuggerRequest;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SourceViewDecryptRequest
extends DebuggerRequest {
    private byte[] m_decryptionKey;
    private byte[] m_seed;

    public SourceViewDecryptRequest(String string) {
        super(539);
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            this.m_seed = secretKey.getEncoded();
            int n = string.length();
            byte[] byArray = string.getBytes();
            this.m_decryptionKey = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.m_decryptionKey[i] = (byte)(byArray[i] ^ this.m_seed[i]);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("SourceViewDecryptRequest.SourceViewDecryptRequest caught exception: " + noSuchAlgorithmException.toString());
        }
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeBytes(this.m_decryptionKey);
        commLink.writeBytes(this.m_seed);
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_decryptionKey);
        return n += commLink.writeSize(this.m_seed);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_decryptionKey = null;
    }
}

