/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.request;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.request.DebuggerRequest;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;

public class LnBrkRequest
extends DebuggerRequest {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int ENABLE = 3;
    public static final int DISABLE = 4;
    private int m_action;
    private ArrayList m_descriptors;

    public LnBrkRequest(int n, BreakpointDescriptor breakpointDescriptor) {
        super(506);
        this.m_action = n;
        this.m_descriptors = new ArrayList(1);
        this.m_descriptors.add(breakpointDescriptor);
    }

    public LnBrkRequest(int n, ArrayList arrayList) {
        super(506);
        this.m_action = n;
        this.m_descriptors = arrayList != null ? (ArrayList)arrayList.clone() : null;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeInt(this.m_action);
        int n = this.m_descriptors.size();
        commLink.writeInt(n);
        for (int i = 0; i < n; ++i) {
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)this.m_descriptors.get(i);
            breakpointDescriptor.write(commLink);
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 8;
        int n2 = this.m_descriptors.size();
        for (int i = 0; i < n2; ++i) {
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)this.m_descriptors.get(i);
            n += breakpointDescriptor.writeSize(commLink);
        }
        return n;
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_descriptors != null) {
            this.m_descriptors.clear();
            this.m_descriptors = null;
        }
    }
}

