/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.listener.CursorListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.request.CommandRequest;
import com.ibm.iseries.debug.request.CommandRequestSQLEval;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugComboBox;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ConsolePanel
extends TabPanel
implements CursorListener,
LAFListener,
MouseListener,
ActionListener {
    public static final String KEY = "console";
    private static final String GIF = "/com/ibm/iseries/debug/dbg020.gif";
    private static final String CMD = "cmd";
    private static final String GO = "go";
    private static final String PREV = "prev";
    private static final String NEXT = "next";
    private static final int HISTORY_COUNT = 40;
    private ContextManager m_ctxtMgr;
    private VariableManager m_varMgr;
    private MemoryManager m_memMgr;
    private JPanel m_panel = new JPanel(new BorderLayout());
    private JScrollPane m_scrollPane;
    private ConsoleText m_text = new ConsoleText();
    private ConsoleCmd m_cmd;
    private JButton m_go;
    private ContextMenu m_contextMenu;
    private boolean m_cmdIssued;
    private boolean m_hasSelection;

    public ConsolePanel() {
        super(MRI.get("DBG_CONSOLE"), MRI.getIcon(0, GIF));
        this.m_text.addMouseListener(this);
        this.m_scrollPane = new JScrollPane(this.m_text);
        this.m_cmd = new ConsoleCmd();
        this.m_cmd.setRenderer(new DummyRenderer());
        this.m_cmd.setEditable(true);
        this.m_cmd.registerKeyboardAction(this, PREV, KeyStroke.getKeyStroke(120, 0), 2);
        this.m_cmd.registerKeyboardAction(this, NEXT, KeyStroke.getKeyStroke(120, 1), 2);
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_COMMAND_LABEL"));
        this.m_go = new JButton(MRI.get("DBG_GO"));
        this.m_go.setActionCommand(GO);
        this.m_go.addActionListener(this);
        this.m_go.setMargin(new Insets(0, 2, 0, 2));
        this.m_go.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ConsolePanel.this.m_cmd.setCanExecuteCmd(false);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ConsolePanel.this.m_cmd.setCanExecuteCmd(true);
            }
        });
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.m_cmd, "Center");
        jPanel.add((Component)jLabel, this.m_isLtoR ? "West" : "East");
        jPanel.add((Component)this.m_go, this.m_isLtoR ? "East" : "West");
        this.m_panel.add((Component)this.m_scrollPane, "Center");
        this.m_panel.add((Component)jPanel, "South");
        this.m_text.addFocusListener(this);
        this.m_cmd.addFocusListener(this);
        this.m_go.addFocusListener(this);
        Util.setAccessible((Accessible)this.m_panel, this.m_name);
        Util.setAccessible((Accessible)this.m_text, this.m_name);
        Util.setAccessible((Accessible)this.m_cmd, jLabel);
        Util.setOrientation(this.m_cmd);
        Util.setOrientation(this.m_cmd.getEditor().getEditorComponent());
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(jLabel);
        Util.setOrientation(this.m_go);
    }

    private void lookAndFeelModifications() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("consoleContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void clear(boolean bl) {
        this.m_text.clear();
        this.m_hasSelection = false;
    }

    public void logMsg(String string) {
        this.m_text.logMsg(string);
        if (this.m_cmdIssued) {
            this.m_cmdIssued = false;
            this.m_ctxt.clearMessage();
        }
    }

    private void prevCommand() {
        int n = this.m_cmd.getSelectedIndex();
        if (n == this.m_cmd.getItemCount() - 1) {
            this.m_cmd.setSelectedIndex(0);
        } else {
            this.m_cmd.setSelectedIndex(n + 1);
        }
        this.m_cmd.requestFocus();
    }

    private void nextCommand() {
        int n = this.m_cmd.getSelectedIndex();
        if (n == 0) {
            this.m_cmd.setSelectedIndex(this.m_cmd.getItemCount() - 1);
        } else {
            this.m_cmd.setSelectedIndex(n - 1);
        }
        this.m_cmd.requestFocus();
    }

    private void executeCmd(String string) {
        Object object;
        if (string.length() == 0) {
            return;
        }
        String string2 = this.m_ctxt.getDesktop().getActiveViewId();
        int n = 1;
        if (string2.length() == 0) {
            string2 = this.m_ctxtMgr.getContextViewId();
            n = this.m_ctxtMgr.getContextLineNum();
            if (string2.length() == 0) {
                return;
            }
        } else if (string2.equals(this.m_ctxtMgr.getContextViewId())) {
            n = this.m_ctxtMgr.getContextLineNum();
        }
        if (string.length() > 3) {
            object = string.substring(0, 3).toUpperCase();
            if (((String)object).equals("EV ")) {
                string = "EVAL " + string.substring(3);
            } else if (((String)object).equals("BR ")) {
                string = "BREAK " + string.substring(3);
            }
        }
        this.m_ctxt.setMessage(MRI.get("DBG_RUNNING_CMD"));
        object = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        if (this.m_ctxt.isSupported(11, this.m_ctxt.getSystemVersion()) && CommandRequestSQLEval.isSupportedSQLEvalCommand(string) && object != null && ((PgmManager)object).getView(string2).isSQLRoot()) {
            CommandRequestSQLEval commandRequestSQLEval = new CommandRequestSQLEval(this.m_ctxt.getVariableDisplayMask() | Integer.MIN_VALUE, string2, n, string);
            this.m_ctxt.sendRequest(commandRequestSQLEval);
        } else {
            CommandRequest commandRequest = new CommandRequest(string2, n, string);
            this.m_ctxt.sendRequest(commandRequest);
        }
        this.m_cmdIssued = true;
        if (this.m_varMgr != null) {
            this.m_varMgr.fireVariableEvent(new VariableEvent(this, 4));
        }
        if (this.m_memMgr != null) {
            this.m_memMgr.fireMemoryEvent(new MemoryEvent(this, 5));
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_ctxtMgr = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
        this.m_varMgr = (VariableManager)this.m_ctxt.getManager("varmgr");
        this.m_memMgr = (MemoryManager)this.m_ctxt.getManager("memmgr");
        this.m_ctxt.getManager("cursormgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("cursormgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_text.removeFocusListener(this);
        this.m_cmd.removeFocusListener(this);
        this.m_go.removeFocusListener(this);
        this.m_ctxtMgr = null;
        this.m_varMgr = null;
        this.m_memMgr = null;
        this.m_panel = null;
        this.m_scrollPane = null;
        this.m_text = null;
        this.m_cmd = null;
        this.m_go = null;
        this.m_contextMenu = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgcon_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        this.m_ctxt.enableAction("clrcon", bl);
    }

    public boolean canDoCopy() {
        return this.m_hasSelection;
    }

    public void copy() {
        this.m_text.copy();
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        this.m_text.selectAll();
        this.m_text.copy();
    }

    public boolean canDoFind() {
        return this.m_text.getLineCount() > 0;
    }

    public boolean find(String string) {
        return this.m_text.find(string, false, true);
    }

    public void postCursor(int n) {
        switch (n) {
            case 2: {
                this.m_text.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 1: {
                this.m_text.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(GO)) {
            this.executeCmd(this.m_cmd.getItem());
        } else if (string.equals(PREV)) {
            this.prevCommand();
        } else if (string.equals(NEXT)) {
            this.nextCommand();
        }
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            int n = this.m_text.viewToModel(mouseEvent.getPoint());
            if (n >= 0) {
                this.m_text.setCaretPosition(n);
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        if (!this.m_text.getCaret().isVisible()) {
            this.m_text.getCaret().setVisible(true);
        }
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_hasSelection = this.m_text.hasSelection();
        this.m_ctxt.getActionGroup().enableSelectionActions(this.m_hasSelection);
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }

    public class ConsoleText
    extends JTextArea {
        private int m_fontHeight = 0;

        public ConsoleText() {
            this.setEditable(false);
            this.m_fontHeight = this.getFontMetrics(this.getFont()).getHeight();
            this.setNextFocusableComponent(ConsolePanel.this.m_cmd);
        }

        public void clear() {
            this.setText("");
        }

        public void logMsg(String string) {
            if (string.endsWith("\n")) {
                this.append(string);
            } else {
                this.append(string + "\n");
            }
            this.setCaretPosition(this.getDocument().getLength());
        }

        public boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        public boolean find(String string, boolean bl, boolean bl2) {
            int n = -1;
            if (string != null && string.length() > 0) {
                String string2;
                if (!bl) {
                    string2 = this.getText().toUpperCase();
                    string = string.toUpperCase();
                } else {
                    string2 = this.getText();
                }
                int n2 = this.getCaretPosition();
                n = string2.indexOf(string, this.getCaretPosition());
                if (n < 0 && bl2 && n2 > 0) {
                    n = string2.indexOf(string, 0);
                }
                if (n >= 0) {
                    this.requestFocus();
                    this.select(n, n + string.length());
                } else {
                    this.setCaretPosition(0);
                }
            }
            return n >= 0;
        }

        public boolean isManagingFocus() {
            return false;
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(SettingsManager.getFixedPitchFont());
        }
    }

    public class ConsoleCmd
    extends DebugComboBox {
        private volatile boolean canExecuteCmd;

        public ConsoleCmd() {
            super(40);
            this.canExecuteCmd = true;
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(SettingsManager.getFixedPitchFont());
        }

        protected void itemSelected(String string) {
            if (this.canExecuteCmd) {
                ConsolePanel.this.executeCmd(string);
            }
        }

        public void setCanExecuteCmd(boolean bl) {
            this.canExecuteCmd = bl;
        }
    }
}

