/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.CallStackDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.request.CallStackRequest;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CallStackPanel
extends TabPanel
implements ContextListener,
LAFListener,
MouseListener,
ListSelectionListener,
ClipboardOwner {
    public static final String KEY = "callStack";
    protected static final String GIF = "/com/ibm/iseries/debug/dbg021.gif";
    protected static final int COL_COUNT = 6;
    protected static final int METHOD_COL = 0;
    protected static final int MODULE_COL = 1;
    protected static final int LINE_NUM_COL = 2;
    protected static final int STMT_NUM_COL = 3;
    protected static final int PGM_NAME_COL = 4;
    protected static final int PGM_LIB_COL = 5;
    protected TabPanel.TabScrollPane m_scrollPane;
    protected Tbl m_table;
    protected TblModel m_tableModel = new TblModel();
    protected ContextMenu m_contextMenu;
    protected boolean m_notCurrent;
    protected String m_viewId = "";
    protected CallStackDescriptor[] m_stack;
    protected int m_currentColumnCount;
    protected int[] m_currentColumns;
    protected HashMap m_columnNameToId;
    static /* synthetic */ Class class$java$lang$String;

    public CallStackPanel() {
        super(MRI.get("DBG_CALL_STACK"), MRI.getIcon(0, GIF));
        this.m_table = new Tbl(this.m_tableModel);
        this.m_scrollPane = new TabPanel.TabScrollPane(this, this.m_table);
        this.m_table.setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        if (this.m_table.getRowHeight() < 18) {
            this.m_table.setRowHeight(18);
        }
        this.m_table.addFocusListener(this);
        this.m_table.addMouseListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        this.m_scrollPane.getViewport().addMouseListener(this);
        this.m_columnNameToId = new HashMap();
        for (int i = 0; i < 6; ++i) {
            this.m_columnNameToId.put(this.getColumnNameFromId(i), new Integer(i));
        }
        Util.setAccessible((Accessible)this.m_table, this.m_name);
        Util.setOrientation(this.m_scrollPane);
    }

    protected void lookAndFeelModifications() {
        this.m_scrollPane.getViewport().setBackground(this.m_table.getBackground());
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("callStackContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void clear(boolean bl) {
        this.m_stack = null;
        this.m_notCurrent = false;
        this.m_tableModel.fireTableDataChanged();
        this.clearActionContext();
    }

    protected void clearActionContext() {
        this.m_ctxt.getActionGroup().clearGotoSrcContext();
        this.m_ctxt.getActionGroup().clearAddPgmContext();
        this.m_ctxt.enableAction("gosrc", false);
        this.m_ctxt.enableAction("addpgm", false);
        this.m_ctxt.enableAction("copy", false);
    }

    protected void prepareActionContext() {
        if (!this.m_table.hasFocus()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        this.m_ctxt.getActionGroup().clearGotoSrcContext();
        this.m_ctxt.getActionGroup().clearAddPgmContext();
        if (this.m_stack != null && this.m_table.getSelectedRowCount() > 0 && (n = this.m_table.getSelectedRow()) >= 0) {
            CallStackDescriptor callStackDescriptor = this.m_stack[n];
            if (callStackDescriptor.getViewId().length() > 0 && callStackDescriptor.getLineNum() > 0) {
                this.m_ctxt.getActionGroup().setGotoSrcContext(callStackDescriptor.getViewId(), callStackDescriptor.getLineNum(), callStackDescriptor.getStatement());
                bl = true;
            } else {
                this.m_ctxt.getActionGroup().setAddPgmContext(callStackDescriptor.getPgmLibrary(), callStackDescriptor.getPgmName(), callStackDescriptor.getPgmType());
                bl2 = true;
            }
        }
        this.m_ctxt.enableAction("gosrc", bl);
        this.m_ctxt.enableAction("addpgm", bl2);
        this.m_ctxt.enableAction("copy", n >= 0);
    }

    protected void requestCallStack() {
        CallStackRequest callStackRequest = new CallStackRequest();
        this.m_ctxt.sendRequest(callStackRequest);
    }

    public void setCallStack(CallStackDescriptor[] callStackDescriptorArray) {
        this.m_stack = callStackDescriptorArray;
        this.m_tableModel.fireTableDataChanged();
        if (this.m_stack.length > 0) {
            for (int i = 0; i < this.m_stack.length; ++i) {
                if (!this.m_stack[i].getViewId().equals(this.m_viewId)) continue;
                this.m_table.setRowSelectionInterval(i, i);
                break;
            }
        }
        this.m_notCurrent = false;
    }

    protected int maxColCount() {
        return 6;
    }

    protected boolean isValidColId(int n) {
        return true;
    }

    protected int mapColIndex(int n) {
        if (!this.m_isLtoR) {
            n = this.m_currentColumnCount - n - 1;
        }
        return n;
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.restoreSettings();
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_table.removeFocusListener(this);
        this.m_table.removeMouseListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane.getViewport().removeMouseListener(this);
        this.m_scrollPane = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_contextMenu = null;
        this.m_viewId = null;
        this.m_stack = null;
        this.m_columnNameToId = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgcallstk_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public boolean canDoCopy() {
        return this.m_table.getSelectedRowCount() > 0;
    }

    public void copy() {
        int n = this.m_table.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= 0 && n2 >= 0) {
            String string = (String)this.m_tableModel.getValueAt(n, n2);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
        }
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        Object object;
        String[][] stringArray;
        StringBuffer stringBuffer = new StringBuffer(500);
        if (this.m_stack != null || this.m_stack.length > 0) {
            int n;
            int n2;
            stringArray = new String[this.m_stack.length + 1][this.m_currentColumnCount];
            object = new int[this.m_currentColumnCount];
            for (n2 = 0; n2 < this.m_currentColumnCount; ++n2) {
                stringArray[0][n2] = this.m_tableModel.getColumnName(n2);
                object[n2] = stringArray[0][n2].length();
            }
            for (n2 = 0; n2 < this.m_stack.length; ++n2) {
                for (n = 0; n < this.m_currentColumnCount; ++n) {
                    String string;
                    stringArray[n2 + 1][n] = string = (String)this.m_tableModel.getValueAt(n2, n);
                    if (string.length() <= object[n]) continue;
                    object[n] = string.length();
                }
            }
            String string = "                                                         ";
            for (n = 0; n < this.m_stack.length + 1; ++n) {
                for (int i = 0; i < this.m_currentColumnCount; ++i) {
                    reference var7_9 = object[i] - stringArray[n][i].length() + 3;
                    while (var7_9 > string.length()) {
                        string = string + string;
                    }
                    stringBuffer.append(stringArray[n][i]);
                    stringBuffer.append(string.substring(0, (int)var7_9));
                }
                stringBuffer.append('\n');
            }
        }
        stringArray = Toolkit.getDefaultToolkit().getSystemClipboard();
        object = new StringSelection(stringBuffer.toString());
        stringArray.setContents((Transferable)object, this);
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext();
        } else {
            this.clearActionContext();
        }
    }

    public void setExposed(boolean bl) {
        super.setExposed(bl);
        if (bl && this.m_notCurrent && !this.isSuspended()) {
            this.requestCallStack();
        }
        if (!bl) {
            this.m_ctxt.enableAction("addpgm", true);
        }
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        if (bl) {
            this.clear(true);
        } else {
            this.requestCallStack();
        }
        this.m_scrollPane.setText(bl ? MRI.get("DBG_SUSPENDED") : null);
    }

    public boolean canDoColumns() {
        return true;
    }

    public ArrayList getAvailableColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_currentColumnCount < this.maxColCount()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.isValidColId(i)) continue;
                boolean bl = false;
                for (int j = 0; j < this.m_currentColumnCount; ++j) {
                    if (this.m_currentColumns[j] != i) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(this.getColumnNameFromId(i));
            }
        }
        return arrayList;
    }

    public ArrayList getCurrentColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_currentColumnCount; ++i) {
            int n = this.mapColIndex(i);
            arrayList.add(this.getColumnNameFromId(this.m_currentColumns[n]));
        }
        return arrayList;
    }

    public void setCurrentColumns(ArrayList arrayList) {
        this.m_currentColumnCount = arrayList.size();
        this.m_currentColumns = new int[this.m_currentColumnCount];
        for (int i = 0; i < this.m_currentColumnCount; ++i) {
            String string = (String)arrayList.get(i);
            Integer n = (Integer)this.m_columnNameToId.get(string);
            int n2 = this.mapColIndex(i);
            this.m_currentColumns[n2] = n;
        }
        this.m_tableModel.fireTableStructureChanged();
    }

    public void saveSettings() {
        int n;
        String string = this.getKey();
        if (this.m_currentColumnCount != this.maxColCount()) {
            for (n = this.m_currentColumnCount; n < 6; ++n) {
                this.m_userCfg.remove(string + "Col" + n);
                this.m_userCfg.remove(string + "Col" + n + "Width");
            }
        }
        this.m_userCfg.setInt(string + "Cols", this.m_currentColumnCount);
        for (n = 0; n < this.m_currentColumnCount; ++n) {
            int n2 = this.mapColIndex(n);
            this.m_userCfg.setInt(string + "Col" + n, this.m_currentColumns[n2]);
            this.m_userCfg.setInt(string + "Col" + n + "Width", this.m_table.getColumnModel().getColumn(n2).getWidth());
        }
    }

    public void restoreSettings() {
        int n;
        int n2;
        String string = this.getKey();
        this.m_currentColumnCount = this.m_userCfg.getInt(string + "Cols", 0);
        if (this.m_currentColumnCount <= 0) {
            this.initDefaultColumns();
            return;
        }
        this.m_currentColumns = new int[this.m_currentColumnCount];
        for (n2 = 0; n2 < this.m_currentColumnCount; ++n2) {
            n = this.mapColIndex(n2);
            this.m_currentColumns[n] = this.m_userCfg.getInt(string + "Col" + n2, -1);
            if (this.m_currentColumns[n] >= 0) continue;
            this.initDefaultColumns();
            return;
        }
        this.m_tableModel.fireTableStructureChanged();
        for (n2 = 0; n2 < this.m_currentColumnCount; ++n2) {
            n = this.mapColIndex(n2);
            int n3 = this.m_userCfg.getInt(string + "Col" + n2 + "Width", -1);
            if (n3 < 0) continue;
            this.m_table.getColumnModel().getColumn(n).setPreferredWidth(n3);
        }
    }

    protected void initDefaultColumns() {
        this.m_currentColumnCount = this.maxColCount();
        this.m_currentColumns = new int[this.m_currentColumnCount];
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.isValidColId(i)) continue;
            this.m_currentColumns[this.mapColIndex((int)n)] = i;
            ++n;
        }
        this.m_tableModel.fireTableStructureChanged();
    }

    protected String getColumnNameFromId(int n) {
        switch (n) {
            case 0: {
                return MRI.get("DBG_METHOD");
            }
            case 1: {
                return MRI.get("DBG_MODULE");
            }
            case 2: {
                return MRI.get("DBG_LINE");
            }
            case 3: {
                return MRI.get("DBG_STATEMENT");
            }
            case 4: {
                return MRI.get("DBG_PROGRAM");
            }
            case 5: {
                return MRI.get("DBG_LIBRARY");
            }
        }
        return "";
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 1: {
                this.m_viewId = contextEvent.getViewId();
                if (this.m_viewId.length() == 0) {
                    this.m_viewId = contextEvent.getAsmViewId();
                }
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestCallStack();
                    break;
                }
                this.m_notCurrent = true;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                this.clear(true);
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                if (this.m_table.isRowSelected(n)) {
                    this.prepareActionContext();
                } else {
                    this.m_table.setRowSelectionInterval(n, n);
                }
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.prepareActionContext();
            Action action = this.m_ctxt.getAction("gosrc");
            if (action != null && action.isEnabled()) {
                this.m_ctxt.clearMessage();
                int n = this.m_table.getSelectedRow();
                CallStackDescriptor callStackDescriptor = this.m_stack[n];
                String string = callStackDescriptor.getPgmLibrary();
                String string2 = callStackDescriptor.getPgmName();
                String string3 = callStackDescriptor.getModuleName();
                String string4 = callStackDescriptor.getProcedure();
                for (int i = n - 1; i >= 0; --i) {
                    CallStackDescriptor callStackDescriptor2 = this.m_stack[i];
                    if (!string4.equals(callStackDescriptor2.getProcedure()) || !string3.equals(callStackDescriptor2.getModuleName()) || !string2.equals(callStackDescriptor2.getPgmName()) || !string.equals(callStackDescriptor2.getPgmLibrary())) continue;
                    Util.warnMessage(this.m_ctxt.getJFrame(), MRI.get("DBG2_STACK_RECURSE_TITLE"), MRI.get("DBG2_STACK_RECURSE_WARN"));
                    i = -1;
                }
                action.run();
            } else {
                this.m_ctxt.setMessage(MRI.get("DBG_CALL_STACK_NOT_UNDER_DEBUG"));
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.prepareActionContext();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected class TblModel
    extends AbstractTableModel {
        protected TblModel() {
        }

        public int getColumnCount() {
            return CallStackPanel.this.m_currentColumnCount;
        }

        public int getRowCount() {
            return CallStackPanel.this.m_stack != null ? CallStackPanel.this.m_stack.length : 0;
        }

        public String getColumnName(int n) {
            return CallStackPanel.this.getColumnNameFromId(CallStackPanel.this.m_currentColumns[n]);
        }

        public Object getValueAt(int n, int n2) {
            switch (CallStackPanel.this.m_currentColumns[n2]) {
                case 0: {
                    return CallStackPanel.this.m_stack[n].getProcedure();
                }
                case 1: {
                    return CallStackPanel.this.m_stack[n].getModuleName();
                }
                case 2: {
                    String string = CallStackPanel.this.m_stack[n].getAddress();
                    if (string != null) {
                        return string;
                    }
                    return CallStackPanel.this.m_stack[n].getLineNum() > 0 ? String.valueOf(CallStackPanel.this.m_stack[n].getLineNum()) : "";
                }
                case 3: {
                    return String.valueOf(CallStackPanel.this.m_stack[n].getStatement());
                }
                case 4: {
                    return CallStackPanel.this.m_stack[n].getPgmName();
                }
                case 5: {
                    return CallStackPanel.this.m_stack[n].getPgmLibrary();
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = CallStackPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class Tbl
    extends JTable {
        public Tbl(TblModel tblModel) {
            super(tblModel);
        }

        public boolean isFocusTraversable() {
            return this.getRowCount() > 0;
        }
    }
}

