/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.action.FindAction;
import com.ibm.iseries.debug.dialog.ProgressDialog;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.OperationCancelRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class OperationProgressPacket
extends DebuggerPacket {
    private static final int RESOLVING_LOADMAP_MANUAL = 1;
    private static final int RESOLVING_LOADMAP_AUTO = 2;
    private static final int PERFORMING_FIND = 3;
    private static final int RESOLVING_METHOD_MANUAL = 4;
    private static final int RESOLVING_METHOD_AUTO = 5;
    private int m_operation;
    private int m_percentDone;

    public OperationProgressPacket() {
        super(1530);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_operation = commLink.readInt();
        this.m_percentDone = commLink.readInt();
    }

    public void run() {
        Dialog dialog = this.m_ctxt.getActiveDialog();
        if (dialog == null) {
            if (this.m_percentDone == 0) {
                Object object;
                String string = MRI.get("DBG_ATTENTION");
                String string2 = "";
                String string3 = null;
                switch (this.m_operation) {
                    case 2: {
                        string2 = MRI.get("DBG_RESOLVING_LOADMAP_LABEL");
                        string3 = MRI.get("DBG_DISABLE_LOADMAP_SUGGESTION");
                        break;
                    }
                    case 1: {
                        string2 = MRI.get("DBG_RESOLVING_LOADMAP_LABEL");
                        break;
                    }
                    case 5: {
                        string2 = MRI.get("DBG_RESOLVING_METHOD_LABEL");
                        string3 = MRI.get("DBG_DISABLE_METHOD_SUGGESTION");
                        break;
                    }
                    case 4: {
                        string2 = MRI.get("DBG_RESOLVING_METHOD_LABEL");
                        break;
                    }
                    case 3: {
                        object = (FindAction)this.m_ctxt.getAction("find");
                        Object[] objectArray = new Object[]{((FindAction)object).getLastFindText(), Util.firstUpper(this.m_ctxt.getSystem())};
                        string2 = MessageFormat.format(MRI.get("DBG_SEARCHING_FMT"), objectArray);
                    }
                }
                dialog = new ProgressDialog(this.m_ctxt.getJFrame(), string, string2, string3);
                dialog.display(this.m_ctxt);
                if (dialog.wasCanceled()) {
                    object = new OperationCancelRequest(this.m_operation);
                    this.m_ctxt.sendRequest((Request)object);
                    if (this.m_operation == 1 || this.m_operation == 4 || this.m_operation == 3) {
                        this.m_ctxt.retractClock();
                        this.m_ctxt.clearMessage();
                    }
                }
            }
        } else if (dialog instanceof ProgressDialog) {
            ProgressDialog progressDialog = (ProgressDialog)dialog;
            progressDialog.update(this.m_percentDone);
        }
        this.cleanUp();
    }
}

