/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.MonitorsPanel;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.TabPanel;
import java.io.IOException;
import java.util.ArrayList;

public class MonitorsPacket
extends DebuggerPacket
implements DebugConstants {
    public static final int CREATE = 0;
    public static final int UPDATE = 1;
    private int m_action;
    private int m_varMask;
    private ArrayList m_descriptors;
    private ISeriesMessage m_msgObj;

    public MonitorsPacket() {
        super(1511);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        this.m_action = commLink.readInt();
        this.m_varMask = commLink.readInt();
        int n3 = commLink.readInt();
        this.m_descriptors = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            VariableDescriptor variableDescriptor = new VariableDescriptor();
            variableDescriptor.read(commLink);
            this.m_descriptors.add(variableDescriptor);
        }
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj);
            if (this.m_action == 0 && this.m_descriptors.size() > 0) {
                VariableDescriptor variableDescriptor = (VariableDescriptor)this.m_descriptors.get(0);
                this.m_ctxt.getActionGroup().setSelectionContext(variableDescriptor.getViewId(), variableDescriptor.getLineNum(), variableDescriptor.getEvalName(), 0);
                this.m_ctxt.getAction("newmon").run();
            }
        } else {
            Object object;
            VariableEvent variableEvent = null;
            switch (this.m_action) {
                case 0: {
                    if (this.m_descriptors.size() <= 0) break;
                    variableEvent = new VariableEvent(this, 3, 2, this.m_descriptors, 0);
                    object = (MonitorsPanel)this.m_ctxt.getPanel("monitors");
                    ((TabPanel)object).expose();
                    break;
                }
                case 1: {
                    variableEvent = new VariableEvent(this, 0, 2, this.m_descriptors, 0);
                }
            }
            object = (VariableManager)this.m_ctxt.getManager("varmgr");
            ((VariableManager)object).fireVariableEvent(variableEvent);
        }
        this.cleanUp();
    }
}

