/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;

public class ClearPgmPacket
extends DebuggerPacket {
    private PgmDescriptor m_pgm;

    public ClearPgmPacket() {
        super(1519);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_pgm = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_pgm = new PgmDescriptor();
        this.m_pgm.read(commLink);
    }

    public void run() {
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        ArrayList arrayList = new ArrayList();
        int n = this.m_pgm.getModuleCount();
        for (int i = 0; i < n; ++i) {
            ModuleDescriptor moduleDescriptor = this.m_pgm.getModuleAt(i);
            int n2 = moduleDescriptor.getViewCount();
            for (int j = 0; j < n2; ++j) {
                String string = moduleDescriptor.getViewId(j);
                if (!breakpointManager.hasBreakpoints(string)) continue;
                Breakpoints breakpoints = breakpointManager.getBreakpoints(string);
                breakpoints.getDescriptors(arrayList);
            }
        }
        if (arrayList.size() > 0) {
            BreakpointEvent breakpointEvent = new BreakpointEvent((Object)this, 2, arrayList);
            breakpointManager.fireBreakpointEvent(breakpointEvent);
            breakpointEvent.cleanUp();
        }
        this.cleanUp();
    }
}

