/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class LookAndFeelMenu
extends SubMenu
implements LAFListener,
ItemListener {
    private UIManager.LookAndFeelInfo[] m_laf = null;
    private JRadioButtonMenuItem[] m_buttons = null;
    private boolean m_ignore = false;

    public LookAndFeelMenu() {
        super(MRI.get("DBG_LOOK_AND_FEEL_MENU"));
        this.init();
    }

    private void init() {
        this.m_laf = UIManager.getInstalledLookAndFeels();
        this.m_buttons = new JRadioButtonMenuItem[this.m_laf.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = UIManager.getLookAndFeel().getName();
        for (int i = 0; i < this.m_laf.length; ++i) {
            String string2 = this.m_laf[i].getName();
            String string3 = this.m_laf[i].getClassName();
            if (string3.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && !System.getProperty("os.name").startsWith("Windows")) continue;
            this.m_buttons[i] = new JRadioButtonMenuItem(string2);
            this.m_buttons[i].setMnemonic(string2.charAt(0));
            if (string.equals(string2)) {
                this.m_buttons[i].setSelected(true);
            }
            buttonGroup.add(this.m_buttons[i]);
            this.add(this.m_buttons[i]);
            this.m_buttons[i].addItemListener(this);
            Util.setAccessible((Accessible)this.m_buttons[i], string2);
            Util.setOrientation(this.m_buttons[i]);
        }
        LAFManager.instance().addListener(this);
    }

    public void cleanUp() {
        LAFManager.instance().removeListener(this);
        this.m_laf = null;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        if (this.m_ignore) {
            return;
        }
        String string = lAFEvent.getLookAndFeel();
        for (int i = 0; i < this.m_laf.length; ++i) {
            if (!string.equals(this.m_laf[i].getClassName())) continue;
            this.m_ignore = true;
            this.m_buttons[i].setSelected(true);
            this.m_ignore = false;
            break;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_ignore) {
            return;
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
        if (jRadioButtonMenuItem.isSelected()) {
            for (int i = 0; i < this.m_laf.length; ++i) {
                if (!jRadioButtonMenuItem.getText().equals(this.m_laf[i].getName())) continue;
                this.m_ignore = true;
                if (!LAFManager.instance().setLookAndFeel(this.m_laf[i].getClassName(), true)) {
                    jRadioButtonMenuItem.setEnabled(false);
                }
                this.m_ignore = false;
                break;
            }
        }
    }
}

