/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.event.RegisterEvent;
import com.ibm.iseries.debug.listener.RegisterListener;
import com.ibm.iseries.debug.register.RegisterDefinition;
import com.ibm.iseries.debug.register.RegisterDescriptor;
import com.ibm.iseries.debug.register.RegisterSet;
import com.ibm.iseries.debug.request.RegisterWriteRequest;
import com.ibm.iseries.debug.request.RegistersRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Manager;

public class RegisterManager
extends Manager {
    public static final String KEY = "regmgr";
    protected DebugContext m_ctxt;
    protected RegisterSet m_regSet;
    protected boolean m_refreshPending;

    public RegisterManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public void clear() {
        super.clear();
        this.m_refreshPending = false;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        if (this.m_regSet != null) {
            this.m_regSet.cleanUp();
            this.m_regSet = null;
        }
    }

    public String getKey() {
        return KEY;
    }

    public RegisterSet getRegisterSet() {
        return this.m_regSet;
    }

    public void setRegisterSet(RegisterSet registerSet) {
        RegisterEvent registerEvent;
        if (this.m_regSet != null) {
            registerEvent = new RegisterEvent(this, 2, this.m_regSet);
            this.fireRegisterEvent(registerEvent);
        }
        if (registerSet != null) {
            this.m_regSet = registerSet;
            registerEvent = new RegisterEvent(this, 1, this.m_regSet);
            this.fireRegisterEvent(registerEvent);
        }
        this.requestRegisters();
    }

    public String getRegisterName(int n) {
        if (this.m_regSet != null) {
            return this.m_regSet.getRegisterName(n);
        }
        return "";
    }

    public RegisterDefinition getDefinition(int n) {
        if (this.m_regSet != null) {
            return this.m_regSet.getDefinition(n);
        }
        return null;
    }

    public RegisterDefinition getDefinition(String string) {
        if (this.m_regSet != null) {
            return this.m_regSet.getDefinition(string);
        }
        return null;
    }

    public RegisterDescriptor getDescriptor(int n) {
        if (this.m_regSet != null) {
            return this.m_regSet.getDescriptor(n);
        }
        return null;
    }

    public void setDescriptor(RegisterDescriptor registerDescriptor) {
        if (this.m_regSet != null) {
            this.m_regSet.setDescriptor(registerDescriptor);
        }
    }

    public void requestRegisters() {
        if (!this.m_refreshPending) {
            this.m_refreshPending = true;
            RegistersRequest registersRequest = new RegistersRequest();
            this.m_ctxt.sendRequest(registersRequest);
        }
    }

    protected boolean isRefreshPending() {
        return this.m_refreshPending;
    }

    protected void setRefreshPending(boolean bl) {
        this.m_refreshPending = bl;
    }

    public void requestRegisterWrite(RegisterDescriptor registerDescriptor) {
        RegisterDefinition registerDefinition = this.m_regSet.getDefinition(registerDescriptor.getId());
        if (registerDefinition.isChildRegister()) {
            this.m_regSet.setDescriptor(registerDescriptor);
            registerDescriptor = this.m_regSet.getDescriptor(registerDefinition.getParentId());
        }
        RegisterWriteRequest registerWriteRequest = new RegisterWriteRequest(registerDescriptor);
        this.m_ctxt.sendRequest(registerWriteRequest);
    }

    public void fireRegisterEvent(RegisterEvent registerEvent) {
        if (registerEvent.getType() == 3) {
            this.m_refreshPending = false;
        }
        int n = this.m_listeners.size();
        block5: for (int i = 0; i < n; ++i) {
            RegisterListener registerListener = (RegisterListener)this.m_listeners.get(i);
            switch (registerEvent.getType()) {
                case 1: 
                case 2: 
                case 3: {
                    registerListener.registersChanged(registerEvent);
                    continue block5;
                }
                case 4: {
                    registerListener.registerChanged(registerEvent);
                    continue block5;
                }
                case 5: {
                    registerListener.registerNotChanged(registerEvent);
                }
            }
        }
    }
}

