/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.listener.MemoryListener;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.request.MemoryAddrReadRequest;
import com.ibm.iseries.debug.request.MemoryAddrWriteRequest;
import com.ibm.iseries.debug.request.MemoryExpReadRequest;
import com.ibm.iseries.debug.request.MemoryExpWriteRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Manager;

public class MemoryManager
extends Manager {
    public static final String KEY = "memmgr";
    protected DebugContext m_ctxt;

    public MemoryManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public void cleanUp() {
        int n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(i);
            memoryListener.memoryMgrCleanUp();
        }
        super.cleanUp();
        this.m_ctxt = null;
    }

    public String getKey() {
        return KEY;
    }

    public void clear() {
        super.clear();
        int n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(i);
            memoryListener.memoryMgrClear();
        }
    }

    public void requestMemoryRead(MemoryAddress memoryAddress, int n) {
        MemoryAddrReadRequest memoryAddrReadRequest = new MemoryAddrReadRequest(memoryAddress, n);
        this.m_ctxt.sendRequest(memoryAddrReadRequest);
    }

    public void requestMemoryWrite(MemoryAddress memoryAddress, String string, String string2) {
        MemoryAddrWriteRequest memoryAddrWriteRequest = new MemoryAddrWriteRequest(memoryAddress, string, string2);
        this.m_ctxt.sendRequest(memoryAddrWriteRequest);
    }

    public void requestMemoryRead(String string, String string2, int n, int n2) {
        MemoryExpReadRequest memoryExpReadRequest = new MemoryExpReadRequest(string, string2, n, n2);
        this.m_ctxt.sendRequest(memoryExpReadRequest);
    }

    public void requestMemoryWrite(String string, String string2, int n, String string3, String string4) {
        MemoryExpWriteRequest memoryExpWriteRequest = new MemoryExpWriteRequest(string, string2, n, string3, string4);
        this.m_ctxt.sendRequest(memoryExpWriteRequest);
    }

    public void fireMemoryEvent(MemoryEvent memoryEvent) {
        VariableManager variableManager;
        int n = this.m_listeners.size();
        block7: for (int i = 0; i < n; ++i) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(i);
            switch (memoryEvent.getType()) {
                case 1: {
                    memoryListener.memoryAvailable(memoryEvent);
                    continue block7;
                }
                case 3: {
                    memoryListener.memoryNotAvailable(memoryEvent);
                    continue block7;
                }
                case 2: {
                    memoryListener.memoryChanged(memoryEvent);
                    continue block7;
                }
                case 4: {
                    memoryListener.memoryNotChanged(memoryEvent);
                    continue block7;
                }
                case 5: {
                    memoryListener.memoryPossiblyChanged(memoryEvent);
                }
            }
        }
        if (memoryEvent.getType() == 2 && (variableManager = (VariableManager)this.m_ctxt.getManager("varmgr")) != null) {
            variableManager.fireVariableEvent(new VariableEvent(this, 4));
        }
    }

    public void fireMemoryAddressSizeChanged(int n, int n2) {
        int n3 = this.m_listeners.size();
        for (int i = 0; i < n3; ++i) {
            MemoryListener memoryListener = (MemoryListener)this.m_listeners.get(i);
            memoryListener.memoryAddressSizeChanged(n, n2);
        }
    }
}

