/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.DebugFrame;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debugmanager.DebugManager;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LAFManager
extends Manager {
    public static final String KEY = "lafmgr";
    public static final String METAL_LAF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIF_LAF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String WINDOWS_LAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String MAC_LAF = "javax.swing.plaf.mac.MacLookAndFeel";
    private static LAFManager s_instance;
    protected UIManager.LookAndFeelInfo[] m_laf = UIManager.getInstalledLookAndFeels();
    protected String m_currentLAF = "";
    protected boolean m_firstLAF = true;

    public static LAFManager instance() {
        if (s_instance == null) {
            s_instance = new LAFManager();
        }
        return s_instance;
    }

    private LAFManager() {
        String string = UIManager.getLookAndFeel().getName();
        for (int i = 0; i < this.m_laf.length; ++i) {
            if (!string.equals(this.m_laf[i].getName())) continue;
            this.m_currentLAF = this.m_laf[i].getClassName();
            break;
        }
    }

    public String getKey() {
        return KEY;
    }

    public void cleanUp() {
    }

    public String getLookAndFeel() {
        return this.m_currentLAF;
    }

    public boolean setLookAndFeel(String string, boolean bl) {
        boolean bl2 = true;
        try {
            if (!string.equals(this.m_currentLAF)) {
                UIManager.setLookAndFeel(string);
                this.m_currentLAF = string;
                this.lookAndFeelModifications();
                if (bl) {
                    DebugFrame debugFrame;
                    int n;
                    ArrayList arrayList = DebugFrame.getAllDebugFrames();
                    int n2 = arrayList.size();
                    for (n = 0; n < n2; ++n) {
                        debugFrame = (DebugFrame)arrayList.get(n);
                        SwingUtilities.updateComponentTreeUI(debugFrame);
                    }
                    if (DebugManager.instanceValid()) {
                        DebugManager.instance().postClock();
                        SwingUtilities.updateComponentTreeUI(DebugManager.instance());
                    }
                    this.fireLookAndFeelEvent(new LAFEvent(this.m_currentLAF));
                    for (n = 0; n < n2; ++n) {
                        debugFrame = (DebugFrame)arrayList.get(n);
                        debugFrame.pack();
                    }
                    if (DebugManager.instanceValid()) {
                        DebugManager.instance().pack();
                        DebugManager.instance().retractClock();
                    }
                }
            } else {
                this.lookAndFeelModifications();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    private void lookAndFeelModifications() {
        Font font;
        UIManager.put("Tree.hash", UIManager.getColor("Tree.foreground"));
        UIManager.put("Tree.line", UIManager.getColor("Tree.foreground"));
        UIManager.put("Tree.background", UIManager.getColor("Table.background"));
        UIManager.put("Tree.textBackground", UIManager.getColor("Table.background"));
        UIManager.put("SplitPane.dividerSize", new Integer(10));
        if (this.m_currentLAF.equals(WINDOWS_LAF) && (font = UIManager.getFont("Panel.font")).getSize() < 12) {
            font = font.deriveFont(12.0f);
            UIManager.put("Panel.font", font);
            UIManager.put("ScrollPane.font", font);
            UIManager.put("Viewport.font", font);
            UIManager.put("TabbedPane.font", font);
            UIManager.put("List.font", font);
            UIManager.put("Tree.font", font);
            UIManager.put("Table.font", font);
            UIManager.put("TableHeader.font", font);
            UIManager.put("ComboBox.font", font);
            UIManager.put("CheckBox.font", font);
            UIManager.put("TextField.font", font);
            UIManager.put("Label.font", font);
            UIManager.put("MenuBar.font", font);
            UIManager.put("Menu.font", font);
            UIManager.put("PopupMenu.font", font);
            UIManager.put("MenuItem.font", font);
            UIManager.put("RadioButtonMenuItem.font", font);
            UIManager.put("CheckBoxMenuItem.font", font);
            UIManager.put("Button.font", font);
            UIManager.put("RadioButton.font", font);
            UIManager.put("ToggleButton.font", font);
            UIManager.put("TitledBorder.font", font);
        }
    }

    public void fireLookAndFeelEvent(LAFEvent lAFEvent) {
        int n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            LAFListener lAFListener = (LAFListener)this.m_listeners.get(i);
            lAFListener.lookAndFeelChanged(lAFEvent);
        }
    }
}

