/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.BrowseJobDialog;
import com.ibm.iseries.debug.dialog.ISeriesJobNum;
import com.ibm.iseries.debug.dialog.ISeriesJobNumListener;
import com.ibm.iseries.debug.dialog.ISeriesObjName;
import com.ibm.iseries.debug.dialog.ISeriesObjNameListener;
import com.ibm.iseries.debug.dialog.PickFromListDialog;
import com.ibm.iseries.debug.dialog.TokenEditorDialog;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class StartDebugDialog
extends Dialog
implements ISeriesObjNameListener,
ISeriesJobNumListener,
DebugConstants,
FocusListener {
    private static final String TYPE = "type";
    private static final String OBJ1 = "obj1";
    private static final String OBJ2 = "obj2";
    private static final String PARMS = "parms";
    private static final String CMD = "cmd";
    private static final String CLASSPATH = "clspath";
    private static final String SRCPATH = "srcpath";
    private static final String SUBMIT = "submit";
    private static final String SPECIFY = "specify";
    private static final String JOB_NAME = "jobname";
    private static final String JOB_USER = "jobuser";
    private static final String JOB_NUM = "jobnum";
    private static final String RECENT = "recent";
    private static final String BROWSE = "browse";
    private static final String HOST_BUTTON = "hostb";
    private static final String CLIENT_BUTTON = "clientb";
    private static final String CLASSPATH_BUTTON = "clspathb";
    private static final String PARMS_BUTTON = "parmsb";
    private static final String ILE_PASE = "ilepase";
    private static final String USER_KEY_FLAG = "*";
    private static final int HOST_PATH = 0;
    private static final int CLIENT_PATH = 1;
    private static final int CLASS_PATH = 2;
    private static final int TEXT_FIELD_WIDTH = 25;
    private DebugWindow m_wnd;
    private SettingsManager m_settingsMgr;
    private Settings m_userCfg;
    private Settings m_userAliases;
    private JPanel m_panel;
    private JPanel m_boxPanel;
    private JPanel m_infoPanel;
    private JPanel m_methodPanel;
    private JPanel m_pgmPanel;
    private JPanel m_jobPanel;
    private JComboBox m_typeCtrl;
    private JLabel m_typeLabel;
    private JLabel m_label1;
    private JLabel m_label2;
    private JLabel m_pgmParmsLabel;
    private JLabel m_cmdLabel;
    private JLabel m_ioLabel;
    private JLabel m_classPathLabel;
    private JLabel m_hostSrcPathLabel;
    private JLabel m_clientSrcPathLabel;
    private JLabel m_jobNameLabel;
    private JLabel m_jobUserLabel;
    private JLabel m_jobNumLabel;
    private JRadioButton m_submitCtrl;
    private JRadioButton m_specifyCtrl;
    private JCheckBox m_IlePaseCtrl;
    private ISeriesObjName m_obj1Ctrl;
    private ISeriesObjName m_obj2Ctrl;
    private JTextField m_pgmParmsCtrl;
    private JTextField m_cmdCtrl;
    private JComboBox m_ioCtrl;
    private JTextField m_classPathCtrl;
    private JTextField m_hostSrcPathCtrl;
    private JTextField m_clientSrcPathCtrl;
    private ISeriesObjName m_jobNameCtrl;
    private ISeriesObjName m_jobUserCtrl;
    private ISeriesJobNum m_jobNumCtrl;
    private JButton m_recentButton;
    private JButton m_pgmParmsButton;
    private JButton m_classPathButton;
    private JButton m_hostSrcPathButton;
    private JButton m_clientSrcPathButton;
    private JButton m_browseButton;
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_pgmParms;
    private String m_cmd;
    private String m_classPath;
    private String m_hostSrcPath;
    private String m_clientSrcPath;
    private String m_jobName;
    private String m_jobUser;
    private String m_jobNum;
    private String m_jobId;
    private boolean m_submitJob;
    private boolean m_debugIlePase;
    private String m_user;
    private boolean m_redirectIO;
    private boolean m_cmdSupported;
    private boolean m_ioSupported;
    private boolean m_IlePaseSupported;

    public StartDebugDialog(DebugWindow debugWindow, SettingsManager settingsManager, String string) {
        super(debugWindow.getJFrame(), MRI.get("DBG_START_DEBUG_DIALOG_TITLE"), true, string);
        this.m_wnd = debugWindow;
        this.m_settingsMgr = settingsManager;
        this.m_userCfg = this.m_settingsMgr.getUserConfig();
        this.m_userAliases = this.m_settingsMgr.getUserAliases();
        this.m_cmdSupported = debugWindow.isSupported(3, debugWindow.getSystemVersion());
        this.m_ioSupported = debugWindow.isSupported(8, debugWindow.getSystemVersion());
        this.m_IlePaseSupported = debugWindow.isSupported(9, debugWindow.getSystemVersion());
    }

    public StartDebugDialog(DebugWindow debugWindow, SettingsManager settingsManager, int n, String string, String string2, String string3) {
        this(debugWindow, settingsManager, string3);
        this.m_pgmLib = this.m_userCfg.getString("strdbgPgmLib", "");
        this.m_pgmName = this.m_userCfg.getString("strdbgPgmName", "");
        this.m_pgmParms = this.m_userCfg.getString("strdbgPgmParms", "");
        this.m_cmd = this.m_userCfg.getString("strdbgCmd", "");
        this.m_classPath = this.m_userCfg.getString("strdbgClassPath", "");
        this.m_hostSrcPath = this.m_userCfg.getString("strdbgHostSrcPath", "");
        this.m_clientSrcPath = this.m_userCfg.getString("strdbgClientSrcPath", "");
        this.m_jobName = this.m_userCfg.getString("strdbgJobName", "");
        this.m_jobUser = this.m_userCfg.getString("strdbgJobUser", "");
        this.m_jobNum = this.m_userCfg.getString("strdbgJobNum", "");
        this.m_submitJob = this.m_userCfg.getBool("strdbgSubmit", true);
        this.m_redirectIO = this.m_userCfg.getBool("strdbgRedirectIO", false);
        this.m_debugIlePase = this.m_userCfg.getBool("strdbgIlePase", false);
        this.m_user = string2;
        boolean bl = false;
        int n2 = this.m_userCfg.getInt("strdbgPgmType", -1);
        if (n >= 0) {
            this.m_pgmType = n;
            bl = this.m_pgmType == n2;
        } else if (n2 >= 0) {
            this.m_pgmType = n2;
            bl = true;
        } else {
            this.m_pgmType = 0;
        }
        this.addComponents(bl, string, string2);
    }

    public StartDebugDialog(DebugWindow debugWindow, SettingsManager settingsManager, String string, String string2, String string3, String string4) {
        this(debugWindow, settingsManager, string4);
        this.m_pgmLib = "";
        this.m_pgmName = "";
        this.m_pgmType = 0;
        this.m_cmd = "";
        this.m_classPath = "";
        this.m_hostSrcPath = "";
        this.m_clientSrcPath = "";
        this.m_jobName = "";
        this.m_jobUser = "";
        this.m_jobNum = "";
        this.m_submitJob = false;
        this.m_redirectIO = false;
        this.m_user = string2;
        int n = string3.indexOf(47);
        if (n >= 0) {
            this.m_jobNum = string3.substring(0, n);
            int n2 = string3.indexOf(47, n + 1);
            if (n2 >= 0) {
                this.m_jobUser = string3.substring(n + 1, n2);
                this.m_jobName = string3.substring(n2 + 1);
            }
        }
        this.addComponents(true, string, string2);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_wnd = null;
        this.m_settingsMgr = null;
        this.m_panel = null;
        this.m_boxPanel = null;
        this.m_infoPanel = null;
        this.m_methodPanel = null;
        this.m_pgmPanel = null;
        this.m_jobPanel = null;
        this.m_typeCtrl = null;
        this.m_typeLabel = null;
        this.m_label1 = null;
        this.m_label2 = null;
        this.m_pgmParmsLabel = null;
        this.m_cmdLabel = null;
        this.m_ioLabel = null;
        this.m_classPathLabel = null;
        this.m_hostSrcPathLabel = null;
        this.m_clientSrcPathLabel = null;
        this.m_jobNameLabel = null;
        this.m_jobUserLabel = null;
        this.m_jobNumLabel = null;
        this.m_submitCtrl = null;
        this.m_specifyCtrl = null;
        this.m_IlePaseCtrl = null;
        this.m_obj1Ctrl = null;
        this.m_obj2Ctrl = null;
        this.m_pgmParmsCtrl = null;
        this.m_cmdCtrl = null;
        this.m_ioCtrl = null;
        this.m_classPathCtrl = null;
        this.m_hostSrcPathCtrl = null;
        this.m_clientSrcPathCtrl = null;
        this.m_jobNameCtrl = null;
        this.m_jobUserCtrl = null;
        this.m_jobNumCtrl = null;
        this.m_recentButton = null;
        this.m_pgmParmsButton = null;
        this.m_classPathButton = null;
        this.m_hostSrcPathButton = null;
        this.m_clientSrcPathButton = null;
        this.m_browseButton = null;
    }

    public void onlyAllowProgramEdit() {
        this.m_submitCtrl.setEnabled(false);
        this.m_specifyCtrl.setEnabled(false);
        this.m_jobNameLabel.setEnabled(false);
        this.m_jobUserLabel.setEnabled(false);
        this.m_jobNumLabel.setEnabled(false);
        this.m_jobNameCtrl.setEnabled(false);
        this.m_jobUserCtrl.setEnabled(false);
        this.m_jobNumCtrl.setEnabled(false);
        this.m_browseButton.setEnabled(false);
    }

    private void addComponents(boolean bl, String string, String string2) {
        Dimension dimension;
        Serializable serializable;
        int n;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_boxPanel = new JPanel();
        this.m_infoPanel = new JPanel(new BorderLayout());
        this.m_methodPanel = new JPanel(new GridLayout(0, 1));
        this.m_pgmPanel = new JPanel(new BorderLayout());
        this.m_jobPanel = new JPanel(new BorderLayout());
        this.m_boxPanel.setLayout(new BoxLayout(this.m_boxPanel, 1));
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.listenForEscape(this.m_panel);
        ArrayList arrayList = new ArrayList();
        this.createInfoPanel(string, string2, arrayList);
        this.createMethodPanel(arrayList);
        this.createPgmPanel(arrayList);
        this.createJobPanel(arrayList);
        int n2 = arrayList.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            serializable = (JLabel)arrayList.get(n);
            dimension = ((JComponent)serializable).getPreferredSize();
            if (dimension.width <= n3) continue;
            n3 = dimension.width;
        }
        for (n = 0; n < n2; ++n) {
            serializable = (JLabel)arrayList.get(n);
            dimension = ((JComponent)serializable).getPreferredSize();
            dimension.width = n3;
            ((JComponent)serializable).setPreferredSize(dimension);
        }
        Dimension dimension2 = this.m_typeCtrl.getPreferredSize();
        serializable = this.m_recentButton.getPreferredSize();
        dimension = this.m_browseButton.getPreferredSize();
        Dimension dimension3 = this.m_classPathButton.getPreferredSize();
        if (((Dimension)serializable).width < dimension.width) {
            ((Dimension)serializable).width = dimension.width;
        }
        if (((Dimension)serializable).width < dimension3.width) {
            ((Dimension)serializable).width = dimension3.width;
        }
        if (((Dimension)serializable).height - dimension2.height < 10) {
            ((Dimension)serializable).height = dimension2.height;
        }
        this.m_recentButton.setPreferredSize((Dimension)serializable);
        this.m_browseButton.setPreferredSize((Dimension)serializable);
        this.m_pgmParmsButton.setPreferredSize((Dimension)serializable);
        this.m_classPathButton.setPreferredSize((Dimension)serializable);
        this.m_hostSrcPathButton.setPreferredSize((Dimension)serializable);
        this.m_clientSrcPathButton.setPreferredSize((Dimension)serializable);
        if (bl) {
            try {
                switch (this.indexToPgmType(this.m_typeCtrl.getSelectedIndex())) {
                    case 0: 
                    case 1: {
                        this.m_obj1Ctrl.setText(this.m_pgmName);
                        this.m_obj2Ctrl.setText(this.m_pgmLib);
                        break;
                    }
                    case 2: {
                        this.m_obj1Ctrl.setText(this.m_pgmLib);
                        this.m_obj2Ctrl.setText(this.m_pgmName);
                    }
                }
                this.m_pgmParmsCtrl.setText(this.m_pgmParms);
                this.m_cmdCtrl.setText(this.m_cmd);
                this.m_classPathCtrl.setText(this.m_classPath);
                this.m_hostSrcPathCtrl.setText(this.m_hostSrcPath);
                this.m_clientSrcPathCtrl.setText(this.m_clientSrcPath);
                this.m_jobNameCtrl.setText(this.m_jobName);
                this.m_jobUserCtrl.setText(this.m_jobUser);
                this.m_jobNumCtrl.setText(this.m_jobNum);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.enableJobControls(!this.m_submitJob);
        this.enablePgmControls(this.m_submitJob);
        this.enableClassControls(this.m_pgmType == 2);
        Dimension dimension4 = new Dimension(0, 5);
        this.m_boxPanel.add(this.m_infoPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension4));
        this.m_boxPanel.add(this.m_methodPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension4));
        this.m_boxPanel.add(this.m_pgmPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension4));
        this.m_boxPanel.add(this.m_jobPanel);
        this.m_boxPanel.add(Box.createVerticalGlue());
        this.m_panel.add((Component)this.m_boxPanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.addWindowListener(new WndAdapter());
    }

    private void createInfoPanel(String string, String string2, ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_SYSTEM_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(Util.firstUpper(string));
        JLabel jLabel4 = Util.getAccessibleLabel(Util.firstUpper(string2));
        jPanel.setBorder(this.getEmptyBorder(0, 5, 5, 10));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        arrayList.add(jLabel);
        arrayList.add(jLabel2);
        jPanel2.setBorder(this.getEmptyBorder(0, 10, 5, 10));
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        Util.setAccessible((Accessible)jLabel3, jLabel);
        Util.setAccessible((Accessible)jLabel4, jLabel2);
        Util.setOrientation(jLabel3, jLabel);
        Util.setOrientation(jLabel4, jLabel2);
        this.m_infoPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_infoPanel.add((Component)jPanel2, "Center");
    }

    private void createMethodPanel(ArrayList arrayList) {
        String string = MRI.get("DBG_SUBMIT_AND_DEBUG");
        String string2 = MRI.get("DBG_DEBUG_EXISTING");
        String string3 = MRI.get("DBG2_DEBUG_PASE");
        this.m_submitCtrl = new JRadioButton(string);
        this.m_submitCtrl.setSelected(this.m_submitJob);
        this.m_submitCtrl.setActionCommand(SUBMIT);
        this.m_submitCtrl.addActionListener(this);
        this.m_submitCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        this.m_specifyCtrl = new JRadioButton(string2);
        this.m_specifyCtrl.setSelected(!this.m_submitJob);
        this.m_specifyCtrl.setActionCommand(SPECIFY);
        this.m_specifyCtrl.addActionListener(this);
        this.m_specifyCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_submitCtrl);
        buttonGroup.add(this.m_specifyCtrl);
        this.m_IlePaseCtrl = new JCheckBox(string3, this.m_debugIlePase);
        this.m_IlePaseCtrl.setActionCommand(ILE_PASE);
        this.m_IlePaseCtrl.addActionListener(this);
        this.m_IlePaseCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        Util.setAccessible((Accessible)this.m_submitCtrl, string);
        Util.setAccessible((Accessible)this.m_specifyCtrl, string2);
        Util.setAccessible((Accessible)this.m_IlePaseCtrl, string3);
        Util.setOrientation(this.m_submitCtrl);
        Util.setOrientation(this.m_specifyCtrl);
        Util.setOrientation(this.m_IlePaseCtrl);
        this.m_methodPanel.setBorder(this.getTitledBorder(MRI.get("DBG_SELECT_METHOD")));
        this.m_methodPanel.add(this.m_submitCtrl);
        this.m_methodPanel.add(this.m_specifyCtrl);
        if (this.m_IlePaseSupported) {
            this.m_methodPanel.add(new JLabel());
            this.m_methodPanel.add(this.m_IlePaseCtrl);
        }
    }

    private void createPgmPanel(ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        JLabel jLabel = new JLabel(this.m_pgmType == 2 ? MRI.get("DBG_NAME_LABEL") : MRI.get("DBG_PACKAGE_LABEL"));
        JLabel jLabel2 = new JLabel(this.m_pgmType == 2 ? MRI.get("DBG_LIBRARY_LABEL") : MRI.get("DBG_CLASS_NAME_LABEL"));
        this.m_typeLabel = Util.getAccessibleLabel(MRI.get("DBG_TYPE_LABEL"));
        this.m_label1 = Util.getAccessibleLabel(this.m_pgmType == 2 ? MRI.get("DBG_PACKAGE_LABEL") : MRI.get("DBG_NAME_LABEL"));
        this.m_label2 = Util.getAccessibleLabel(this.m_pgmType == 2 ? MRI.get("DBG_CLASS_NAME_LABEL") : MRI.get("DBG_LIBRARY_LABEL"));
        this.m_pgmParmsLabel = Util.getAccessibleLabel(MRI.get("DBG_PARAMETERS_LABEL"));
        this.m_cmdLabel = Util.getAccessibleLabel(MRI.get("DBG_INIT_CMD_LABEL"));
        this.m_ioLabel = Util.getAccessibleLabel(MRI.get("DBG_STANDARD_IO_LABEL"));
        this.m_classPathLabel = Util.getAccessibleLabel(MRI.get("DBG_CLASS_PATH_LABEL"));
        this.m_hostSrcPathLabel = Util.getAccessibleLabel(MRI.get("DBG_HOST_SOURCE_PATH_LABEL"));
        this.m_clientSrcPathLabel = Util.getAccessibleLabel(MRI.get("DBG_CLIENT_SOURCE_PATH_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel.add(this.m_typeLabel);
        jPanel.add(this.m_label1);
        jPanel.add(this.m_label2);
        jPanel.add(this.m_pgmParmsLabel);
        if (this.m_cmdSupported) {
            jPanel.add(this.m_cmdLabel);
        }
        if (this.m_ioSupported) {
            jPanel.add(this.m_ioLabel);
        }
        jPanel.add(this.m_classPathLabel);
        jPanel.add(this.m_hostSrcPathLabel);
        jPanel.add(this.m_clientSrcPathLabel);
        arrayList.add(this.m_typeLabel);
        arrayList.add(this.m_label1);
        arrayList.add(this.m_label2);
        arrayList.add(this.m_pgmParmsLabel);
        if (this.m_cmdSupported) {
            arrayList.add(this.m_cmdLabel);
        }
        if (this.m_ioSupported) {
            arrayList.add(this.m_ioLabel);
        }
        arrayList.add(this.m_classPathLabel);
        arrayList.add(this.m_hostSrcPathLabel);
        arrayList.add(this.m_clientSrcPathLabel);
        arrayList.add(this.m_label1);
        arrayList.add(this.m_label2);
        arrayList.add(jLabel);
        arrayList.add(jLabel2);
        this.m_typeCtrl = new JComboBox();
        this.m_typeCtrl.setRenderer(new DummyRenderer());
        this.m_typeCtrl.addItem(MRI.get("DBG_PROGRAM"));
        if (!this.m_submitJob) {
            this.m_typeCtrl.addItem(MRI.get("DBG_SERVICE_PROGRAM"));
        }
        this.m_typeCtrl.addItem(MRI.get("DBG_CLASS_FILE"));
        this.m_typeCtrl.setSelectedIndex(this.pgmTypeToIndex(this.m_pgmType));
        this.m_typeCtrl.setActionCommand(TYPE);
        this.m_typeCtrl.addActionListener(this);
        this.m_obj1Ctrl = new ISeriesObjName(this.m_pgmType != 2);
        this.m_obj1Ctrl.setActionCommand(OBJ1);
        this.m_obj1Ctrl.addActionListener(this);
        this.m_obj2Ctrl = new ISeriesObjName(this.m_pgmType != 2);
        this.m_obj2Ctrl.setActionCommand(OBJ2);
        this.m_obj2Ctrl.addActionListener(this);
        this.m_pgmParmsCtrl = new JTextField(25);
        this.m_pgmParmsCtrl.setActionCommand(PARMS);
        this.m_pgmParmsCtrl.addActionListener(this);
        this.m_pgmParmsCtrl.addFocusListener(this);
        this.m_cmdCtrl = new JTextField(this.m_cmd, 25);
        this.m_cmdCtrl.setActionCommand(CMD);
        this.m_cmdCtrl.addActionListener(this);
        this.m_cmdCtrl.addFocusListener(this);
        this.m_ioCtrl = new JComboBox();
        this.m_ioCtrl.setRenderer(new DummyRenderer());
        this.m_ioCtrl.addItem(MRI.get("DBG_IO_TO_SPOOL_FILE"));
        this.m_ioCtrl.addItem(MRI.get("DBG_IO_TO_IO_PANEL"));
        this.m_ioCtrl.setSelectedIndex(this.m_redirectIO ? 1 : 0);
        this.m_classPathCtrl = new JTextField(25);
        this.m_classPathCtrl.setActionCommand(CLASSPATH);
        this.m_classPathCtrl.addActionListener(this);
        this.m_classPathCtrl.addFocusListener(this);
        this.m_hostSrcPathCtrl = new JTextField(25);
        this.m_hostSrcPathCtrl.setActionCommand(SRCPATH);
        this.m_hostSrcPathCtrl.addActionListener(this);
        this.m_hostSrcPathCtrl.addFocusListener(this);
        this.m_clientSrcPathCtrl = new JTextField(25);
        this.m_clientSrcPathCtrl.setActionCommand(SRCPATH);
        this.m_clientSrcPathCtrl.addActionListener(this);
        this.m_clientSrcPathCtrl.addFocusListener(this);
        jPanel2.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel2.add(this.m_typeCtrl);
        jPanel2.add(this.m_obj1Ctrl);
        jPanel2.add(this.m_obj2Ctrl);
        jPanel2.add(this.m_pgmParmsCtrl);
        if (this.m_cmdSupported) {
            jPanel2.add(this.m_cmdCtrl);
        }
        if (this.m_ioSupported) {
            jPanel2.add(this.m_ioCtrl);
        }
        jPanel2.add(this.m_classPathCtrl);
        jPanel2.add(this.m_hostSrcPathCtrl);
        jPanel2.add(this.m_clientSrcPathCtrl);
        Dimension dimension = this.m_typeCtrl.getPreferredSize();
        String string = MRI.get("DBG_RECENT_WITH_ELLIPSIS");
        this.m_recentButton = this.createButton(string, RECENT, dimension.height);
        if (this.m_settingsMgr.getRecentPgms().size() == 0) {
            this.m_recentButton.setEnabled(false);
        }
        String string2 = MRI.get("DBG_EDIT_WITH_ELLIPSIS");
        this.m_pgmParmsButton = this.createButton(string2, PARMS_BUTTON, dimension.height);
        this.m_classPathButton = this.createButton(string2, CLASSPATH_BUTTON, dimension.height);
        this.m_hostSrcPathButton = this.createButton(string2, HOST_BUTTON, dimension.height);
        this.m_clientSrcPathButton = this.createButton(string2, CLIENT_BUTTON, dimension.height);
        jPanel3.setBorder(this.getEmptyBorder(5, 0, 10, 10));
        jPanel3.add(this.m_recentButton);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        jPanel3.add(this.m_pgmParmsButton);
        if (this.m_cmdSupported) {
            jPanel3.add(new JLabel(" "));
        }
        if (this.m_ioSupported) {
            jPanel3.add(new JLabel(" "));
        }
        jPanel3.add(this.m_classPathButton);
        jPanel3.add(this.m_hostSrcPathButton);
        jPanel3.add(this.m_clientSrcPathButton);
        this.m_pgmPanel.setBorder(this.getTitledBorder(MRI.get("DBG_PROGRAM_TO_DEBUG")));
        this.m_pgmPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_pgmPanel.add((Component)jPanel2, "Center");
        this.m_pgmPanel.add((Component)jPanel3, this.m_isLtoR ? "East" : "West");
        Util.setAccessible((Accessible)this.m_typeCtrl, this.m_typeLabel);
        Util.setAccessible((Accessible)this.m_obj1Ctrl, this.m_label1);
        Util.setAccessible((Accessible)this.m_obj2Ctrl, this.m_label2);
        Util.setAccessible((Accessible)this.m_pgmParmsCtrl, this.m_pgmParmsLabel);
        Util.setAccessible((Accessible)this.m_cmdCtrl, this.m_cmdLabel);
        Util.setAccessible((Accessible)this.m_ioCtrl, this.m_ioLabel);
        Util.setAccessible((Accessible)this.m_classPathCtrl, this.m_classPathLabel);
        Util.setAccessible((Accessible)this.m_hostSrcPathCtrl, this.m_hostSrcPathLabel);
        Util.setAccessible((Accessible)this.m_clientSrcPathCtrl, this.m_clientSrcPathLabel);
        Util.setAccessible((Accessible)this.m_recentButton, string);
        Util.setAccessible((Accessible)this.m_pgmParmsButton, string2);
        Util.setAccessible((Accessible)this.m_classPathButton, string2);
        Util.setAccessible((Accessible)this.m_hostSrcPathButton, string2);
        Util.setAccessible((Accessible)this.m_clientSrcPathButton, string2);
        Util.setOrientation(this.m_typeCtrl, this.m_typeLabel);
        Util.setOrientation(this.m_obj1Ctrl, this.m_label1);
        Util.setOrientation(this.m_obj2Ctrl, this.m_label2);
        Util.setOrientation(this.m_pgmParmsCtrl, this.m_pgmParmsLabel);
        Util.setOrientation(this.m_cmdCtrl, this.m_cmdLabel);
        Util.setOrientation(this.m_ioCtrl, this.m_ioLabel);
        Util.setOrientation(this.m_classPathCtrl, this.m_classPathLabel);
        Util.setOrientation(this.m_hostSrcPathCtrl, this.m_hostSrcPathLabel);
        Util.setOrientation(this.m_clientSrcPathCtrl, this.m_clientSrcPathLabel);
        Util.setOrientation(this.m_recentButton);
        Util.setOrientation(this.m_pgmParmsButton);
        Util.setOrientation(this.m_classPathButton);
        Util.setOrientation(this.m_hostSrcPathButton);
        Util.setOrientation(this.m_clientSrcPathButton);
    }

    private JButton createButton(String string, String string2, int n) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        jButton.setMargin(new Insets(0, 2, 0, 2));
        Dimension dimension = jButton.getPreferredSize();
        if (dimension.height - n < 10) {
            dimension.height = n;
            jButton.setPreferredSize(dimension);
        }
        return jButton;
    }

    private void createJobPanel(ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_jobNameLabel = Util.getAccessibleLabel(MRI.get("DBG_JOB_NAME_LABEL"));
        this.m_jobUserLabel = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        this.m_jobNumLabel = Util.getAccessibleLabel(MRI.get("DBG_JOB_NUMBER_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel.add(this.m_jobNameLabel);
        jPanel.add(this.m_jobUserLabel);
        jPanel.add(this.m_jobNumLabel);
        arrayList.add(this.m_jobNameLabel);
        arrayList.add(this.m_jobUserLabel);
        arrayList.add(this.m_jobNumLabel);
        this.m_jobNameCtrl = new ISeriesObjName(this);
        this.m_jobNameCtrl.setActionCommand(JOB_NAME);
        this.m_jobNameCtrl.addActionListener(this);
        this.m_jobUserCtrl = new ISeriesObjName(this);
        this.m_jobUserCtrl.setActionCommand(JOB_USER);
        this.m_jobUserCtrl.addActionListener(this);
        this.m_jobNumCtrl = new ISeriesJobNum(this);
        this.m_jobNumCtrl.setActionCommand(JOB_NUM);
        this.m_jobNumCtrl.addActionListener(this);
        jPanel2.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel2.add(this.m_jobNameCtrl);
        jPanel2.add(this.m_jobUserCtrl);
        jPanel2.add(this.m_jobNumCtrl);
        Dimension dimension = this.m_typeCtrl.getPreferredSize();
        String string = MRI.get("DBG_BROWSE_WITH_ELLIPSIS");
        this.m_browseButton = this.createButton(string, BROWSE, dimension.height);
        jPanel3.setBorder(this.getEmptyBorder(5, 0, 10, 10));
        jPanel3.add(this.m_browseButton);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        this.m_jobPanel.setBorder(this.getTitledBorder(MRI.get("DBG_JOB_TO_DEBUG")));
        this.m_jobPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_jobPanel.add((Component)jPanel2, "Center");
        this.m_jobPanel.add((Component)jPanel3, this.m_isLtoR ? "East" : "West");
        Util.setAccessible((Accessible)this.m_jobNameCtrl, this.m_jobNameLabel);
        Util.setAccessible((Accessible)this.m_jobUserCtrl, this.m_jobUserLabel);
        Util.setAccessible((Accessible)this.m_jobNumCtrl, this.m_jobNumLabel);
        Util.setAccessible((Accessible)this.m_browseButton, string);
        Util.setOrientation(this.m_jobNameCtrl, this.m_jobNameLabel);
        Util.setOrientation(this.m_jobUserCtrl, this.m_jobUserLabel);
        Util.setOrientation(this.m_jobNumCtrl, this.m_jobNumLabel);
        Util.setOrientation(this.m_browseButton);
    }

    private void enableJobControls(boolean bl) {
        this.m_jobNameLabel.setEnabled(bl);
        this.m_jobUserLabel.setEnabled(bl);
        this.m_jobNumLabel.setEnabled(bl);
        this.m_jobNameCtrl.setEnabled(bl);
        this.m_jobUserCtrl.setEnabled(bl);
        this.m_jobNumCtrl.setEnabled(bl);
        this.m_jobNameCtrl.setOpaque(bl);
        this.m_jobUserCtrl.setOpaque(bl);
        this.m_jobNumCtrl.setOpaque(bl);
        this.m_browseButton.setEnabled(bl);
        if (bl) {
            if (this.m_typeCtrl.getItemCount() < 3) {
                this.m_typeCtrl.insertItemAt(MRI.get("DBG_SERVICE_PROGRAM"), 1);
            }
        } else if (this.m_typeCtrl.getItemCount() == 3) {
            this.m_typeCtrl.removeItemAt(1);
        }
    }

    private void enablePgmControls(boolean bl) {
        this.m_pgmParmsLabel.setEnabled(bl);
        this.m_pgmParmsCtrl.setEnabled(bl);
        this.m_pgmParmsCtrl.setOpaque(bl);
        this.m_pgmParmsButton.setEnabled(bl);
        this.m_cmdLabel.setEnabled(bl);
        this.m_cmdCtrl.setEnabled(bl);
        this.m_cmdCtrl.setOpaque(bl);
        this.m_ioLabel.setEnabled(bl);
        this.m_ioCtrl.setEnabled(bl);
    }

    private void enableClassControls(boolean bl) {
        this.m_classPathLabel.setEnabled(bl);
        this.m_classPathCtrl.setEnabled(bl);
        this.m_classPathCtrl.setOpaque(bl);
        this.m_classPathButton.setEnabled(bl);
        this.m_hostSrcPathLabel.setEnabled(bl);
        this.m_hostSrcPathCtrl.setEnabled(bl);
        this.m_hostSrcPathCtrl.setOpaque(bl);
        this.m_hostSrcPathButton.setEnabled(bl);
        this.m_clientSrcPathLabel.setEnabled(bl);
        this.m_clientSrcPathCtrl.setEnabled(bl);
        this.m_clientSrcPathCtrl.setOpaque(bl);
        this.m_clientSrcPathButton.setEnabled(bl);
    }

    private void validateType() {
        int n = this.indexToPgmType(this.m_typeCtrl.getSelectedIndex());
        String string = "";
        String string2 = "";
        switch (n) {
            case 0: 
            case 1: {
                string = MRI.get("DBG_NAME_LABEL");
                string2 = MRI.get("DBG_LIBRARY_LABEL");
                this.m_obj1Ctrl.setQsysObject(true);
                this.m_obj2Ctrl.setQsysObject(true);
                break;
            }
            case 2: {
                string = MRI.get("DBG_PACKAGE_LABEL");
                string2 = MRI.get("DBG_CLASS_NAME_LABEL");
                this.m_obj1Ctrl.setQsysObject(false);
                this.m_obj2Ctrl.setQsysObject(false);
            }
        }
        this.m_label1.setText(string);
        this.m_label2.setText(string2);
        Util.setAccessible((Accessible)this.m_label1, string);
        Util.setAccessible((Accessible)this.m_label2, string2);
        Util.setAccessible((Accessible)this.m_obj1Ctrl, this.m_label1);
        Util.setAccessible((Accessible)this.m_obj2Ctrl, this.m_label2);
        if (this.m_pgmType != n) {
            this.m_pgmType = n;
            this.m_obj1Ctrl.setText("");
            this.m_obj2Ctrl.setText("");
            this.m_pgmParmsCtrl.setText("");
            this.enableClassControls(n == 2);
        }
    }

    private void validateIlePase() {
        if (this.m_ioSupported) {
            boolean bl = this.m_submitCtrl.isSelected();
            this.m_ioLabel.setEnabled(bl);
            this.m_ioCtrl.setEnabled(bl);
            if (!bl && this.m_ioCtrl.getSelectedIndex() > 0) {
                this.m_ioCtrl.setSelectedIndex(0);
            }
        }
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public String getPgmLibrary() {
        return this.m_pgmLib;
    }

    public String getPgmName() {
        return this.m_pgmName;
    }

    public int getPgmType() {
        return this.m_pgmType;
    }

    public String getPgmParms() {
        return this.m_submitJob ? this.m_pgmParms : "";
    }

    public String getCommand() {
        return this.m_submitJob && this.m_cmdSupported ? this.m_cmd : "";
    }

    public boolean redirectIO() {
        return this.m_ioSupported && this.m_redirectIO;
    }

    public boolean debugIlePaseTransitions() {
        return this.m_IlePaseSupported && this.m_debugIlePase;
    }

    public String getClassPath() {
        return this.m_classPath;
    }

    public String getHostSourcePath() {
        return this.m_hostSrcPath;
    }

    public String getClientSourcePath() {
        return this.m_clientSrcPath;
    }

    public int getDebugOptions() {
        int n = 0;
        if (this.m_userCfg.getBool("pgmCompletionOff", false)) {
            n |= 2;
        }
        if (this.m_userCfg.getBool("varsIncBaseClass", false)) {
            n |= 4;
        }
        if (this.m_userCfg.getBool("strdbgRedirectIO", false) && this.m_jobId.equals("*SUBMIT")) {
            n |= 8;
        }
        if (this.m_IlePaseSupported && this.m_debugIlePase) {
            n |= 0x10;
        }
        return n;
    }

    private int indexToPgmType(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                if (this.m_typeCtrl.getItemCount() == 3) {
                    n2 = 1;
                    break;
                }
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        return n2;
    }

    private int pgmTypeToIndex(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                if (this.m_typeCtrl.getItemCount() == 3) {
                    n2 = 1;
                    break;
                }
                n2 = -1;
                break;
            }
            case 2: {
                n2 = this.m_typeCtrl.getItemCount() == 3 ? 2 : 1;
            }
        }
        return n2;
    }

    public void doOk() {
        int n = this.indexToPgmType(this.m_typeCtrl.getSelectedIndex());
        String string = this.m_obj1Ctrl.getText().trim();
        String string2 = this.m_obj2Ctrl.getText().trim();
        String string3 = this.m_pgmParmsCtrl.getText().trim();
        String string4 = string3.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string3.substring(1), string3) : string3;
        string3 = this.m_cmdCtrl.getText().trim();
        String string5 = string3.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string3.substring(1), string3) : string3;
        string3 = this.m_classPathCtrl.getText().trim();
        String string6 = string3.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string3.substring(1), string3) : string3;
        string3 = this.m_hostSrcPathCtrl.getText().trim();
        String string7 = string3.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string3.substring(1), string3) : string3;
        string3 = this.m_clientSrcPathCtrl.getText().trim();
        String string8 = string3.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string3.substring(1), string3) : string3;
        String string9 = this.m_jobNameCtrl.getText().trim();
        String string10 = this.m_jobUserCtrl.getText().trim();
        String string11 = this.m_jobNumCtrl.getText().trim();
        boolean bl = this.m_submitCtrl.isSelected();
        boolean bl2 = this.m_ioCtrl.getSelectedIndex() == 1;
        boolean bl3 = this.m_IlePaseCtrl.isSelected();
        boolean bl4 = false;
        if (bl) {
            if ((n == 2 || string.length() > 0) && string2.length() > 0) {
                this.m_jobId = "*SUBMIT";
                bl4 = true;
            }
        } else if ((n == 2 || string.length() > 0) && string2.length() > 0 && string9.length() > 0 && string10.length() > 0 && string11.length() == 6) {
            this.m_jobId = string11 + "/" + string10 + "/" + string9;
            bl4 = true;
        }
        if (bl4) {
            switch (n) {
                case 0: 
                case 1: {
                    this.m_pgmLib = Util.firstUpper(string2);
                    this.m_pgmName = Util.firstUpper(string);
                    break;
                }
                case 2: {
                    this.m_pgmLib = string;
                    this.m_pgmName = string2;
                    this.m_pgmLib = this.m_pgmLib.replace('/', '.');
                }
            }
            this.m_pgmType = n;
            this.m_pgmParms = string4;
            this.m_cmd = string5;
            this.m_classPath = string6;
            this.m_hostSrcPath = string7;
            this.m_clientSrcPath = string8;
            this.m_submitJob = bl;
            this.m_redirectIO = bl2;
            this.m_debugIlePase = bl3;
            this.m_jobName = Util.firstUpper(string9);
            this.m_jobUser = Util.firstUpper(string10);
            this.m_jobNum = string11;
            this.m_userCfg.setString("strdbgPgmLib", this.m_pgmLib);
            this.m_userCfg.setString("strdbgPgmName", this.m_pgmName);
            this.m_userCfg.setInt("strdbgPgmType", this.m_pgmType);
            this.m_userCfg.setString("strdbgPgmParms", this.m_pgmParms);
            this.m_userCfg.setString("strdbgClassPath", this.m_classPath);
            this.m_userCfg.setString("strdbgHostSrcPath", this.m_hostSrcPath);
            this.m_userCfg.setString("strdbgClientSrcPath", this.m_clientSrcPath);
            this.m_userCfg.setString("strdbgJobName", this.m_jobName);
            this.m_userCfg.setString("strdbgJobUser", this.m_jobUser);
            this.m_userCfg.setString("strdbgJobNum", this.m_jobNum);
            this.m_userCfg.setBool("strdbgSubmit", this.m_submitJob);
            if (this.m_cmdSupported) {
                this.m_userCfg.setString("strdbgCmd", this.m_cmd);
            }
            if (this.m_ioSupported) {
                this.m_userCfg.setBool("strdbgRedirectIO", this.m_redirectIO);
            }
            if (this.m_IlePaseSupported) {
                this.m_userCfg.setBool("strdbgIlePase", this.m_debugIlePase);
            }
            this.setCanceled(false);
            this.dispose();
        } else if (bl) {
            if (string.length() == 0) {
                this.m_obj1Ctrl.requestFocus();
            } else {
                this.m_obj2Ctrl.requestFocus();
            }
            this.getToolkit().beep();
        } else {
            if (string9.length() == 0) {
                this.m_jobNameCtrl.requestFocus();
            } else if (string10.length() == 0) {
                this.m_jobUserCtrl.requestFocus();
            } else if (string11.length() < 6) {
                this.m_jobNumCtrl.requestFocus();
            } else if (string.length() == 0) {
                this.m_obj1Ctrl.requestFocus();
            } else {
                this.m_obj2Ctrl.requestFocus();
            }
            this.getToolkit().beep();
        }
    }

    private void doRecent() {
        ArrayList arrayList = this.m_settingsMgr.getRecentPgms();
        int n = arrayList.size();
        if (n == 0) {
            this.m_recentButton.setEnabled(false);
            return;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(i);
            stringArray[i] = pgmDescriptor.getPgmPath();
        }
        PickFromListDialog pickFromListDialog = new PickFromListDialog(this, MRI.get("DBG_RECENT_PGM_DIALOG_TITLE"), MRI.get("DBG_SELECT_PGM_LABEL"), MRI.get("DBG_OK"), null, stringArray, 0);
        pickFromListDialog.setSingleSelect();
        pickFromListDialog.display();
        if (!pickFromListDialog.wasCanceled()) {
            int n2 = pickFromListDialog.getSelectedIndex();
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(n2);
            int n3 = this.indexToPgmType(this.m_typeCtrl.getSelectedIndex());
            int n4 = pgmDescriptor.getPgmType();
            if (n4 != n3) {
                if (n4 == 1 && this.m_submitJob) {
                    this.m_submitJob = false;
                    this.m_specifyCtrl.setSelected(true);
                    this.enableJobControls(!this.m_submitJob);
                    this.enablePgmControls(this.m_submitJob);
                }
                this.m_typeCtrl.setSelectedIndex(this.pgmTypeToIndex(n4));
            }
            switch (n4) {
                case 0: 
                case 1: {
                    this.m_obj1Ctrl.setText(pgmDescriptor.getPgmName());
                    this.m_obj2Ctrl.setText(pgmDescriptor.getPgmLibrary());
                    break;
                }
                case 2: {
                    this.m_obj1Ctrl.setText(pgmDescriptor.getPgmLibrary());
                    this.m_obj2Ctrl.setText(pgmDescriptor.getPgmName());
                }
            }
            this.m_pgmParmsCtrl.setText(pgmDescriptor.getPgmParms());
        }
    }

    private void doEditParms() {
        String string = this.m_pgmParmsCtrl.getText().trim();
        String string2 = " '";
        char c = ' ';
        String string3 = MRI.get("DBG_PARAMETERS_LABEL");
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this, MRI.get("DBG_EDIT_PARMS_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_PARM_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            this.m_pgmParms = tokenEditorDialog.getTokenString();
            this.m_pgmParmsCtrl.setText(this.m_pgmParms);
        }
    }

    public void doEditPath(int n) {
        String string = null;
        String string2 = null;
        char c = ';';
        String string3 = null;
        switch (n) {
            case 0: {
                string = this.m_hostSrcPathCtrl.getText().trim();
                string2 = ":";
                c = ':';
                string3 = MRI.get("DBG_HOST_SOURCE_PATH_LABEL");
                break;
            }
            case 1: {
                string = this.m_clientSrcPathCtrl.getText().trim();
                string2 = File.pathSeparator;
                c = File.pathSeparatorChar;
                string3 = MRI.get("DBG_CLIENT_SOURCE_PATH_LABEL");
                break;
            }
            case 2: {
                string = this.m_classPathCtrl.getText().trim();
                string2 = ":";
                c = ':';
                string3 = MRI.get("DBG_CLASS_PATH_LABEL");
            }
        }
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this, MRI.get("DBG_EDIT_PATH_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_NEW_PATH_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            switch (n) {
                case 0: {
                    this.m_hostSrcPath = tokenEditorDialog.getTokenString();
                    this.m_hostSrcPathCtrl.setText(this.m_hostSrcPath);
                    break;
                }
                case 1: {
                    this.m_clientSrcPath = tokenEditorDialog.getTokenString();
                    this.m_clientSrcPathCtrl.setText(this.m_clientSrcPath);
                    break;
                }
                case 2: {
                    this.m_classPath = tokenEditorDialog.getTokenString();
                    this.m_classPathCtrl.setText(this.m_classPath);
                }
            }
        }
    }

    private void doBrowse() {
        this.postClock();
        BrowseJobDialog browseJobDialog = new BrowseJobDialog(this.m_wnd, this, this.m_settingsMgr, this.m_user);
        browseJobDialog.display(this.m_wnd);
        if (!browseJobDialog.wasCanceled()) {
            this.m_jobNameCtrl.setText(browseJobDialog.getJobName());
            this.m_jobUserCtrl.setText(browseJobDialog.getJobUser());
            this.m_jobNumCtrl.setText(browseJobDialog.getJobNumber());
        }
        this.retractClock();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(OBJ1) || string.equals(OBJ2) || string.equals(PARMS) || string.equals(CMD) || string.equals(CLASSPATH) || string.equals(SRCPATH) || string.equals(JOB_NAME) || string.equals(JOB_USER) || string.equals(JOB_NUM) || string.equals("doit")) {
            this.doOk();
        } else if (string.equals(TYPE)) {
            this.validateType();
        } else if (string.equals(SUBMIT)) {
            this.m_submitJob = true;
            this.enableJobControls(!this.m_submitJob);
            this.enablePgmControls(this.m_submitJob);
        } else if (string.equals(SPECIFY)) {
            this.m_submitJob = false;
            this.enableJobControls(!this.m_submitJob);
            this.enablePgmControls(this.m_submitJob);
        } else if (string.equals(ILE_PASE)) {
            this.validateIlePase();
        } else if (string.equals(RECENT)) {
            this.doRecent();
        } else if (string.equals(BROWSE)) {
            this.doBrowse();
        } else if (string.equals(PARMS_BUTTON)) {
            this.doEditParms();
        } else if (string.equals(CLASSPATH_BUTTON)) {
            this.doEditPath(2);
        } else if (string.equals(HOST_BUTTON)) {
            this.doEditPath(0);
        } else if (string.equals(CLIENT_BUTTON)) {
            this.doEditPath(1);
        }
    }

    public void objNameInsertFailed(int n, String string) {
        if (string.length() > 0 && Character.isDigit(string.charAt(0)) && string.indexOf(47) > 0) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2++);
            int n3 = n2;
            if ((n2 = string.indexOf(47, n3)) > n3) {
                String string3 = Util.firstUpper(string.substring(n3, n2++));
                String string4 = Util.firstUpper(string.substring(n2));
                this.m_jobNameCtrl.setText(string4);
                this.m_jobUserCtrl.setText(string3);
                this.m_jobNumCtrl.setText(string2);
            } else {
                this.getToolkit().beep();
            }
        } else {
            this.getToolkit().beep();
        }
    }

    public void jobNumInsertFailed(int n, String string) {
        this.objNameInsertFailed(n, string);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component;
        String string;
        if (!focusEvent.isTemporary() && (string = ((JTextField)(component = focusEvent.getComponent())).getText().trim()).startsWith(USER_KEY_FLAG)) {
            ((JTextField)component).setText(this.m_userAliases.getString(string.substring(1), string));
        }
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            String string = StartDebugDialog.this.m_obj1Ctrl.getText();
            String string2 = StartDebugDialog.this.m_obj2Ctrl.getText();
            if (string.length() == 0 || string2.length() == 0) {
                switch (StartDebugDialog.this.indexToPgmType(StartDebugDialog.this.m_typeCtrl.getSelectedIndex())) {
                    case 0: 
                    case 1: {
                        StartDebugDialog.this.m_obj1Ctrl.requestFocus();
                        StartDebugDialog.this.m_obj1Ctrl.selectAll();
                        break;
                    }
                    case 2: {
                        if (string.length() == 0) {
                            StartDebugDialog.this.m_obj1Ctrl.requestFocus();
                            StartDebugDialog.this.m_obj1Ctrl.selectAll();
                            break;
                        }
                        StartDebugDialog.this.m_obj2Ctrl.requestFocus();
                        StartDebugDialog.this.m_obj2Ctrl.selectAll();
                    }
                }
            } else if (!StartDebugDialog.this.m_submitJob) {
                if (StartDebugDialog.this.m_jobName.length() == 0) {
                    StartDebugDialog.this.m_jobNameCtrl.requestFocus();
                    StartDebugDialog.this.m_jobNameCtrl.selectAll();
                } else if (StartDebugDialog.this.m_jobUser.length() == 0) {
                    StartDebugDialog.this.m_jobUserCtrl.requestFocus();
                    StartDebugDialog.this.m_jobUserCtrl.selectAll();
                } else if (StartDebugDialog.this.m_jobNumCtrl.isEnabled()) {
                    StartDebugDialog.this.m_jobNumCtrl.requestFocus();
                    StartDebugDialog.this.m_jobNumCtrl.selectAll();
                } else {
                    StartDebugDialog.this.m_obj1Ctrl.requestFocus();
                    StartDebugDialog.this.m_obj1Ctrl.selectAll();
                }
            } else {
                StartDebugDialog.this.m_doItButton.requestFocus();
            }
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

