/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.action;

import com.ibm.iseries.debug.dialog.FindDialog;
import com.ibm.iseries.debug.request.FindRequest;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.Util;
import java.awt.Toolkit;
import java.text.MessageFormat;

public class FindAction
extends Action {
    private String m_lastFind = "";
    private int m_lastDirection = 1;
    private boolean m_lastWrap = true;
    private String m_lastPanelFind = "";

    public FindAction() {
        super("find", MRI.get("DBG_FIND_MENU"), 70, 2, false);
    }

    public void run() {
        if (this.m_ctxt.getActivePanel() == null) {
            this.findInSource();
        } else {
            this.findInPanel();
        }
    }

    public String getLastFindText() {
        return this.m_lastFind;
    }

    protected boolean isCaseSensitive() {
        return false;
    }

    public void findInSource() {
        DebugSource debugSource = this.m_ctxt.getActiveSource();
        boolean bl = this.isCaseSensitive();
        if (debugSource != null) {
            String string = debugSource.getSelectedText();
            if (string == null || string.length() == 1 && (string.equals("\r") || string.equals("\n"))) {
                FindDialog findDialog = new FindDialog(this.m_ctxt.getJFrame(), this.m_lastFind, this.m_lastDirection, this.m_lastWrap);
                findDialog.display(this.m_ctxt);
                string = null;
                if (!findDialog.wasCanceled()) {
                    string = findDialog.getText();
                    this.m_lastDirection = findDialog.getDirection();
                    this.m_lastWrap = findDialog.getWrap();
                }
            }
            if (string != null && string.length() > 0) {
                this.m_lastFind = string;
                this.m_ctxt.postClock();
                this.m_ctxt.clearMessage();
                boolean bl2 = debugSource.isFullSource();
                boolean bl3 = this.m_lastWrap && bl2;
                int n = debugSource.findText(string, this.m_lastDirection, bl, bl3);
                if (n < 0) {
                    if (bl2) {
                        Object[] objectArray = new Object[]{string};
                        String string2 = MessageFormat.format(MRI.get("DBG_FIND_FAILED_FMT"), objectArray);
                        this.m_ctxt.setMessage(string2);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.m_ctxt.postClock();
                        String string3 = Util.firstUpper(Util.getSystemShortName(this.m_ctxt.getSystem()));
                        Object[] objectArray = new Object[]{string, string3};
                        String string4 = MessageFormat.format(MRI.get("DBG_FIND_ON_SERVER_FMT"), objectArray);
                        this.m_ctxt.setMessage(string4);
                        int n2 = this.m_lastDirection == 1 ? debugSource.getEndLineNum() + 1 : debugSource.getStartLineNum() - 1;
                        FindRequest findRequest = new FindRequest(debugSource.getViewId(), string, n2, this.m_lastDirection, this.m_lastWrap);
                        this.m_ctxt.sendRequest(findRequest);
                    }
                } else {
                    Object[] objectArray = new Object[]{string, new Integer(n)};
                    String string5 = MessageFormat.format(MRI.get("DBG_FIND_SUCCESSFUL_FMT"), objectArray);
                    this.m_ctxt.setMessage(string5);
                }
                this.m_ctxt.retractClock();
            }
        }
    }

    private void findInPanel() {
        TabPanel tabPanel = this.m_ctxt.getActivePanel();
        if (tabPanel == null || !tabPanel.canDoFind()) {
            return;
        }
        String string = Util.getInput(this.m_ctxt.getJFrame(), MRI.get("DBG_FIND"), MRI.get("DBG_FIND_TEXT_LABEL"), this.m_lastPanelFind);
        if (string != null && string.length() > 0) {
            this.m_lastPanelFind = string;
            if (!tabPanel.find(string)) {
                Object[] objectArray = new Object[]{string};
                String string2 = MessageFormat.format(MRI.get("DBG_FIND_FAILED_FMT"), objectArray);
                this.m_ctxt.setMessage(string2);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

