/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;

public class DebugFrame
extends JFrame
implements DebugConstants,
ChangeListener {
    protected static final String ANIMATED_GIF = "/com/ibm/iseries/debug/dbg000.gif";
    protected static final String NORMAL_GIF = "/com/ibm/iseries/debug/dbg061.gif";
    protected static final String ERROR_GIF = "/com/ibm/iseries/debug/dbg057.gif";
    protected static final String PAUSE_GIF = "/com/ibm/iseries/debug/dbg065.gif";
    protected static final String WATCH_GIF = "/com/ibm/iseries/debug/dbg059.gif";
    protected static final String BREAK_GIF = "/com/ibm/iseries/debug/dbg060.gif";
    protected static final String PGMEND_GIF = "/com/ibm/iseries/debug/dbg062.gif";
    protected static final String ENDDBG_GIF = "/com/ibm/iseries/debug/dbg058.gif";
    protected static final String STRDBG_GIF = "/com/ibm/iseries/debug/dbg068.gif";
    protected static final String WND_NORMAL_GIF = "/com/ibm/iseries/debug/dbg023.gif";
    protected static final String WND_STRDBG_GIF = "/com/ibm/iseries/debug/dbg031.gif";
    protected static final String WND_ERROR_GIF = "/com/ibm/iseries/debug/dbg055.gif";
    protected static final String WND_PAUSE_GIF = "/com/ibm/iseries/debug/dbg066.gif";
    protected static final String WND_WATCH_GIF = "/com/ibm/iseries/debug/dbg056.gif";
    protected static final String WND_BREAK_GIF = "/com/ibm/iseries/debug/dbg053.gif";
    protected static final String WND_PGMEND_GIF = "/com/ibm/iseries/debug/dbg067.gif";
    protected static final String WND_ENDDBG_GIF = "/com/ibm/iseries/debug/dbg054.gif";
    protected static final int ANIMATION_TIMER = 750;
    protected static ArrayList s_frame = new ArrayList();
    protected DebugContextRec[] m_ctxtRec;
    protected int m_ctxtCount;
    protected int m_ctxtIndex;
    protected DebugContext m_ctxt;
    protected JPanel m_contentPane;
    protected JTabbedPane m_tabPane;
    protected Menubar m_menuBar;
    protected Toolbar m_toolBar;
    protected JToolBar m_iconToolBar;
    protected JLabel m_iconLabel;
    protected JPanel m_toolBarPanel;
    protected MsgText m_msgText;
    protected ImageIcon m_animatedIcon;
    protected ImageIcon m_normalIcon;
    protected ImageIcon m_wndIcon;
    protected ImageIcon m_wndErrorIcon;
    protected ImageIcon m_wndPauseIcon;
    protected ImageIcon m_wndWatchIcon;
    protected ImageIcon m_wndBreakIcon;
    protected ImageIcon m_wndPgmEndIcon;
    protected ImageIcon m_wndEndDbgIcon;
    protected ImageIcon m_wndStrDbgIcon;
    protected ImageIcon m_errorIcon;
    protected ImageIcon m_pauseIcon;
    protected ImageIcon m_watchIcon;
    protected ImageIcon m_breakIcon;
    protected ImageIcon m_pgmEndIcon;
    protected ImageIcon m_endDbgIcon;
    protected ImageIcon m_strDbgIcon;
    protected int m_currentIcon = 0;
    protected boolean m_closed;
    boolean m_exitEnabled = true;

    public static ArrayList getAllDebugFrames() {
        return s_frame;
    }

    public static boolean debugFrameExists(DebugFrame debugFrame) {
        int n = s_frame.size();
        for (int i = 0; i < n; ++i) {
            DebugFrame debugFrame2 = (DebugFrame)s_frame.get(i);
            if (debugFrame2 != debugFrame) continue;
            return true;
        }
        return false;
    }

    public DebugFrame() {
        Util.registerApp();
        this.setDefaultCloseOperation(2);
        s_frame.add(this);
        MRI.init();
        this.m_animatedIcon = MRI.getIcon(0, ANIMATED_GIF);
        this.m_normalIcon = MRI.getIcon(0, NORMAL_GIF);
        this.m_animatedIcon = MRI.getIcon(0, ANIMATED_GIF);
        this.m_normalIcon = MRI.getIcon(0, NORMAL_GIF);
        this.m_errorIcon = MRI.getIcon(0, ERROR_GIF);
        this.m_pauseIcon = MRI.getIcon(0, PAUSE_GIF);
        this.m_watchIcon = MRI.getIcon(0, WATCH_GIF);
        this.m_breakIcon = MRI.getIcon(0, BREAK_GIF);
        this.m_pgmEndIcon = MRI.getIcon(0, PGMEND_GIF);
        this.m_endDbgIcon = MRI.getIcon(0, ENDDBG_GIF);
        this.m_strDbgIcon = MRI.getIcon(0, STRDBG_GIF);
        this.m_wndIcon = MRI.getIcon(0, WND_NORMAL_GIF);
        this.m_wndErrorIcon = MRI.getIcon(0, WND_ERROR_GIF);
        this.m_wndPauseIcon = MRI.getIcon(0, WND_PAUSE_GIF);
        this.m_wndWatchIcon = MRI.getIcon(0, WND_WATCH_GIF);
        this.m_wndBreakIcon = MRI.getIcon(0, WND_BREAK_GIF);
        this.m_wndPgmEndIcon = MRI.getIcon(0, WND_PGMEND_GIF);
        this.m_wndEndDbgIcon = MRI.getIcon(0, WND_ENDDBG_GIF);
        this.m_wndStrDbgIcon = MRI.getIcon(0, WND_STRDBG_GIF);
        this.setIconImage(this.m_wndIcon.getImage());
        this.m_contentPane = new JPanel(new BorderLayout());
        this.m_iconToolBar = new JToolBar();
        this.m_toolBarPanel = new JPanel(new BorderLayout());
        this.m_iconLabel = new JLabel(this.m_normalIcon);
        this.m_iconToolBar.setFloatable(false);
        this.m_iconToolBar.setMargin(new Insets(2, 0, 2, 0));
        this.m_iconToolBar.add(this.m_iconLabel);
        this.m_iconToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.m_toolBarPanel.add((Component)this.m_iconToolBar, MRI.isLtoR() ? "East" : "West");
        this.m_msgText = new MsgText();
        this.m_msgText.setUI(new upArrowBasicComboBoxUI());
        Util.setOrientation(this);
        Util.setOrientation(this.m_iconLabel);
        Util.setOrientation(this.m_msgText);
        this.m_contentPane.add((Component)this.m_toolBarPanel, "North");
        this.m_contentPane.add((Component)this.m_msgText, "South");
        this.setContentPane(this.m_contentPane);
        this.addWindowListener(new WndAdapter());
    }

    public int getTabHeight() {
        int n = 0;
        if (this.m_ctxtCount > 0) {
            Rectangle rectangle = this.m_tabPane.getBounds();
            Rectangle rectangle2 = this.m_ctxt.getComponent().getBounds();
            n = rectangle.height - rectangle2.height;
        }
        return n;
    }

    public boolean hasMultipleContexts() {
        return this.m_ctxtCount > 1;
    }

    public void addInitialDebugContext(DebugContext debugContext) {
        if (this.m_ctxtRec == null && this.m_ctxtCount == 0) {
            this.m_ctxt = debugContext;
            this.m_ctxtIndex = 0;
            this.m_ctxtCount = 1;
            this.m_ctxtRec = new DebugContextRec[this.m_ctxtCount];
            this.m_ctxtRec[0] = new DebugContextRec(debugContext);
            this.m_menuBar = debugContext.getMenubar();
            this.setJMenuBar(this.m_menuBar);
            this.m_toolBar = debugContext.getToolbar();
            this.m_toolBarPanel.add((Component)this.m_toolBar, "Center");
            this.m_contentPane.add((Component)debugContext.getComponent(), "Center");
            Dimension dimension = this.getToolkit().getScreenSize();
            Settings settings = debugContext.getUserConfig();
            int n = settings.getInt("windowLeft", 100);
            int n2 = settings.getInt("windowTop", 100);
            if (n < 0 || n > dimension.width) {
                n = 0;
            }
            if (n2 < 0 || n2 > dimension.height) {
                n2 = 0;
            }
            this.setLocation(n, n2);
        }
    }

    public void appendDebugContext(DebugContext debugContext, boolean bl) {
        if (this.m_ctxtRec != null && this.m_ctxtCount > 0) {
            if (bl) {
                this.m_ctxt.setPartnerContext(debugContext);
                debugContext.setPartnerContext(this.m_ctxt);
                debugContext.supportAction("strdbg", false);
                debugContext.supportAction("enddbg", false);
                debugContext.supportAction("rstrdbg", false);
                debugContext.supportAction("kill", false);
                this.m_ctxt.enableAction("pauset", true);
            }
            DebugContextRec[] debugContextRecArray = this.m_ctxtRec;
            this.m_ctxtCount = debugContextRecArray.length + 1;
            this.m_ctxtRec = new DebugContextRec[this.m_ctxtCount];
            for (int i = 0; i < debugContextRecArray.length; ++i) {
                this.m_ctxtRec[i] = debugContextRecArray[i];
            }
            this.m_ctxtRec[this.m_ctxtCount - 1] = new DebugContextRec(debugContext);
            if (this.m_tabPane == null) {
                this.m_tabPane = new JTabbedPane();
                this.m_tabPane.addTab(this.m_ctxt.getDebuggerName(), this.m_ctxt.getComponent());
                this.m_contentPane.remove(this.m_ctxt.getComponent());
                this.m_contentPane.add(this.m_tabPane);
                this.m_tabPane.addChangeListener(this);
            }
            this.m_tabPane.addTab(this.m_ctxtRec[this.m_ctxtCount - 1].m_ctxt.getDebuggerName(), this.m_ctxtRec[this.m_ctxtCount - 1].m_ctxt.getComponent());
            if (bl) {
                this.m_tabPane.setSelectedComponent(this.m_ctxt.getComponent());
                this.m_ctxt.setTitle();
            } else {
                this.m_tabPane.setSelectedComponent(this.m_ctxtRec[this.m_ctxtCount - 1].m_ctxt.getComponent());
            }
            this.m_contentPane.validate();
        }
    }

    public void removeDebugContext(DebugContext debugContext) {
        int n = this.getContextIndex(debugContext);
        debugContext.getPgmEnv().autoSave();
        debugContext.cleanUp();
        DebugContextRec[] debugContextRecArray = this.m_ctxtRec;
        this.m_ctxt = this.m_ctxtRec[0].m_ctxt;
        this.m_ctxtIndex = 0;
        this.m_ctxtCount = debugContextRecArray.length - 1;
        this.m_ctxtRec = new DebugContextRec[this.m_ctxtCount];
        int n2 = 0;
        for (int i = 0; i < debugContextRecArray.length; ++i) {
            if (i == n) continue;
            this.m_ctxtRec[n2] = debugContextRecArray[i];
            if (this.m_ctxtRec[n2].m_ctxt.getPartnerContext() == debugContext) {
                this.m_ctxtRec[n2].m_ctxt.setPartnerContext(null);
            }
            ++n2;
        }
        this.m_menuBar = this.m_ctxt.getMenubar();
        this.setJMenuBar(this.m_menuBar);
        this.m_toolBarPanel.remove(this.m_toolBar);
        this.m_toolBar = this.m_ctxt.getToolbar();
        this.m_toolBarPanel.add((Component)this.m_toolBar, "Center");
        this.m_ctxt.setTitle();
        this.setDebugIcon(this.m_ctxt, this.m_ctxtRec[this.m_ctxtIndex].m_iconCode, this.m_ctxtRec[this.m_ctxtIndex].m_iconTooltip);
        this.setMessage(this.m_ctxt, this.m_ctxtRec[this.m_ctxtIndex].m_msg);
        this.m_contentPane.remove(this.m_tabPane);
        this.m_contentPane.add((Component)this.m_ctxt.getComponent(), "Center");
        this.m_contentPane.validate();
        this.m_tabPane.removeChangeListener(this);
        this.m_tabPane = null;
    }

    public boolean isMasterContext(DebugContext debugContext) {
        return this.m_ctxtCount > 0 && debugContext == this.m_ctxtRec[0].m_ctxt;
    }

    public boolean isSlaveContext(DebugContext debugContext) {
        return this.m_ctxtCount > 1 && debugContext == this.m_ctxtRec[1].m_ctxt;
    }

    protected int getContextIndex(DebugContext debugContext) {
        if (this.m_ctxtCount == 1) {
            return 0;
        }
        if (this.m_ctxt == debugContext) {
            return this.m_ctxtIndex;
        }
        if (this.m_ctxtIndex == 0) {
            return 1;
        }
        return 0;
    }

    public void bringToFront(DebugContext debugContext) {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
        if (this.m_ctxtCount > 1 && this.m_ctxt != debugContext) {
            this.m_tabPane.setSelectedComponent(debugContext.getComponent());
        }
    }

    public void enableExit() {
        this.m_exitEnabled = true;
    }

    public void disableExit() {
        this.m_exitEnabled = false;
    }

    public void close() {
        int n;
        if (this.m_closed) {
            return;
        }
        Util.deregisterApp();
        this.m_closed = true;
        int n2 = s_frame.size();
        for (n = 0; n < n2; ++n) {
            DebugFrame debugFrame = (DebugFrame)s_frame.get(n);
            if (debugFrame != this) continue;
            s_frame.remove(n);
            break;
        }
        for (n = 0; n < this.m_ctxtRec.length; ++n) {
            this.m_ctxtRec[n].cleanUp();
        }
        this.m_ctxtRec = null;
        this.m_ctxt = null;
        this.m_contentPane = null;
        this.m_tabPane = null;
        this.m_menuBar = null;
        this.m_toolBar = null;
        this.m_iconToolBar = null;
        this.m_iconLabel = null;
        this.m_toolBarPanel = null;
        this.m_msgText = null;
        this.m_animatedIcon = null;
        this.m_normalIcon = null;
        this.m_wndIcon = null;
        this.m_wndErrorIcon = null;
        this.m_wndPauseIcon = null;
        this.m_wndWatchIcon = null;
        this.m_wndBreakIcon = null;
        this.m_wndPgmEndIcon = null;
        this.m_wndEndDbgIcon = null;
        this.m_wndStrDbgIcon = null;
        this.m_errorIcon = null;
        this.m_pauseIcon = null;
        this.m_watchIcon = null;
        this.m_breakIcon = null;
        this.m_pgmEndIcon = null;
        this.m_endDbgIcon = null;
        this.m_strDbgIcon = null;
        if (Util.getAppCount() == 0 && this.m_exitEnabled) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void setMessage(DebugContext debugContext, String string) {
        int n = this.getContextIndex(debugContext);
        this.m_ctxtRec[n].m_msg = string;
        if (n == this.m_ctxtIndex) {
            if (this.m_msgText.getItemCount() > 30) {
                this.m_msgText.removeItemAt(0);
            }
            this.m_msgText.addItem(this.makeObj(string));
            this.m_msgText.setSelectedIndex(this.m_msgText.getItemCount() - 1);
        }
    }

    public void clearMessage(DebugContext debugContext) {
    }

    public void setDebugIcon(DebugContext debugContext, int n) {
        int n2 = this.getContextIndex(debugContext);
        this.m_ctxtRec[n2].m_iconCode = n;
        if (n2 == this.m_ctxtIndex && this.m_currentIcon != n) {
            this.m_currentIcon = n;
            switch (this.m_currentIcon) {
                case 2: {
                    this.m_iconLabel.setIcon(this.m_errorIcon);
                    this.setIconImage(this.m_wndErrorIcon.getImage());
                    break;
                }
                case 3: {
                    this.m_iconLabel.setIcon(this.m_pauseIcon);
                    this.setIconImage(this.m_wndPauseIcon.getImage());
                    break;
                }
                case 4: {
                    this.m_iconLabel.setIcon(this.m_watchIcon);
                    this.setIconImage(this.m_wndWatchIcon.getImage());
                    break;
                }
                case 5: {
                    this.m_iconLabel.setIcon(this.m_breakIcon);
                    this.setIconImage(this.m_wndBreakIcon.getImage());
                    break;
                }
                case 6: {
                    this.m_iconLabel.setIcon(this.m_pgmEndIcon);
                    this.setIconImage(this.m_wndPgmEndIcon.getImage());
                    if (debugContext.getPgmPath().length() > 0) {
                        Object[] objectArray = new Object[]{debugContext.getPgmPath()};
                        String string = MessageFormat.format(MRI.get("DBG_PGM_COMPLETED_FMT"), objectArray);
                        this.setDebugIconTooltip(debugContext, string);
                        break;
                    }
                    Object[] objectArray = new Object[]{debugContext.getJobId()};
                    String string = MessageFormat.format(MRI.get("DBG_PROCESS_COMPLETED_FMT"), objectArray);
                    this.setDebugIconTooltip(debugContext, string);
                    break;
                }
                case 7: {
                    this.m_iconLabel.setIcon(this.m_endDbgIcon);
                    this.setIconImage(this.m_wndEndDbgIcon.getImage());
                    if (debugContext.getPgmPath().length() > 0) {
                        Object[] objectArray = new Object[]{debugContext.getPgmPath()};
                        String string = MessageFormat.format(MRI.get("DBG_PGM_ENDDBG_FMT"), objectArray);
                        this.setDebugIconTooltip(debugContext, string);
                        break;
                    }
                    Object[] objectArray = new Object[]{debugContext.getJobId()};
                    String string = MessageFormat.format(MRI.get("DBG_PROCESS_ENDDBG_FMT"), objectArray);
                    this.setDebugIconTooltip(debugContext, string);
                    break;
                }
                case 8: {
                    this.m_iconLabel.setIcon(this.m_strDbgIcon);
                    this.setIconImage(this.m_wndStrDbgIcon.getImage());
                    if (debugContext.getPgmPath().length() > 0) {
                        Object[] objectArray = new Object[]{debugContext.getPgmPath()};
                        String string = MessageFormat.format(MRI.get("DBG_PGM_STRDBG_FMT"), objectArray);
                        this.setDebugIconTooltip(debugContext, string);
                        break;
                    }
                    Object[] objectArray = new Object[]{debugContext.getJobId()};
                    String string = MessageFormat.format(MRI.get("DBG_PROCESS_STRDBG_FMT"), objectArray);
                    this.setDebugIconTooltip(debugContext, string);
                    break;
                }
                case 1: {
                    this.m_iconLabel.setIcon(this.m_animatedIcon);
                    this.setIconImage(this.m_wndIcon.getImage());
                    if (debugContext.getPgmPath().length() > 0) {
                        Object[] objectArray = new Object[]{debugContext.getPgmPath()};
                        String string = MessageFormat.format(MRI.get("DBG_PGM_WAITING_FMT"), objectArray);
                        this.setDebugIconTooltip(debugContext, string);
                        break;
                    }
                    Object[] objectArray = new Object[]{debugContext.getJobId()};
                    String string = MessageFormat.format(MRI.get("DBG_PROCESS_WAITING_FMT"), objectArray);
                    this.setDebugIconTooltip(debugContext, string);
                    break;
                }
                default: {
                    this.m_iconLabel.setIcon(this.m_normalIcon);
                    this.setIconImage(this.m_wndIcon.getImage());
                }
            }
        }
    }

    public void setDebugIcon(DebugContext debugContext, int n, String string) {
        this.setDebugIcon(debugContext, n);
        this.setDebugIconTooltip(debugContext, string);
    }

    public void setDebugIconTooltip(DebugContext debugContext, String string) {
        int n = this.getContextIndex(debugContext);
        this.m_ctxtRec[n].m_iconTooltip = string;
        if (n == this.m_ctxtIndex) {
            this.m_iconLabel.setToolTipText(string);
            ((ImageIcon)this.m_iconLabel.getIcon()).setDescription(string);
        }
    }

    public void setTitle(DebugContext debugContext, String string) {
        if (this.m_ctxtCount > 1 && this.m_ctxt != debugContext) {
            return;
        }
        this.setTitle(string);
        this.m_wndIcon.setDescription(string);
        this.m_wndErrorIcon.setDescription(string);
        this.m_wndPauseIcon.setDescription(string);
        this.m_wndWatchIcon.setDescription(string);
        this.m_wndBreakIcon.setDescription(string);
        this.m_wndPgmEndIcon.setDescription(string);
        this.m_wndEndDbgIcon.setDescription(string);
        this.m_wndStrDbgIcon.setDescription(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.m_ctxtIndex = this.m_tabPane.getSelectedIndex();
        this.m_ctxt = this.m_ctxtRec[this.m_ctxtIndex].m_ctxt;
        this.m_ctxt.setTitle();
        this.m_menuBar = this.m_ctxt.getMenubar();
        this.setJMenuBar(this.m_menuBar);
        this.m_toolBarPanel.remove(this.m_toolBar);
        this.m_toolBar = this.m_ctxt.getToolbar();
        this.m_toolBarPanel.add((Component)this.m_toolBar, "Center");
        this.setDebugIcon(this.m_ctxt, this.m_ctxtRec[this.m_ctxtIndex].m_iconCode, this.m_ctxtRec[this.m_ctxtIndex].m_iconTooltip);
        this.setMessage(this.m_ctxt, this.m_ctxtRec[this.m_ctxtIndex].m_msg);
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DebugFrame.this.close();
        }
    }

    private class DebugContextRec {
        public DebugContext m_ctxt;
        public int m_iconCode;
        public String m_iconTooltip;
        public String m_msg;

        public DebugContextRec(DebugContext debugContext) {
            this.m_ctxt = debugContext;
            this.m_iconCode = 0;
        }

        public DebugContextRec(DebugContext debugContext, int n, String string, String string2) {
            this.m_ctxt = debugContext;
            this.m_iconCode = n;
            this.m_iconTooltip = string;
            this.m_msg = string2;
        }

        public void cleanUp() {
            if (this.m_ctxt != null) {
                this.m_ctxt.cleanUp();
                this.m_ctxt = null;
                this.m_iconTooltip = null;
                this.m_msg = null;
            }
        }
    }

    private class MsgText
    extends JComboBox {
        public void firePopupMenuWillBecomeVisible() {
            BasicComboPopup basicComboPopup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
            int n = basicComboPopup.getHeight();
            if (n == 0) {
                n = basicComboPopup.getPreferredSize().height;
            }
            basicComboPopup.setLocation(this.getLocationOnScreen().x, this.getLocationOnScreen().y - n);
            super.firePopupMenuWillBecomeVisible();
        }
    }

    private class upArrowBasicComboBoxUI
    extends BasicComboBoxUI {
        protected JButton createArrowButton() {
            BasicArrowButton basicArrowButton = new BasicArrowButton(1, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
            basicArrowButton.setName("ComboBox.arrowButton");
            return basicArrowButton;
        }
    }
}

